/*
 * Decompiled with CFR 0.152.
 */
package crazypants.util;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.Log;
import java.lang.reflect.Field;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;

@SideOnly(value=Side.CLIENT)
public class RenderPassHelper {
    private static Field worldRenderPass = null;
    private static int savedWorldRenderPass = -1;
    private static int savedEntityRenderPass = -1;

    private RenderPassHelper() {
    }

    public static void setBlockRenderPass(int pass) {
        savedWorldRenderPass = ForgeHooksClient.getWorldRenderPass();
        savedEntityRenderPass = MinecraftForgeClient.getRenderPass();
        RenderPassHelper.setBlockRenderPassImpl(pass);
        RenderPassHelper.setEntityRenderPass(pass);
    }

    private static void setBlockRenderPassImpl(int pass) {
        if (worldRenderPass != null) {
            try {
                worldRenderPass.setInt(null, pass);
            }
            catch (Exception e) {
                Log.warn("Failed to access ForgeHooksClient.worldRenderPass because of: " + e);
                e.printStackTrace();
                worldRenderPass = null;
            }
        }
    }

    public static void clearBlockRenderPass() {
        RenderPassHelper.setBlockRenderPassImpl(savedWorldRenderPass);
        RenderPassHelper.setEntityRenderPass(savedEntityRenderPass);
    }

    public static int getBlockRenderPass() {
        int pass = ForgeHooksClient.getWorldRenderPass();
        if (pass < 0 && (pass = MinecraftForgeClient.getRenderPass()) < 0) {
            pass = 0;
        }
        return pass;
    }

    public static void setEntityRenderPass(int pass) {
        ForgeHooksClient.setRenderPass((int)pass);
    }

    public static void clearEntityRenderPass() {
        ForgeHooksClient.setRenderPass((int)-1);
    }

    public static int getEntityRenderPass() {
        return MinecraftForgeClient.getRenderPass();
    }

    static {
        try {
            worldRenderPass = ForgeHooksClient.class.getDeclaredField("worldRenderPass");
            worldRenderPass.setAccessible(true);
        }
        catch (Exception e) {
            Log.warn("Failed to access ForgeHooksClient.worldRenderPass because of: " + e);
            e.printStackTrace();
        }
    }
}

