/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.common.container.TheContainerBase;
import thaumicenergistics.common.network.packet.client.Packet_C_EssentiaVibrationChamber;
import thaumicenergistics.common.tiles.TileEssentiaVibrationChamber;
import thaumicenergistics.common.utils.EffectiveSide;
import thaumicenergistics.common.utils.ThEUtils;

public class ContainerEssentiaVibrationChamber
extends TheContainerBase {
    private static final int TICK_AVG_COUNT = 4;
    private final TileEssentiaVibrationChamber chamber;
    private float powerPerTick = 0.0f;
    private float powerPercent = 1.0f;
    private float ticksPercent = 1.0f;
    private float ticksRemaningMovingAverage = 0.0f;
    private int averageTicksRemaning;

    public ContainerEssentiaVibrationChamber(EntityPlayer player, World world, int x, int y, int z) {
        super(player);
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEssentiaVibrationChamber)) {
            this.chamber = null;
            return;
        }
        this.chamber = (TileEssentiaVibrationChamber)te;
        if (EffectiveSide.isClientSide()) {
            return;
        }
        this.chamber.registerListener(this);
    }

    public boolean func_75145_c(EntityPlayer player) {
        if (this.chamber != null) {
            return ThEUtils.canPlayerInteractWith(player, (TileEntity)this.chamber);
        }
        return false;
    }

    public float getPowerPercent() {
        return this.powerPercent;
    }

    public float getPowerPerTick() {
        return this.powerPerTick;
    }

    public Aspect getProcessingAspect() {
        if (this.chamber != null) {
            return this.chamber.getProcessingAspect();
        }
        return null;
    }

    public int getStoredEssentiaAmount() {
        if (this.chamber != null) {
            return this.chamber.getEssentiaAmount(null);
        }
        return 0;
    }

    public Aspect getStoredEssentiaAspect() {
        if (this.chamber != null) {
            return this.chamber.getEssentiaType(null);
        }
        return null;
    }

    public float getStoredEssentiaPercent() {
        return 1.0f - (float)this.getStoredEssentiaAmount() / 64.0f;
    }

    public int getTicksRemaining() {
        return this.averageTicksRemaning;
    }

    public float getTicksRemainingPercent() {
        return this.ticksPercent;
    }

    public void onChamberUpdate(float powerPerTick, float maxPowerPerTick, int ticksRemaining, int totalTicks) {
        if (EffectiveSide.isServerSide()) {
            Packet_C_EssentiaVibrationChamber.sendUpdate(this.player, powerPerTick, maxPowerPerTick, ticksRemaining, totalTicks);
        } else {
            this.powerPerTick = powerPerTick;
            this.powerPercent = 1.0f - (maxPowerPerTick > 0.0f ? powerPerTick / maxPowerPerTick : 0.0f);
            if (this.ticksRemaningMovingAverage == 0.0f) {
                this.ticksRemaningMovingAverage = ticksRemaining;
            } else {
                float invertedWeight = 1.0f;
                if ((float)ticksRemaining > this.ticksRemaningMovingAverage) {
                    invertedWeight = 0.3f;
                }
                this.ticksRemaningMovingAverage -= this.ticksRemaningMovingAverage / (4.0f * invertedWeight);
                this.ticksRemaningMovingAverage += (float)ticksRemaining / (4.0f * invertedWeight);
            }
            this.averageTicksRemaning = (int)this.ticksRemaningMovingAverage;
            this.ticksPercent = 1.0f - (totalTicks > 0 ? (float)ticksRemaining / (float)totalTicks : 0.0f);
        }
    }

    @Override
    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (EffectiveSide.isServerSide() && this.chamber != null) {
            this.chamber.removeListener(this);
        }
    }
}

