/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.vecmath;

import com.enderio.core.common.vecmath.Matrix4d;
import com.enderio.core.common.vecmath.Vector2f;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector3f;
import com.enderio.core.common.vecmath.Vector4f;

public class Vertex {
    public Vector3d xyz = new Vector3d();
    public Vector2f uv = null;
    public Vector3f normal = null;
    public Vector4f color = null;
    public int brightness = -1;

    public Vertex() {
    }

    public Vertex(Vertex other) {
        this.xyz.set(other.xyz);
        if (other.uv != null) {
            this.uv = new Vector2f(other.uv);
        }
        if (other.normal != null) {
            this.normal = new Vector3f(other.normal);
        }
        if (other.color != null) {
            this.color = new Vector4f(other.color);
        }
        this.brightness = other.brightness;
    }

    public Vertex(Vector3d xyz, Vector3f normal, Vector2f uv) {
        this.xyz.set(xyz);
        this.normal = new Vector3f(normal);
        this.uv = new Vector2f(uv);
    }

    public Vertex(double x, double y, double z, double u, double v, int brightness, float r, float g, float b, float a) {
        this.xyz.set(x, y, z);
        this.uv = new Vector2f(u, v);
        this.brightness = brightness;
        this.color = new Vector4f(r, g, b, a);
    }

    public Vertex(double x, double y, double z, double u, double v) {
        this.xyz.set(x, y, z);
        this.uv = new Vector2f(u, v);
    }

    public void setXYZ(double x, double y, double z) {
        this.xyz.set(x, y, z);
    }

    public void setUV(double u, double v) {
        if (this.uv == null) {
            this.uv = new Vector2f(u, v);
        } else {
            this.uv.set(u, v);
        }
    }

    public void setNormal(double x, double y, double z) {
        if (this.normal == null) {
            this.normal = new Vector3f();
        }
        this.normal.set((float)x, (float)y, (float)z);
        this.normal.normalize();
    }

    public void setNormal(Vector3f normal2) {
        if (normal2 == null) {
            this.normal = null;
            return;
        }
        this.setNormal(normal2.x, normal2.y, normal2.z);
    }

    public void setBrightness(int brightness) {
        this.brightness = brightness;
    }

    public Vector4f getColor() {
        return this.color;
    }

    public void setColor(Vector4f color) {
        this.color = color;
    }

    public void transform(Matrix4d xform) {
        xform.transform(this.xyz);
        xform.transformNormal(this.normal);
    }

    public void translate(Vector3d trans) {
        this.xyz.add(trans);
    }

    public double x() {
        return this.xyz.x;
    }

    public double y() {
        return this.xyz.y;
    }

    public double z() {
        return this.xyz.z;
    }

    public float nx() {
        return this.normal.x;
    }

    public float ny() {
        return this.normal.y;
    }

    public float nz() {
        return this.normal.z;
    }

    public float u() {
        return this.uv.x;
    }

    public float v() {
        return this.uv.y;
    }

    public float r() {
        return this.color.x;
    }

    public float g() {
        return this.color.y;
    }

    public float b() {
        return this.color.z;
    }

    public float a() {
        return this.color.w;
    }

    public String toString() {
        return "Vertex [xyz=" + this.xyz + ", uv=" + this.uv + ", normal=" + this.normal + ", color=" + this.color + ", brightness=" + this.brightness + "]";
    }
}

