/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import stanhebben.zenscript.ZenParsedFile;
import stanhebben.zenscript.parser.CompiledDFA;
import stanhebben.zenscript.parser.ParseException;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.parser.TokenException;
import stanhebben.zenscript.util.ZenPosition;

public class TokenStream
implements Iterator<Token> {
    private ZenParsedFile file;
    private CountingReader reader;
    private CompiledDFA dfa;
    private Token next;
    private int nextChar;
    private int line;
    private int lineOffset;
    private int tokenMemoryOffset = 0;
    private LinkedList<Token> tokenMemory = new LinkedList();
    private Stack<Integer> marks = new Stack();
    private int tokenMemoryCurrent = 0;

    public TokenStream(Reader reader, CompiledDFA dfa) throws IOException {
        this.reader = new CountingReader(reader);
        this.dfa = dfa;
        this.nextChar = this.reader.read();
        this.line = 1;
        this.lineOffset = 1;
        this.advance();
    }

    public TokenStream(String data, CompiledDFA dfa) throws IOException {
        this(new StringReader(data), dfa);
    }

    public void setFile(ZenParsedFile file) {
        this.file = file;
    }

    public ZenParsedFile getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public int getLineOffset() {
        return this.lineOffset;
    }

    public Token peek() {
        if (this.tokenMemoryCurrent < this.tokenMemoryOffset + this.tokenMemory.size()) {
            return this.tokenMemory.get(this.tokenMemoryCurrent - this.tokenMemoryOffset);
        }
        return this.next;
    }

    public boolean isNext(int type) {
        return this.peek().getType() == type;
    }

    public Token optional(int type) {
        if (this.peek() != null && this.peek().getType() == type) {
            return this.next();
        }
        return null;
    }

    public Token required(int type, String error) {
        Token t = this.peek();
        if (t != null && t.getType() == type) {
            return this.next();
        }
        throw new ParseException(this.file, this.line, this.lineOffset, error);
    }

    public void pushMark() {
        this.marks.push(this.tokenMemoryCurrent);
    }

    public void popMark() {
        this.marks.pop();
        if (this.marks.isEmpty()) {
            this.tokenMemoryOffset = this.tokenMemoryCurrent;
            this.tokenMemory.clear();
        }
    }

    public void reset() {
        this.tokenMemoryCurrent = this.marks.pop();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Token next() {
        if (this.tokenMemoryCurrent < this.tokenMemoryOffset + this.tokenMemory.size()) {
            return this.tokenMemory.get(this.tokenMemoryCurrent++ - this.tokenMemoryOffset);
        }
        Token result = this.next;
        if (this.marks.isEmpty()) {
            ++this.tokenMemoryOffset;
        } else {
            this.tokenMemory.add(result);
        }
        ++this.tokenMemoryCurrent;
        this.advance();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported.");
    }

    protected Token process(Token token) {
        return token;
    }

    private void advance() {
        do {
            this.advanceToken();
        } while (this.next != null && this.next.getType() < 0);
    }

    private void advanceToken() {
        if (this.nextChar < 0) {
            this.next = null;
            return;
        }
        try {
            int _fakeNextChar;
            int state = 0;
            StringBuilder value = new StringBuilder();
            int tLine = this.line;
            int tLineOffset = this.lineOffset;
            int n = _fakeNextChar = this.nextChar > 127 ? 256 : this.nextChar;
            while (this.dfa.transitions[state].containsKey(_fakeNextChar)) {
                if (this.nextChar < 0) {
                    value.append((char)this.nextChar);
                } else {
                    value.appendCodePoint(this.nextChar);
                }
                state = this.dfa.transitions[state].get(_fakeNextChar);
                this.line = this.reader.line;
                this.lineOffset = this.reader.lineOffset;
                this.nextChar = this.reader.read();
                _fakeNextChar = this.nextChar > 127 ? 256 : this.nextChar;
            }
            if (this.line < 0) {
                throw new IllegalStateException("Line cannot be negative");
            }
            if (this.dfa.finals[state] != Integer.MIN_VALUE) {
                if (state == 0) {
                    throw new TokenException(this.file, this.line, this.lineOffset, (char)this.nextChar);
                }
            } else {
                if (this.nextChar < 0 && value.length() == 0) {
                    return;
                }
                throw new TokenException(this.file, this.line, this.lineOffset, (char)this.nextChar);
            }
            this.next = this.process(new Token(value.toString(), this.dfa.finals[state], new ZenPosition(this.file, tLine, tLineOffset)));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private class CountingReader {
        private int line;
        private int lineOffset;
        private Reader reader;
        private boolean eof;

        public CountingReader(Reader reader) {
            this.reader = reader;
            this.line = 1;
            this.lineOffset = 1;
        }

        public int read() throws IOException {
            int ch = this.reader.read();
            if (ch == -1) {
                this.eof = true;
                return ch;
            }
            if (ch == 10) {
                ++this.line;
                this.lineOffset = 1;
            } else {
                ++this.lineOffset;
            }
            return ch;
        }
    }
}

