/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.minecraft.control;

import binnie.craftgui.controls.core.Control;
import binnie.craftgui.core.Attribute;
import binnie.craftgui.core.CraftGUI;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.core.geometry.IBorder;
import binnie.craftgui.core.geometry.IPoint;
import binnie.craftgui.core.geometry.Position;
import binnie.craftgui.core.geometry.TextJustification;
import binnie.craftgui.resource.Texture;
import binnie.craftgui.resource.minecraft.CraftGUITexture;
import org.lwjgl.opengl.GL11;

public class ControlSlide
extends Control {
    private IArea expanded;
    private IArea shrunk;
    private boolean slideActive = true;
    private Position anchor;
    private String label = null;

    public ControlSlide(IWidget parent, float x, float y, float w, float h, Position anchor2) {
        super(parent, x, y, w, h);
        this.addAttribute(Attribute.MouseOver);
        this.addAttribute(Attribute.BlockTooltip);
        this.expanded = new IArea(this.getPosition(), this.getSize());
        this.anchor = anchor2.opposite();
        float border = this.anchor.x() != 0 ? this.expanded.w() - 6.0f : this.expanded.h() - 6.0f;
        this.shrunk = this.expanded.inset(new IBorder(this.anchor, border));
        this.slideActive = false;
    }

    @Override
    public void onRenderBackground() {
        super.onRenderBackground();
        if (this.label != null) {
            float lw = CraftGUI.Render.textWidth(this.label) + 16;
            float lh = CraftGUI.Render.textHeight() + 16;
            boolean hor = this.anchor.x() != 0;
            IArea ar = this.isSlideActive() ? this.expanded : this.shrunk;
            IArea tabArea = new IArea(hor ? -lh / 2.0f : -lw / 2.0f, hor ? -lw / 2.0f : -lh / 2.0f, hor ? lh : lw, hor ? lw : lh);
            IPoint shift = new IPoint(ar.w() * (float)(1 - this.anchor.x()) / 2.0f, ar.h() * (float)(1 - this.anchor.y()) / 2.0f);
            tabArea = tabArea.shift(shift.x() - (-3.0f + lh / 2.0f) * (float)this.anchor.x(), shift.y() - (-3.0f + lh / 2.0f) * (float)this.anchor.y());
            Texture texture = CraftGUI.Render.getTexture((Object)(this.isSlideActive() ? CraftGUITexture.Tab : CraftGUITexture.TabDisabled)).crop(this.anchor.opposite(), 8.0f);
            CraftGUI.Render.texture(texture, tabArea);
            texture = CraftGUI.Render.getTexture((Object)CraftGUITexture.TabOutline).crop(this.anchor.opposite(), 8.0f);
            CraftGUI.Render.texture(texture, tabArea.inset(2));
            IArea labelArea = new IArea(-lw / 2.0f, 0.0f, lw, lh);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(shift.x() + (float)this.anchor.x() * 2.0f), (float)(shift.y() + (float)this.anchor.y() * 2.0f), (float)0.0f);
            if (this.anchor.x() != 0) {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)this.anchor.x());
            }
            if (this.anchor.y() > 0) {
                GL11.glTranslatef((float)0.0f, (float)(-lh), (float)0.0f);
            }
            CraftGUI.Render.text(labelArea, TextJustification.MiddleCenter, this.label, 0xFFFFFF);
            GL11.glPopMatrix();
        }
        CraftGUI.Render.texture((Object)CraftGUITexture.Window, this.getArea());
        CraftGUITexture slideTexture = this.anchor == Position.Bottom ? CraftGUITexture.SlideDown : (this.anchor == Position.Top ? CraftGUITexture.SlideUp : (this.anchor == Position.Left ? CraftGUITexture.SlideLeft : CraftGUITexture.SlideRight));
        CraftGUI.Render.texture((Object)slideTexture, new IPoint(((float)this.anchor.x() + 1.0f) * this.w() / 2.0f - 8.0f, ((float)this.anchor.y() + 1.0f) * this.h() / 2.0f - 8.0f));
    }

    public boolean isSlideActive() {
        return this.slideActive;
    }

    @Override
    public void onUpdateClient() {
        boolean mouseOver = this.isMouseOverWidget(this.getRelativeMousePosition());
        if (mouseOver != this.slideActive) {
            this.setSlide(mouseOver);
        }
    }

    @Override
    public boolean isMouseOverWidget(IPoint relativeMouse) {
        return this.getArea().outset(this.isSlideActive() ? 16 : 8).outset(new IBorder(this.anchor.opposite(), 16.0f)).contains(relativeMouse);
    }

    @Override
    public boolean isChildVisible(IWidget child) {
        return this.slideActive;
    }

    public void setSlide(boolean b) {
        this.slideActive = b;
        IArea area = this.isSlideActive() ? this.expanded : this.shrunk;
        this.setSize(area.size());
        this.setPosition(area.pos());
    }

    public void setLabel(String l) {
        this.label = l;
    }
}

