/*
 * Decompiled with CFR 0.152.
 */
package squeek.asmhelper.me.superckl.biometweaker;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;
import squeek.asmhelper.me.superckl.biometweaker.InsnComparator;
import squeek.asmhelper.me.superckl.biometweaker.ObfHelper;
import squeek.asmhelper.me.superckl.biometweaker.ObfRemappingClassWriter;

public class ASMHelper {
    private static Boolean isCauldron = null;
    public static InsnComparator insnComparator = new InsnComparator();
    private static Printer printer = new Textifier();
    private static TraceMethodVisitor methodprinter = new TraceMethodVisitor(printer);

    public static boolean isCauldron() {
        if (isCauldron == null) {
            try {
                byte[] bytes = ((LaunchClassLoader)ASMHelper.class.getClassLoader()).getClassBytes("net.minecraftforge.cauldron.api.Cauldron");
                isCauldron = bytes != null;
            }
            catch (IOException e) {
                isCauldron = false;
            }
        }
        return isCauldron;
    }

    public static ClassNode readClassFromBytes(byte[] bytes) {
        return ASMHelper.readClassFromBytes(bytes, 0);
    }

    public static ClassNode readClassFromBytes(byte[] bytes, int flags) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, flags);
        return classNode;
    }

    public static byte[] writeClassToBytes(ClassNode classNode) {
        return ASMHelper.writeClassToBytes(classNode, 3);
    }

    public static byte[] writeClassToBytes(ClassNode classNode, int flags) {
        ObfRemappingClassWriter writer = new ObfRemappingClassWriter(flags);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static byte[] writeClassToBytesNoDeobf(ClassNode classNode) {
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static byte[] writeClassToBytesNoDeobfSkipFrames(ClassNode classNode) {
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static InputStream getClassAsStreamFromClassLoader(String className, ClassLoader classLoader) {
        return classLoader.getResourceAsStream(className.replace('.', '/') + ".class");
    }

    public static ClassReader getClassReaderForClassName(String className) throws IOException {
        return new ClassReader(ASMHelper.getClassAsStreamFromClassLoader(className, ASMHelper.class.getClassLoader()));
    }

    public static boolean classHasSuper(ClassReader classReader) {
        return classReader.getSuperName() != null && !classReader.getSuperName().equals("java/lang/Object");
    }

    public static boolean doesClassImplement(ClassReader classReader, String targetInterfaceInternalClassName) {
        List<String> immediateInterfaces = Arrays.asList(classReader.getInterfaces());
        for (String immediateInterface : immediateInterfaces) {
            if (!ObfHelper.getInternalClassName(immediateInterface).equals(targetInterfaceInternalClassName)) continue;
            return true;
        }
        try {
            if (ASMHelper.classHasSuper(classReader)) {
                return ASMHelper.doesClassImplement(ASMHelper.getClassReaderForClassName(ObfHelper.getInternalClassName(classReader.getSuperName())), targetInterfaceInternalClassName);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("raw = " + classReader.getSuperName() + ", obf = " + ObfHelper.getInternalClassName(classReader.getSuperName()), e);
        }
        return false;
    }

    public static boolean doesClassExtend(ClassReader classReader, String targetSuperInternalClassName) {
        if (!ASMHelper.classHasSuper(classReader)) {
            return false;
        }
        String immediateSuperName = ObfHelper.getInternalClassName(classReader.getSuperName());
        if (immediateSuperName.equals(targetSuperInternalClassName)) {
            return true;
        }
        try {
            return ASMHelper.doesClassExtend(ASMHelper.getClassReaderForClassName(immediateSuperName), targetSuperInternalClassName);
        }
        catch (IOException e) {
            throw new RuntimeException("raw = " + classReader.getSuperName() + ", obf = " + immediateSuperName, e);
        }
    }

    public static boolean isLabelOrLineNumber(AbstractInsnNode insn) {
        return insn.getType() == 8 || insn.getType() == 15;
    }

    public static AbstractInsnNode getOrFindInstructionOfType(AbstractInsnNode firstInsnToCheck, int type) {
        return ASMHelper.getOrFindInstructionOfType(firstInsnToCheck, type, false);
    }

    public static AbstractInsnNode getOrFindInstructionOfType(AbstractInsnNode firstInsnToCheck, int type, boolean reverseDirection) {
        AbstractInsnNode instruction = firstInsnToCheck;
        while (instruction != null) {
            if (instruction.getType() == type) {
                return instruction;
            }
            instruction = reverseDirection ? instruction.getPrevious() : instruction.getNext();
        }
        return null;
    }

    public static AbstractInsnNode getOrFindInstructionWithOpcode(AbstractInsnNode firstInsnToCheck, int opcode) {
        return ASMHelper.getOrFindInstructionWithOpcode(firstInsnToCheck, opcode, false);
    }

    public static AbstractInsnNode getOrFindInstructionWithOpcode(AbstractInsnNode firstInsnToCheck, int opcode, boolean reverseDirection) {
        AbstractInsnNode instruction = firstInsnToCheck;
        while (instruction != null) {
            if (instruction.getOpcode() == opcode) {
                return instruction;
            }
            instruction = reverseDirection ? instruction.getPrevious() : instruction.getNext();
        }
        return null;
    }

    public static AbstractInsnNode getOrFindLabelOrLineNumber(AbstractInsnNode firstInsnToCheck) {
        return ASMHelper.getOrFindInstruction(firstInsnToCheck, false);
    }

    public static AbstractInsnNode getOrFindLabelOrLineNumber(AbstractInsnNode firstInsnToCheck, boolean reverseDirection) {
        AbstractInsnNode instruction = firstInsnToCheck;
        while (instruction != null) {
            if (ASMHelper.isLabelOrLineNumber(instruction)) {
                return instruction;
            }
            instruction = reverseDirection ? instruction.getPrevious() : instruction.getNext();
        }
        return null;
    }

    public static AbstractInsnNode getOrFindInstruction(AbstractInsnNode firstInsnToCheck) {
        return ASMHelper.getOrFindInstruction(firstInsnToCheck, false);
    }

    public static AbstractInsnNode getOrFindInstruction(AbstractInsnNode firstInsnToCheck, boolean reverseDirection) {
        AbstractInsnNode instruction = firstInsnToCheck;
        while (instruction != null) {
            if (!ASMHelper.isLabelOrLineNumber(instruction)) {
                return instruction;
            }
            instruction = reverseDirection ? instruction.getPrevious() : instruction.getNext();
        }
        return null;
    }

    public static AbstractInsnNode findFirstInstruction(MethodNode method) {
        return ASMHelper.getOrFindInstruction(method.instructions.getFirst());
    }

    public static AbstractInsnNode findFirstInstructionWithOpcode(MethodNode method, int opcode) {
        return ASMHelper.getOrFindInstructionWithOpcode(method.instructions.getFirst(), opcode);
    }

    public static AbstractInsnNode findLastInstructionWithOpcode(MethodNode method, int opcode) {
        return ASMHelper.getOrFindInstructionWithOpcode(method.instructions.getLast(), opcode, true);
    }

    public static AbstractInsnNode findNextInstruction(AbstractInsnNode instruction) {
        return ASMHelper.getOrFindInstruction(instruction.getNext());
    }

    public static AbstractInsnNode findNextInstructionWithOpcode(AbstractInsnNode instruction, int opcode) {
        return ASMHelper.getOrFindInstructionWithOpcode(instruction.getNext(), opcode);
    }

    public static AbstractInsnNode findNextLabelOrLineNumber(AbstractInsnNode instruction) {
        return ASMHelper.getOrFindLabelOrLineNumber(instruction.getNext());
    }

    public static AbstractInsnNode findPreviousInstruction(AbstractInsnNode instruction) {
        return ASMHelper.getOrFindInstruction(instruction.getPrevious(), true);
    }

    public static AbstractInsnNode findPreviousInstructionWithOpcode(AbstractInsnNode instruction, int opcode) {
        return ASMHelper.getOrFindInstructionWithOpcode(instruction.getPrevious(), opcode, true);
    }

    public static AbstractInsnNode findPreviousLabelOrLineNumber(AbstractInsnNode instruction) {
        return ASMHelper.getOrFindLabelOrLineNumber(instruction.getPrevious(), true);
    }

    public static MethodNode findMethodNodeOfClass(ClassNode classNode, String methodName, String methodDesc) {
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals(methodName) || methodDesc != null && !method.desc.equals(methodDesc)) continue;
            return method;
        }
        return null;
    }

    public static LabelNode findEndLabel(MethodNode method) {
        for (AbstractInsnNode instruction = method.instructions.getLast(); instruction != null; instruction = instruction.getPrevious()) {
            if (!(instruction instanceof LabelNode)) continue;
            return (LabelNode)instruction;
        }
        return null;
    }

    public static int removeFromInsnListUntil(InsnList insnList, AbstractInsnNode startInclusive, AbstractInsnNode endNotInclusive) {
        int numDeleted = 0;
        for (AbstractInsnNode insnToRemove = startInclusive; insnToRemove != null && insnToRemove != endNotInclusive; insnToRemove = insnToRemove.getNext()) {
            ++numDeleted;
            insnList.remove(insnToRemove.getPrevious());
        }
        return numDeleted;
    }

    public static void skipInstructions(InsnList insnList, AbstractInsnNode startInclusive, AbstractInsnNode endNotInclusive) {
        LabelNode skipLabel = new LabelNode();
        JumpInsnNode gotoInsn = new JumpInsnNode(167, skipLabel);
        insnList.insertBefore(startInclusive, (AbstractInsnNode)gotoInsn);
        insnList.insertBefore(endNotInclusive, (AbstractInsnNode)skipLabel);
    }

    public static AbstractInsnNode move(AbstractInsnNode start, int distance) {
        AbstractInsnNode movedTo = start;
        for (int i = 0; i < Math.abs(distance) && movedTo != null; ++i) {
            movedTo = distance > 0 ? movedTo.getNext() : movedTo.getPrevious();
        }
        return movedTo;
    }

    public static boolean instructionsMatch(AbstractInsnNode first, AbstractInsnNode second) {
        return insnComparator.areInsnsEqual(first, second);
    }

    public static boolean patternMatches(InsnList checkFor, AbstractInsnNode checkAgainst) {
        return ASMHelper.checkForPatternAt(checkFor, checkAgainst).getFirst() != null;
    }

    public static InsnList checkForPatternAt(InsnList checkFor, AbstractInsnNode checkAgainst) {
        InsnList foundInsnList = new InsnList();
        boolean firstNeedleFound = false;
        AbstractInsnNode lookFor = checkFor.getFirst();
        while (lookFor != null) {
            if (checkAgainst == null) {
                return new InsnList();
            }
            if (ASMHelper.isLabelOrLineNumber(lookFor)) {
                lookFor = lookFor.getNext();
                continue;
            }
            if (ASMHelper.isLabelOrLineNumber(checkAgainst)) {
                if (firstNeedleFound) {
                    foundInsnList.add(checkAgainst);
                }
                checkAgainst = checkAgainst.getNext();
                continue;
            }
            if (!ASMHelper.instructionsMatch(lookFor, checkAgainst)) {
                return new InsnList();
            }
            foundInsnList.add(checkAgainst);
            lookFor = lookFor.getNext();
            checkAgainst = checkAgainst.getNext();
            firstNeedleFound = true;
        }
        return foundInsnList;
    }

    public static InsnList findAndGetFoundInsnList(AbstractInsnNode haystackStart, InsnList needle) {
        int needleStartOpcode = needle.getFirst().getOpcode();
        AbstractInsnNode checkAgainstStart = ASMHelper.getOrFindInstructionWithOpcode(haystackStart, needleStartOpcode);
        while (checkAgainstStart != null) {
            InsnList found = ASMHelper.checkForPatternAt(needle, checkAgainstStart);
            if (found.getFirst() != null) {
                return found;
            }
            checkAgainstStart = ASMHelper.findNextInstructionWithOpcode(checkAgainstStart, needleStartOpcode);
        }
        return new InsnList();
    }

    public static AbstractInsnNode find(InsnList haystack, InsnList needle) {
        return ASMHelper.find(haystack.getFirst(), needle);
    }

    public static AbstractInsnNode find(AbstractInsnNode haystackStart, InsnList needle) {
        if (needle.getFirst() == null) {
            return null;
        }
        InsnList found = ASMHelper.findAndGetFoundInsnList(haystackStart, needle);
        return found.getFirst();
    }

    public static AbstractInsnNode find(InsnList haystack, AbstractInsnNode needle) {
        return ASMHelper.find(haystack.getFirst(), needle);
    }

    public static AbstractInsnNode find(AbstractInsnNode haystackStart, AbstractInsnNode needle) {
        InsnList insnList = new InsnList();
        insnList.add(needle);
        return ASMHelper.find(haystackStart, insnList);
    }

    public static AbstractInsnNode findAndReplace(InsnList haystack, InsnList needle, InsnList replacement) {
        return ASMHelper.findAndReplace(haystack, needle, replacement, haystack.getFirst());
    }

    public static AbstractInsnNode findAndReplace(InsnList haystack, InsnList needle, InsnList replacement, AbstractInsnNode haystackStart) {
        InsnList found = ASMHelper.findAndGetFoundInsnList(haystackStart, needle);
        if (found.getFirst() != null) {
            haystack.insertBefore(found.getFirst(), replacement);
            AbstractInsnNode afterNeedle = found.getLast().getNext();
            ASMHelper.removeFromInsnListUntil(haystack, found.getFirst(), afterNeedle);
            return afterNeedle;
        }
        return null;
    }

    public static int findAndReplaceAll(InsnList haystack, InsnList needle, InsnList replacement) {
        return ASMHelper.findAndReplaceAll(haystack, needle, replacement, haystack.getFirst());
    }

    public static int findAndReplaceAll(InsnList haystack, InsnList needle, InsnList replacement, AbstractInsnNode haystackStart) {
        int numReplaced = 0;
        while ((haystackStart = ASMHelper.findAndReplace(haystack, needle, replacement, haystackStart)) != null) {
            ++numReplaced;
        }
        return numReplaced;
    }

    public static InsnList cloneInsnList(InsnList source) {
        AbstractInsnNode instruction;
        InsnList clone = new InsnList();
        HashMap<LabelNode, LabelNode> labelMap = new HashMap<LabelNode, LabelNode>();
        for (instruction = source.getFirst(); instruction != null; instruction = instruction.getNext()) {
            if (!(instruction instanceof LabelNode)) continue;
            labelMap.put((LabelNode)instruction, new LabelNode());
        }
        for (instruction = source.getFirst(); instruction != null; instruction = instruction.getNext()) {
            clone.add(instruction.clone(labelMap));
        }
        return clone;
    }

    public static LocalVariableNode findLocalVariableOfMethod(MethodNode method, String varName, String varDesc) {
        for (LocalVariableNode localVar : method.localVariables) {
            if (!localVar.name.equals(varName) || !localVar.desc.equals(varDesc)) continue;
            return localVar;
        }
        return null;
    }

    public static String getInsnListAsString(InsnList insnList) {
        insnList.accept((MethodVisitor)methodprinter);
        StringWriter sw = new StringWriter();
        printer.print(new PrintWriter(sw));
        printer.getText().clear();
        return sw.toString();
    }

    public static String getMethodAsString(MethodNode method) {
        method.accept((MethodVisitor)methodprinter);
        StringWriter sw = new StringWriter();
        printer.print(new PrintWriter(sw));
        printer.getText().clear();
        return sw.toString();
    }
}

