/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLFingerprintViolationEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import me.superckl.api.biometweaker.script.wrapper.BTParameterTypes;
import me.superckl.api.superscript.ScriptCommandManager;
import me.superckl.api.superscript.ScriptCommandRegistry;
import me.superckl.api.superscript.ScriptHandler;
import me.superckl.api.superscript.ScriptParser;
import me.superckl.api.superscript.object.ScriptObject;
import me.superckl.api.superscript.util.ConstructorListing;
import me.superckl.api.superscript.util.ParameterWrapper;
import me.superckl.biometweaker.config.Config;
import me.superckl.biometweaker.core.BiomeTweakerCore;
import me.superckl.biometweaker.proxy.IProxy;
import me.superckl.biometweaker.script.object.BiomesScriptObject;
import me.superckl.biometweaker.script.object.TweakerScriptObject;
import me.superckl.biometweaker.server.command.CommandInfo;
import me.superckl.biometweaker.server.command.CommandListBiomes;
import me.superckl.biometweaker.server.command.CommandOutput;
import me.superckl.biometweaker.server.command.CommandReload;
import me.superckl.biometweaker.server.command.CommandReloadScript;
import me.superckl.biometweaker.server.command.CommandSetBiome;
import me.superckl.biometweaker.util.BiomeHelper;
import me.superckl.biometweaker.util.LogHelper;
import me.superckl.biometweaker.util.ReflectionHelper;
import me.superckl.biometweaker.util.VersionChecker;
import net.minecraft.command.ICommand;
import net.minecraft.world.biome.BiomeGenBase;

@Mod(modid="BiomeTweaker", name="BiomeTweaker", version="2.0.182", guiFactory="me.superckl.biometweaker.client.gui.GuiFactory", acceptableRemoteVersions="*", certificateFingerprint="bdea6e9d19f35da4858ffcc93210c6207dd590bd", dependencies="before:BiomesOPlenty; after:GalacticraftCore")
public class BiomeTweaker {
    @Mod.Instance(value="BiomeTweaker")
    private static BiomeTweaker instance;
    private boolean signed = true;
    @SidedProxy(clientSide="me.superckl.biometweaker.proxy.ClientProxy", serverSide="me.superckl.biometweaker.proxy.ServerProxy")
    private static IProxy proxy;
    private final String[] galactCoreClasses = new String[]{"micdoodle8.mods.galacticraft.core.world.gen.BiomeGenBaseMoon", "micdoodle8.mods.galacticraft.core.world.gen.BiomeGenBaseOrbit"};
    private final String[] galactMarsClasses = new String[]{"micdoodle8.mods.galacticraft.planets.mars.world.gen.BiomeGenBaseMars"};

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent e) {
        this.signed = false;
        LogHelper.warn("Hey... uhm... this is akward but, it looks like you're using an unofficial version of BiomeTweaker. Where exactly did you get this from?");
        LogHelper.warn("Unless I (superckl) sent you this version, don't expect to get any support for it.");
    }

    @Mod.EventHandler
    public void onConstruction(FMLConstructionEvent e) {
        try {
            ScriptCommandRegistry.INSTANCE.registerClassListing(BiomesScriptObject.class, BiomesScriptObject.populateCommands());
            ScriptCommandRegistry.INSTANCE.registerClassListing(TweakerScriptObject.class, TweakerScriptObject.populateCommands());
        }
        catch (Exception e2) {
            LogHelper.error("Failed to populate command listings! Some tweaks may not be applied.");
            e2.printStackTrace();
        }
        ScriptHandler.registerStaticObject("Tweaker", new TweakerScriptObject());
        try {
            ConstructorListing<ScriptObject> listing = new ConstructorListing<ScriptObject>();
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{BTParameterTypes.BASIC_BIOMES_PACKAGE.getVarArgsWrapper()}), BiomesScriptObject.class.getDeclaredConstructor(new Class[0]));
            ScriptParser.registerValidObjectInst("forBiomes", listing);
            listing = new ConstructorListing();
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{BTParameterTypes.TYPE_BIOMES_PACKAGE.getSpecialWrapper()}), BiomesScriptObject.class.getDeclaredConstructor(new Class[0]));
            ScriptParser.registerValidObjectInst("forBiomesOfTypes", listing);
            listing = new ConstructorListing();
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{BTParameterTypes.ALL_BIOMES_PACKAGE.getSpecialWrapper()}), BiomesScriptObject.class.getDeclaredConstructor(new Class[0]));
            ScriptParser.registerValidObjectInst("forAllBiomes", listing);
            listing = new ConstructorListing();
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{BTParameterTypes.ALL_BUT_BIOMES_PACKAGE.getSpecialWrapper()}), BiomesScriptObject.class.getDeclaredConstructor(new Class[0]));
            ScriptParser.registerValidObjectInst("forAllBiomesExcept", listing);
            listing = new ConstructorListing();
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{BTParameterTypes.INTERSECT_BIOMES_PACKAGE.getSpecialWrapper()}), BiomesScriptObject.class.getDeclaredConstructor(new Class[0]));
            ScriptParser.registerValidObjectInst("intersectionOf", listing);
            listing = new ConstructorListing();
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{BTParameterTypes.SUBTRACT_BIOMES_PACKAGE.getSpecialWrapper()}), BiomesScriptObject.class.getDeclaredConstructor(new Class[0]));
            ScriptParser.registerValidObjectInst("subtractFrom", listing);
        }
        catch (Exception e2) {
            LogHelper.error("Failed to populate object listings! Some tweaks may not be applied.");
            e2.printStackTrace();
        }
    }

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent e) {
        if (Config.INSTANCE.isVersionCheck() && !"2.0.182".equals("@VERSION@")) {
            FMLCommonHandler.instance().bus().register((Object)VersionChecker.start("BiomeTweaker", "2.0.182", "1.7.10"));
        }
        this.parseScripts();
        proxy.registerHandlers();
        Config.INSTANCE.getCommandManager().applyCommandsFor(ScriptCommandManager.ApplicationStage.PRE_INIT);
    }

    public void parseScripts() {
        LogHelper.info("Beginning script parsing...");
        long time = System.currentTimeMillis();
        for (JsonElement listElement : Config.INSTANCE.getIncludes()) {
            File subFile = null;
            try {
                String item = listElement.getAsString();
                subFile = new File(Config.INSTANCE.getWhereAreWe(), item);
                this.parseScript(subFile);
            }
            catch (Exception e1) {
                LogHelper.error("Failed to parse a script file! File: " + subFile);
                e1.printStackTrace();
            }
        }
        long diff = System.currentTimeMillis() - time;
        LogHelper.info("Finished script parsing.");
        LogHelper.debug("Script parsing took " + diff + "ms.");
    }

    public void parseScript(File file) throws IOException {
        if (!file.exists()) {
            LogHelper.debug(String.format("Subfile %s not found. A blank one will be generated.", file.getName()));
            file.createNewFile();
        }
        ScriptParser.parseScriptFile(file);
        Config.INSTANCE.getCommandManager().setCurrentStage(ScriptCommandManager.ApplicationStage.FINISHED_LOAD);
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent e) {
        Config.INSTANCE.getCommandManager().applyCommandsFor(ScriptCommandManager.ApplicationStage.INIT);
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent e) {
        Config.INSTANCE.getCommandManager().applyCommandsFor(ScriptCommandManager.ApplicationStage.POST_INIT);
    }

    @Mod.EventHandler
    public void onLoadComplete(FMLLoadCompleteEvent e) throws IOException {
        Config.INSTANCE.getCommandManager().applyCommandsFor(ScriptCommandManager.ApplicationStage.FINISHED_LOAD);
        this.generateOutputFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateOutputFiles() throws IOException {
        LogHelper.info("Generating biome status report...");
        JsonArray array = new JsonArray();
        for (BiomeGenBase gen : BiomeGenBase.func_150565_n()) {
            if (gen == null) continue;
            array.add((JsonElement)BiomeHelper.fillJsonObject(gen, new int[0]));
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File dir = new File(BiomeTweakerCore.mcLocation, "/config/BiomeTweaker/output/");
        dir.mkdirs();
        for (File file : dir.listFiles()) {
            if (!file.getName().endsWith(".json")) continue;
            file.delete();
        }
        if (Config.INSTANCE.isOutputSeperateFiles()) {
            for (JsonElement element : array) {
                JsonObject obj = (JsonObject)element;
                File output = new File(dir, "" + obj.get("Name").getAsString() + ".json");
                if (output.exists()) {
                    output.delete();
                }
                output.createNewFile();
                BufferedWriter writer = new BufferedWriter(new FileWriter(output));
                try {
                    writer.newLine();
                    writer.write(gson.toJson((JsonElement)obj));
                }
                finally {
                    if (Collections.singletonList(writer).get(0) == null) continue;
                    writer.close();
                }
            }
        } else {
            File output = new File(dir, "BiomeTweaker - Biome Status Report.json");
            if (output.exists()) {
                output.delete();
            }
            output.createNewFile();
            BufferedWriter writer = new BufferedWriter(new FileWriter(output));
            try {
                writer.write("//Yeah, it's a doozy.");
                writer.newLine();
                writer.write(gson.toJson((JsonElement)array));
            }
            finally {
                if (Collections.singletonList(writer).get(0) != null) {
                    writer.close();
                }
            }
        }
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent e) {
        e.registerServerCommand((ICommand)new CommandReload());
        e.registerServerCommand((ICommand)new CommandInfo());
        e.registerServerCommand((ICommand)new CommandOutput());
        e.registerServerCommand((ICommand)new CommandListBiomes());
        e.registerServerCommand((ICommand)new CommandSetBiome());
        e.registerServerCommand((ICommand)new CommandReloadScript());
        Config.INSTANCE.getCommandManager().applyCommandsFor(ScriptCommandManager.ApplicationStage.SERVER_STARTING);
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartedEvent e) {
        Config.INSTANCE.getCommandManager().applyCommandsFor(ScriptCommandManager.ApplicationStage.SERVER_STARTED);
    }

    @Mod.EventHandler
    public void GalactCoreCompat(FMLPreInitializationEvent e) {
        LogHelper.info("Attempting to load compat. biome classes...");
        this.loadCompatClasses(this.galactCoreClasses);
        this.loadCompatClasses(this.galactMarsClasses);
    }

    private void loadCompatClasses(String ... classes) {
        for (String clazz : classes) {
            if (ReflectionHelper.tryLoadClass(clazz) != null) continue;
            LogHelper.debug("Failed to load compat. biome class " + clazz);
        }
    }

    public static BiomeTweaker getInstance() {
        return instance;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public static IProxy getProxy() {
        return proxy;
    }
}

