/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.creeperhost;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import net.creeperhost.creeperhost.CreeperHost;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;

public final class Util {
    private static List<String> cookies;

    public static String localize(String key, Object ... format) {
        return I18n.func_135052_a((String)(CreeperHost.instance.getImplementation().getLocalizationRoot() + "." + key), (Object[])format);
    }

    public static String getWebResponse(String urlString) {
        try {
            String line;
            URL url = new URL(urlString);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            if (cookies != null) {
                for (String cookie : cookies) {
                    conn.addRequestProperty("Cookie", cookie.split(";", 2)[0]);
                }
            }
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.138 Safari/537.36 Vivaldi/1.8.770.56");
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder respData = new StringBuilder();
            while ((line = rd.readLine()) != null) {
                respData.append(line);
            }
            List<String> setCookies = conn.getHeaderFields().get("Set-Cookie");
            if (setCookies != null) {
                cookies = setCookies;
            }
            rd.close();
            return respData.toString();
        }
        catch (Throwable t) {
            CreeperHost.logger.warn("An error occurred while fetching " + urlString, t);
            return "error";
        }
    }

    public static String postWebResponse(String urlString, Map<String, String> postDataMap) {
        try {
            String line;
            StringBuilder postDataStringBuilder = new StringBuilder();
            for (Map.Entry<String, String> entry : postDataMap.entrySet()) {
                postDataStringBuilder.append(URLEncoder.encode(entry.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(entry.getValue(), "UTF-8")).append("&");
            }
            String postDataString = postDataStringBuilder.toString();
            postDataString.substring(0, postDataString.length() - 1);
            byte[] postData = postDataString.getBytes(StandardCharsets.UTF_8);
            int postDataLength = postData.length;
            URL url = new URL(urlString);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.138 Safari/537.36 Vivaldi/1.8.770.56");
            conn.setRequestMethod("POST");
            if (cookies != null) {
                for (String cookie : cookies) {
                    conn.addRequestProperty("Cookie", cookie.split(";", 2)[0]);
                }
            }
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("charset", "utf-8");
            conn.setRequestProperty("Content-Length", Integer.toString(postDataLength));
            conn.setUseCaches(false);
            conn.setDoOutput(true);
            try {
                DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
                wr.write(postData);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder respData = new StringBuilder();
            while ((line = rd.readLine()) != null) {
                respData.append(line);
            }
            List<String> setCookies = conn.getHeaderFields().get("Set-Cookie");
            if (setCookies != null) {
                cookies = setCookies;
            }
            rd.close();
            return respData.toString();
        }
        catch (Throwable t) {
            CreeperHost.logger.warn("An error occurred while fetching " + urlString, t);
            return "error";
        }
    }

    public static GuiScreen getGuiFromEvent(Object event) {
        GuiScreen gui = null;
        try {
            Field guiField = ReflectionHelper.findField(event.getClass(), (String[])new String[]{"gui"});
            guiField.setAccessible(true);
            gui = (GuiScreen)guiField.get(event);
        }
        catch (Throwable guiField) {
            // empty catch block
        }
        if (gui == null) {
            Class<?> lastClass = event.getClass();
            Class<?> superClass = null;
            while (gui == null && (superClass = lastClass.getSuperclass()) != lastClass) {
                try {
                    Field guiField = ReflectionHelper.findField(superClass, (String[])new String[]{"gui"});
                    guiField.setAccessible(true);
                    gui = (GuiScreen)guiField.get(event);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                lastClass = superClass;
            }
        }
        return gui;
    }

    public static boolean setGuiInEvent(Object event, GuiScreen replacement) {
        try {
            Field guiField = ReflectionHelper.findField(event.getClass(), (String[])new String[]{"gui"});
            guiField.setAccessible(true);
            guiField.set(event, replacement);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
    }

    public static List<GuiButton> getButtonList(Object event) {
        List list = null;
        try {
            Field guiField = ReflectionHelper.findField(event.getClass(), (String[])new String[]{"buttonList"});
            guiField.setAccessible(true);
            list = (List)guiField.get(event);
        }
        catch (Throwable guiField) {
            // empty catch block
        }
        if (list == null) {
            Class<?> lastClass = event.getClass();
            Class<?> superClass = null;
            while (list == null && (superClass = lastClass.getSuperclass()) != lastClass) {
                try {
                    Field guiField = ReflectionHelper.findField(superClass, (String[])new String[]{"buttonList"});
                    guiField.setAccessible(true);
                    list = (List)guiField.get(event);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                lastClass = superClass;
            }
        }
        return list;
    }

    public static GuiButton getButton(Object event) {
        GuiButton button = null;
        try {
            Field guiField = ReflectionHelper.findField(event.getClass(), (String[])new String[]{"buttonList"});
            guiField.setAccessible(true);
            button = (GuiButton)guiField.get(event);
        }
        catch (Throwable guiField) {
            // empty catch block
        }
        if (button == null) {
            Class<?> lastClass = event.getClass();
            Class<?> superClass = null;
            while (button == null && lastClass != null && (superClass = lastClass.getSuperclass()) != lastClass) {
                try {
                    Field guiField = ReflectionHelper.findField(superClass, (String[])new String[]{"button"});
                    guiField.setAccessible(true);
                    button = (GuiButton)guiField.get(event);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                lastClass = superClass;
            }
        }
        return button;
    }
}

