/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import vswe.stevesfactory.blocks.BlockCamouflageBase;
import vswe.stevesfactory.blocks.ModBlocks;
import vswe.stevesfactory.blocks.TileEntityCluster;

public class BlockCableCluster
extends BlockCamouflageBase {
    @SideOnly(value=Side.CLIENT)
    private IIcon sideIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon frontIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon sideIconAdv;
    @SideOnly(value=Side.CLIENT)
    private IIcon frontIconAdv;

    protected BlockCableCluster() {
        super(Material.field_151573_f);
        this.func_149647_a(ModBlocks.creativeTab);
        this.func_149672_a(field_149777_j);
        this.func_149711_c(2.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.sideIcon = register.func_94245_a("stevesfactory:cable_cluster");
        this.frontIcon = register.func_94245_a("stevesfactory:cable_cluster_front");
        this.sideIconAdv = register.func_94245_a("stevesfactory:cable_cluster_adv");
        this.frontIconAdv = register.func_94245_a("stevesfactory:cable_cluster_adv_front");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.getIconFromSideAndMeta(side, this.addAdvancedMeta(3, meta));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getDefaultIcon(int side, int blockMeta, int camoMeta) {
        return this.getIconFromSideAndMeta(side, blockMeta);
    }

    public void func_149749_a(World world, int x, int y, int z, Block oldBlock, int oldMeta) {
        ItemStack itemStack = this.getItemStack(world, x, y, z, oldMeta);
        if (itemStack != null) {
            this.func_149642_a(world, x, y, z, itemStack);
        }
        super.func_149749_a(world, x, y, z, oldBlock, oldMeta);
        if (this.isAdvanced(world.func_72805_g(x, y, z))) {
            ModBlocks.blockCable.updateInventories(world, x, y, z);
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        ItemStack itemStack = this.getItemStack(world, x, y, z, world.func_72805_g(x, y, z));
        if (itemStack != null) {
            return itemStack;
        }
        return super.getPickBlock(target, world, x, y, z);
    }

    private ItemStack getItemStack(World world, int x, int y, int z, int meta) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileEntityCluster) {
            TileEntityCluster cluster = (TileEntityCluster)te;
            ItemStack itemStack = new ItemStack((Block)ModBlocks.blockCableCluster, 1, this.func_149692_a(meta));
            NBTTagCompound compound = new NBTTagCompound();
            itemStack.func_77982_d(compound);
            NBTTagCompound cable = new NBTTagCompound();
            compound.func_74782_a("Cable", (NBTBase)cable);
            cable.func_74773_a("Types", cluster.getTypes());
            return itemStack;
        }
        return null;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList<ItemStack>();
    }

    @SideOnly(value=Side.CLIENT)
    private IIcon getIconFromSideAndMeta(int side, int meta) {
        return side == this.getSideMeta(meta) % ForgeDirection.VALID_DIRECTIONS.length ? (this.isAdvanced(meta) ? this.frontIconAdv : this.frontIcon) : (this.isAdvanced(meta) ? this.sideIconAdv : this.sideIcon);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityCluster();
    }

    private TileEntityCluster getTe(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileEntityCluster) {
            return (TileEntityCluster)te;
        }
        return null;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemStack) {
        int meta = this.addAdvancedMeta(BlockPistonBase.func_150071_a((World)world, (int)x, (int)y, (int)z, (EntityLivingBase)entity), itemStack.func_77960_j());
        world.func_72921_c(x, y, z, meta, 2);
        TileEntityCluster cluster = this.getTe((IBlockAccess)world, x, y, z);
        if (cluster != null) {
            cluster.loadElements(itemStack);
            cluster.onBlockPlacedBy(entity, itemStack);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntityCluster cluster = this.getTe((IBlockAccess)world, x, y, z);
        if (cluster != null) {
            cluster.onNeighborBlockChange(block);
        }
        if (this.isAdvanced(world.func_72805_g(x, y, z))) {
            ModBlocks.blockCable.updateInventories(world, x, y, z);
        }
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        TileEntityCluster cluster = this.getTe(world, x, y, z);
        if (cluster != null) {
            return cluster.canConnectRedstone(side);
        }
        return false;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        TileEntityCluster cluster = this.getTe((IBlockAccess)world, x, y, z);
        if (cluster != null) {
            cluster.onBlockAdded();
        }
        if (this.isAdvanced(world.func_72805_g(x, y, z))) {
            ModBlocks.blockCable.updateInventories(world, x, y, z);
        }
    }

    public boolean shouldCheckWeakPower(IBlockAccess world, int x, int y, int z, int side) {
        TileEntityCluster cluster = this.getTe(world, x, y, z);
        if (cluster != null) {
            return cluster.shouldCheckWeakPower(side);
        }
        return false;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntityCluster cluster = this.getTe(world, x, y, z);
        if (cluster != null) {
            return cluster.isProvidingWeakPower(side);
        }
        return 0;
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        TileEntityCluster cluster = this.getTe(world, x, y, z);
        if (cluster != null) {
            return cluster.isProvidingStrongPower(side);
        }
        return 0;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntityCluster cluster = this.getTe((IBlockAccess)world, x, y, z);
        if (cluster != null) {
            return cluster.onBlockActivated(player, side, hitX, hitY, hitZ);
        }
        return false;
    }

    public void func_149666_a(Item item, CreativeTabs tabs, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 8));
    }

    public boolean isAdvanced(int meta) {
        return (meta & 8) != 0;
    }

    public int getSideMeta(int meta) {
        return meta & 7;
    }

    private int addAdvancedMeta(int meta, int advancedMeta) {
        return meta | advancedMeta & 8;
    }

    private int getAdvancedMeta(int meta) {
        return this.addAdvancedMeta(0, meta);
    }

    public int func_149692_a(int meta) {
        return this.getAdvancedMeta(meta);
    }
}

