/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol;

import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.api.world.logic.ITerrainGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public abstract class TerrainGeneratorBase
implements ITerrainGenerator {
    protected AgeDirector controller;
    protected Random bedrockGen;
    private double[] noise_field;
    protected Block seablock = Blocks.field_150355_j;
    protected byte seameta = 0;
    protected Block fillblock = Blocks.field_150348_b;
    protected byte fillmeta = 0;
    protected boolean genBedrock = true;
    private boolean profiling = false;
    private int fillcounttotal = 0;
    private int seacounttotal = 0;
    private int chunkcount = 0;
    private int fillchunk = 0;
    private int seachunk = 0;

    public TerrainGeneratorBase(AgeDirector controller) {
        this.controller = controller;
        this.bedrockGen = new Random(controller.getSeed());
    }

    public void setProfiling(boolean profiling) {
        this.profiling = profiling;
    }

    public void setTerrainBlock(Block block, byte metadata) {
        this.fillblock = block;
        this.fillmeta = metadata;
    }

    public void setSeaBlock(Block block, byte metadata) {
        this.seablock = block;
        this.seameta = metadata;
    }

    @Override
    public void generateTerrain(int chunkX, int chunkZ, Block[] blocks, byte[] metadata) {
        int fillcount = 0;
        int seacount = 0;
        int xzstep = 4;
        int width = 16 / xzstep;
        int ystep = 8;
        int height = 128 / ystep;
        int sealevel = this.controller.getSeaLevel();
        int width2a = width + 1;
        int height2 = height + 1;
        int width2b = width + 1;
        double noise_ystep_factor = 0.125;
        double noise_xzstep_factor = 0.25;
        this.noise_field = this.initializeNoiseField(this.noise_field, chunkX * width, 0, chunkZ * width, width2a, height2, width2b);
        for (int largeY = 0; largeY < height; ++largeY) {
            for (int largeZ = 0; largeZ < width; ++largeZ) {
                for (int largeX = 0; largeX < width; ++largeX) {
                    double x0z0y0 = this.noise_field[((largeX + 0) * width2b + (largeZ + 0)) * height2 + (largeY + 0)];
                    double x0z1y0 = this.noise_field[((largeX + 0) * width2b + (largeZ + 1)) * height2 + (largeY + 0)];
                    double x1z0y0 = this.noise_field[((largeX + 1) * width2b + (largeZ + 0)) * height2 + (largeY + 0)];
                    double x1z1y0 = this.noise_field[((largeX + 1) * width2b + (largeZ + 1)) * height2 + (largeY + 0)];
                    double x0z0yd = (this.noise_field[((largeX + 0) * width2b + (largeZ + 0)) * height2 + (largeY + 1)] - x0z0y0) * noise_ystep_factor;
                    double x0z1yd = (this.noise_field[((largeX + 0) * width2b + (largeZ + 1)) * height2 + (largeY + 1)] - x0z1y0) * noise_ystep_factor;
                    double x1z0yd = (this.noise_field[((largeX + 1) * width2b + (largeZ + 0)) * height2 + (largeY + 1)] - x1z0y0) * noise_ystep_factor;
                    double x1z1yd = (this.noise_field[((largeX + 1) * width2b + (largeZ + 1)) * height2 + (largeY + 1)] - x1z1y0) * noise_ystep_factor;
                    double x0z0yc = x0z0y0;
                    double x0z1yc = x0z1y0;
                    double x1z0yc = x1z0y0;
                    double x1z1yc = x1z1y0;
                    int y = largeY * ystep;
                    for (int subY = 0; subY < ystep; ++subY) {
                        double x0zcyc = x0z0yc;
                        double x1zcyc = x1z0yc;
                        double x0zdyc = (x0z1yc - x0z0yc) * 0.25;
                        double x1zdyc = (x1z1yc - x1z0yc) * 0.25;
                        int z = largeZ * xzstep;
                        for (int subZ = 0; subZ < xzstep; ++subZ) {
                            double xczcyc = x0zcyc;
                            double xdzcyc = (x1zcyc - x0zcyc) * 0.25;
                            int coords = y << 8 | z << 4 | largeX * xzstep;
                            for (int subX = 0; subX < xzstep; ++subX) {
                                Block block = Blocks.field_150350_a;
                                byte meta = 0;
                                if (this.genBedrock && y <= 0 + this.bedrockGen.nextInt(5)) {
                                    block = Blocks.field_150357_h;
                                } else if (xczcyc > 0.0) {
                                    block = this.fillblock;
                                    meta = this.fillmeta;
                                    ++fillcount;
                                } else if (y < sealevel) {
                                    block = this.seablock;
                                    meta = this.seameta;
                                    ++seacount;
                                }
                                blocks[coords] = block;
                                metadata[coords] = meta;
                                xczcyc += xdzcyc;
                                ++coords;
                            }
                            x0zcyc += x0zdyc;
                            x1zcyc += x1zdyc;
                            ++z;
                        }
                        x0z0yc += x0z0yd;
                        x0z1yc += x0z1yd;
                        x1z0yc += x1z0yd;
                        x1z1yc += x1z1yd;
                        ++y;
                    }
                }
            }
        }
        if (this.profiling) {
            ++this.chunkcount;
            this.fillcounttotal += fillcount;
            this.seacounttotal += seacount;
            if (fillcount > 0) {
                ++this.fillchunk;
            }
            if (seacount > 0) {
                ++this.seachunk;
            }
            System.out.println(String.format("Using %s. AVG: [%f] [%f] / %d TOT: [%d] [%d] CNKFRQ: [%f:%f] [%f:%f]", this.toString(), Float.valueOf((float)this.fillcounttotal / (float)this.chunkcount), Float.valueOf((float)this.seacounttotal / (float)this.chunkcount), this.chunkcount, this.fillcounttotal, this.seacounttotal, Float.valueOf((float)this.fillchunk / (float)this.chunkcount), Float.valueOf((float)this.fillcounttotal / (float)this.fillchunk), Float.valueOf((float)this.seachunk / (float)this.chunkcount), Float.valueOf((float)this.seacounttotal / (float)this.seachunk)));
        }
    }

    protected abstract double[] initializeNoiseField(double[] var1, int var2, int var3, int var4, int var5, int var6, int var7);
}

