/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.error;

import com.xcompwiz.mystcraft.MystcraftFirstRun;
import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.api.world.logic.IBiomeController;
import com.xcompwiz.mystcraft.api.world.logic.ILightingController;
import com.xcompwiz.mystcraft.api.world.logic.ITerrainGenerator;
import com.xcompwiz.mystcraft.api.world.logic.IWeatherController;
import com.xcompwiz.mystcraft.client.gui.error.GuiNonCriticalError;
import com.xcompwiz.mystcraft.client.gui.overlay.GuiNotification;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import com.xcompwiz.mystcraft.world.profiling.GuiMystcraftProfiling;
import com.xcompwiz.mystcraft.world.profiling.InstabilityDataCalculator;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiDownloadTerrain;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSelectWorld;
import net.minecraft.client.multiplayer.GuiConnecting;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.world.WorldEvent;

public class MystcraftStartupChecker {
    private HashSet<ErrorChecker> checks = new HashSet();
    HashSet<ErrorChecker> completed = new HashSet();
    private GuiNotification updateNotification;

    public MystcraftStartupChecker() {
        this.checks.add(new CheckSymbolLoadError());
        this.checks.add(new CheckSymbolLogicError(IBiomeController.class, "Biome Distribution"));
        this.checks.add(new CheckSymbolLogicError(ITerrainGenerator.class, "World Terrain Type"));
        this.checks.add(new CheckSymbolLogicError(ILightingController.class, "Lighting"));
        this.checks.add(new CheckSymbolLogicError(IWeatherController.class, "Weather"));
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        if (MystcraftFirstRun.isReady()) {
            return;
        }
        MystcraftFirstRun.onSaveEvent(event);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (MystcraftFirstRun.isStopped() && Minecraft.func_71410_x().func_147104_D() == null) {
            MystcraftFirstRun.start();
        }
    }

    @SubscribeEvent
    public void onClientInitGUI(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.gui instanceof GuiMainMenu && this.checkForErrors() && !InstabilityDataCalculator.isPerSave() && !InstabilityDataCalculator.isDisabled()) {
            MystcraftFirstRun.enable();
        }
    }

    @SubscribeEvent
    public void onClientOpenGUI(GuiOpenEvent event) {
        if (InstabilityDataCalculator.isPerSave()) {
            return;
        }
        if (InstabilityDataCalculator.isDisabled()) {
            return;
        }
        if (MystcraftFirstRun.isReady()) {
            return;
        }
        if (!MystcraftFirstRun.isEnabled()) {
            return;
        }
        if (event.gui instanceof GuiMystcraftProfiling) {
            return;
        }
        if (MystcraftFirstRun.isStopped() && Minecraft.func_71410_x().func_147104_D() == null) {
            MystcraftFirstRun.start();
        }
        if (event.gui instanceof GuiSelectWorld) {
            if (MystcraftFirstRun.isStopped()) {
                ArrayList<String> messages = new ArrayList<String>();
                messages.add("Mystcraft hasn't finished it's profiling yet.");
                messages.add("Unfortunately, this does not seem to be running. Try restarting your client.");
                messages.add("");
                messages.add("Mystcraft requires some information about the generation provided by the mods in your game.");
                messages.add("In order to do this, it does a first-time profiling. This must finish before you start a Single Player game.");
                event.gui = new GuiNonCriticalError(messages);
            } else {
                MystcraftFirstRun.showProfilingGui();
                event.setCanceled(true);
            }
        }
        if (MystcraftFirstRun.isStopped()) {
            return;
        }
        if (event.gui == null) {
            MystcraftFirstRun.showProfilingGui();
            event.setCanceled(true);
        }
        if (event.gui instanceof GuiDownloadTerrain) {
            MystcraftFirstRun.showProfilingGui();
            event.setCanceled(true);
        }
        if (event.gui instanceof GuiIngameMenu) {
            MystcraftFirstRun.showProfilingGui();
            event.setCanceled(true);
        }
        if (event.gui instanceof GuiConnecting) {
            MystcraftFirstRun.stop();
        }
    }

    @SubscribeEvent
    public void onClientRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.updateNotification != null) {
            this.updateNotification.render();
        }
    }

    private synchronized boolean checkForErrors() {
        for (ErrorChecker check : this.checks) {
            this.completed.add(check);
            if (check.hasRun() || !check.run()) continue;
            LoggerUtils.info("Mystcraft Start-Up Error Checking Reported an Error to the user.", new Object[0]);
            break;
        }
        for (ErrorChecker check : this.completed) {
            this.checks.remove(check);
        }
        boolean ret = false;
        if (this.checks.size() == 0 && this.completed.size() > 0) {
            LoggerUtils.info("Mystcraft Start-Up Error Checking Completed", new Object[0]);
            ret = true;
        }
        this.completed.clear();
        return ret;
    }

    public GuiNotification getNotificationGui() {
        if (this.updateNotification == null) {
            this.updateNotification = new GuiNotification(Minecraft.func_71410_x());
        }
        return this.updateNotification;
    }

    public static class CheckSymbolLogicError
    extends ErrorChecker {
        private Class clazz;
        private String type;

        public CheckSymbolLogicError(Class clazz, String type) {
            this.clazz = clazz;
            this.type = type;
        }

        @Override
        protected GuiScreen getErrorGui() {
            IAgeSymbol symbol2 = SymbolManager.findAgeSymbolImplementing(new Random(0L), this.clazz);
            if (symbol2 == null) {
                ArrayList<String> messages = new ArrayList<String>();
                messages.add("ERROR: Mystcraft detected errors on loadup.");
                messages.add("There are no symbols which provide logic for " + this.type + ".");
                messages.add("Mystcraft requires at least one symbol providing logic of this type.");
                messages.add("Be aware the Mystcraft WILL crash should you try to enter an age.");
                return new GuiNonCriticalError(messages);
            }
            return null;
        }
    }

    public static class CheckSymbolLoadError
    extends ErrorChecker {
        @Override
        protected GuiScreen getErrorGui() {
            HashSet<String> errored = SymbolManager.getErroredSymbols();
            if (!errored.isEmpty()) {
                ArrayList<String> messages = new ArrayList<String>();
                messages.add("WARNING: Mystcraft detected errors in the following symbols on loadup.");
                messages.add("These symbols are not loaded and will not occur in the game.");
                messages.add("Please check your setup and attempt to get a log of this session to the symbol developer.");
                messages.add("To prevent this message from coming up in the future, disable or remove these symbols.");
                messages.add("");
                messages.addAll(errored);
                return new GuiNonCriticalError(messages);
            }
            return null;
        }
    }

    public static abstract class ErrorChecker {
        private boolean hasRun = false;

        public final boolean hasRun() {
            return this.hasRun;
        }

        public final boolean run() {
            this.hasRun = true;
            GuiScreen gui = this.getErrorGui();
            if (gui != null) {
                Minecraft.func_71410_x().func_147108_a(gui);
                return true;
            }
            return false;
        }

        protected abstract GuiScreen getErrorGui();
    }
}

