/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.tileentity;

import cpw.mods.fml.common.FMLCommonHandler;
import hardcorequesting.QuestingData;
import hardcorequesting.Team;
import hardcorequesting.Translator;
import hardcorequesting.quests.Quest;
import hardcorequesting.tileentity.TileEntityTracker;
import net.minecraft.entity.player.EntityPlayer;

public enum TrackerType {
    TEAM("team"){

        @Override
        public int getMeta(TileEntityTracker tracker, Quest quest, int radius) {
            int meta = 0;
            for (Team team : QuestingData.getAllTeams()) {
                boolean valid;
                if (!team.getQuestData((int)quest.getId()).completed) continue;
                boolean bl = valid = radius == 0;
                if (!(valid = TrackerType.isValid(valid, team, tracker, radius)) || ++meta != 15) continue;
                break;
            }
            return meta;
        }
    }
    ,
    PLAYER("player"){

        @Override
        public int getMeta(TileEntityTracker tracker, Quest quest, int radius) {
            int meta = 0;
            block0: for (Team team : QuestingData.getAllTeams()) {
                if (!team.getQuestData((int)quest.getId()).completed) continue;
                for (Team.PlayerEntry entry : team.getPlayers()) {
                    EntityPlayer player;
                    boolean valid;
                    if (!entry.isInTeam()) continue;
                    boolean bl = valid = radius == 0;
                    if (!valid && (player = QuestingData.getPlayer(entry.getName())) != null && TrackerType.isPlayerWithinRadius(tracker, player, radius)) {
                        valid = true;
                    }
                    if (!valid || ++meta != 15) continue;
                    continue block0;
                }
            }
            return meta;
        }
    }
    ,
    PROGRESS_MAX("progressMax"){

        @Override
        public int getMeta(TileEntityTracker tracker, Quest quest, int radius) {
            int meta = 0;
            for (Team team : QuestingData.getAllTeams()) {
                boolean valid;
                int newMeta = (int)(quest.getProgress(team) * 15.0f);
                if (newMeta <= meta) continue;
                boolean bl = valid = radius == 0;
                if (!(valid = TrackerType.isValid(valid, team, tracker, radius))) continue;
                meta = newMeta;
            }
            return meta;
        }
    }
    ,
    PROGRESS_CLOSE("progressClose"){

        @Override
        public int getMeta(TileEntityTracker tracker, Quest quest, int radius) {
            double closest = 0.0;
            EntityPlayer closestPlayer = null;
            for (String name : FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_72369_d()) {
                EntityPlayer player = QuestingData.getPlayer(name);
                if (player == null) continue;
                double distance = player.func_70092_e((double)tracker.field_145851_c + 0.5, (double)tracker.field_145848_d + 0.5, (double)tracker.field_145849_e + 0.5);
                if (closestPlayer != null && !(distance < closest)) continue;
                closest = distance;
                closestPlayer = player;
            }
            if (closestPlayer != null) {
                return (int)(quest.getProgress(QuestingData.getQuestingData(closestPlayer).getTeam()) * 15.0f);
            }
            return 0;
        }
    };

    private String id;

    private static boolean isPlayerWithinRadius(TileEntityTracker tracker, EntityPlayer player, int radius) {
        return player.func_70092_e((double)tracker.field_145851_c + 0.5, (double)tracker.field_145848_d + 0.5, (double)tracker.field_145849_e + 0.5) < (double)(radius * radius);
    }

    private static boolean isValid(boolean valid, Team team, TileEntityTracker tracker, int radius) {
        if (!valid) {
            for (Team.PlayerEntry entry : team.getPlayers()) {
                EntityPlayer player;
                if (!entry.isInTeam() || (player = QuestingData.getPlayer(entry.getName())) == null || !TrackerType.isPlayerWithinRadius(tracker, player, radius)) continue;
                return true;
            }
        }
        return valid;
    }

    private TrackerType(String name) {
        this.id = name;
    }

    public String getName() {
        return Translator.translate("hqm.tracker." + this.id + ".title");
    }

    public String getDescription() {
        return Translator.translate("hqm.tracker." + this.id + ".desc");
    }

    public abstract int getMeta(TileEntityTracker var1, Quest var2, int var3);
}

