/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modules;

import io.netty.buffer.ByteBuf;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.screens.modules.ComputerScreenModule;
import net.minecraft.item.ItemStack;

public enum ScreenDataType {
    TYPE_NULL,
    TYPE_BYTE,
    TYPE_INT,
    TYPE_LONG,
    TYPE_DOUBLE,
    TYPE_FLOAT,
    TYPE_STRING,
    TYPE_BOOLEAN,
    TYPE_ITEMSTACK,
    TYPE_COLOREDTEXT;


    public Object readObject(ByteBuf buf) {
        switch (this) {
            case TYPE_NULL: {
                return null;
            }
            case TYPE_BYTE: {
                return buf.readByte();
            }
            case TYPE_INT: {
                return buf.readInt();
            }
            case TYPE_LONG: {
                return buf.readLong();
            }
            case TYPE_DOUBLE: {
                return buf.readDouble();
            }
            case TYPE_FLOAT: {
                return Float.valueOf(buf.readFloat());
            }
            case TYPE_BOOLEAN: {
                return buf.readBoolean();
            }
            case TYPE_STRING: {
                return NetworkTools.readString((ByteBuf)buf);
            }
            case TYPE_ITEMSTACK: {
                return NetworkTools.readItemStack((ByteBuf)buf);
            }
            case TYPE_COLOREDTEXT: {
                byte[] dst2 = new byte[buf.readInt()];
                buf.readBytes(dst2);
                int color = buf.readInt();
                return new ComputerScreenModule.ColoredText(new String(dst2), color);
            }
        }
        return null;
    }

    public static void writeObject(ByteBuf buf, Object obj) {
        if (obj == null) {
            buf.writeByte(TYPE_NULL.ordinal());
        } else if (obj instanceof Long) {
            buf.writeByte(TYPE_LONG.ordinal());
            buf.writeLong(((Long)obj).longValue());
        } else if (obj instanceof Integer) {
            buf.writeByte(TYPE_INT.ordinal());
            buf.writeInt(((Integer)obj).intValue());
        } else if (obj instanceof Byte) {
            buf.writeByte(TYPE_BYTE.ordinal());
            buf.writeByte((int)((Byte)obj).byteValue());
        } else if (obj instanceof Float) {
            buf.writeByte(TYPE_FLOAT.ordinal());
            buf.writeFloat(((Float)obj).floatValue());
        } else if (obj instanceof Double) {
            buf.writeByte(TYPE_FLOAT.ordinal());
            buf.writeDouble(((Double)obj).doubleValue());
        } else if (obj instanceof Boolean) {
            buf.writeByte(TYPE_BOOLEAN.ordinal());
            buf.writeBoolean(((Boolean)obj).booleanValue());
        } else if (obj instanceof String) {
            buf.writeByte(TYPE_STRING.ordinal());
            String s = (String)obj;
            buf.writeInt(s.length());
            buf.writeBytes(s.getBytes());
        } else if (obj instanceof ItemStack) {
            buf.writeByte(TYPE_ITEMSTACK.ordinal());
            NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)((ItemStack)obj));
        } else if (obj instanceof ComputerScreenModule.ColoredText) {
            buf.writeByte(TYPE_COLOREDTEXT.ordinal());
            ComputerScreenModule.ColoredText ct = (ComputerScreenModule.ColoredText)obj;
            NetworkTools.writeString((ByteBuf)buf, (String)ct.getText());
            buf.writeInt(ct.getColor());
        } else {
            Logging.log((String)"Weird ScreenDataType!");
        }
    }
}

