/*
 * Decompiled with CFR 0.152.
 */
package tonius.neiintegration.mods.minefactoryreloaded;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import cofh.lib.util.WeightedRandomItemStack;
import cpw.mods.fml.common.registry.GameRegistry;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityLaserDrill;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityLaserDrillPrecharger;
import tonius.neiintegration.RecipeHandlerBase;
import tonius.neiintegration.Utils;

public class RecipeHandlerLaserDrill
extends RecipeHandlerBase {
    private static List<WeightedRandom.Item> laserOres;
    private static int totalWeight;
    private static Map<Integer, List<ItemStack>> laserPreferredOres;
    private static int energyPerOperation;
    private static Item laserFocus;

    @Override
    public void prepare() {
        laserOres = MFRRegistry.getLaserOres();
        for (WeightedRandom.Item ore : laserOres) {
            totalWeight += ore.field_76292_a;
        }
        laserPreferredOres = new HashMap<Integer, List<ItemStack>>();
        for (int i = 0; i <= 15; ++i) {
            List preferredOres = MFRRegistry.getLaserPreferredOres((int)i);
            laserPreferredOres.put(i, preferredOres);
        }
        TileEntityLaserDrillPrecharger dummyPrecharger = new TileEntityLaserDrillPrecharger();
        TileEntityLaserDrill dummyDrill = new TileEntityLaserDrill();
        energyPerOperation = dummyPrecharger.getActivationEnergy() * dummyDrill.getWorkMax();
        dummyPrecharger = null;
        dummyDrill = null;
        laserFocus = GameRegistry.findItem((String)"MineFactoryReloaded", (String)"laserfocus");
        if (laserFocus == null) {
            laserFocus = GameRegistry.findItem((String)"MineFactoryReloaded", (String)"item.mfr.laserfocus");
        }
    }

    public String getRecipeName() {
        return Utils.translate("tile.mfr.machine.laserdrill.name", false);
    }

    @Override
    public String getRecipeID() {
        return "minefactoryreloaded.laserdrill";
    }

    public String getGuiTexture() {
        return "minefactoryreloaded:textures/gui/laserdrill.png";
    }

    public void loadTransferRects() {
        this.addTransferRect(104, 25, 22, 15);
    }

    public void drawBackground(int recipe) {
        this.changeToGuiTexture();
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)11, (int)13, (int)160, (int)65);
        this.changeToOverlayTexture();
        GuiDraw.drawTexturedModalRect((int)19, (int)23, (int)0, (int)30, (int)18, (int)18);
        GuiDraw.drawTexturedModalRect((int)104, (int)25, (int)0, (int)15, (int)22, (int)15);
    }

    public void drawExtras(int recipe) {
        GuiDraw.drawTexturedModalRect((int)111, (int)2, (int)176, (int)0, (int)16, (int)60);
        this.drawProgressBar(139, 0, 176, 58, 8, 62, 1.0f, 3);
        this.drawProgressBar(149, 0, 185, 58, 8, 62, 60, 3);
        CachedLaserDrillRecipe crecipe = (CachedLaserDrillRecipe)((Object)this.arecipes.get(recipe));
        NumberFormat percentFormat = NumberFormat.getPercentInstance();
        percentFormat.setMaximumFractionDigits(2);
        GuiDraw.drawStringC((String)percentFormat.format(crecipe.chance), (int)83, (int)44, (int)0x808080, (boolean)false);
        GuiDraw.drawStringC((String)Utils.translate("handler.laserdrill.focus"), (int)29, (int)44, (int)0x808080, (boolean)false);
    }

    @Override
    public List<String> provideTooltip(GuiRecipe guiRecipe, List<String> currenttip, RecipeHandlerBase.CachedBaseRecipe crecipe, Point relMouse) {
        super.provideTooltip(guiRecipe, currenttip, crecipe, relMouse);
        if (new Rectangle(139, 2, 8, 60).contains(relMouse)) {
            currenttip.add(energyPerOperation + " RF");
        }
        return currenttip;
    }

    @Override
    public void loadAllRecipes() {
        for (WeightedRandom.Item drop : laserOres) {
            if (!(drop instanceof WeightedRandomItemStack)) continue;
            ItemStack dropStack = ((WeightedRandomItemStack)drop).getStack();
            for (int i : laserPreferredOres.keySet()) {
                List<ItemStack> preferredStacks = laserPreferredOres.get(i);
                if (preferredStacks == null) continue;
                for (ItemStack preferredStack : preferredStacks) {
                    if (!Utils.areStacksSameTypeCraftingSafe(preferredStack, dropStack)) continue;
                    this.arecipes.add(new CachedLaserDrillRecipe(dropStack, drop.field_76292_a, i));
                }
            }
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (WeightedRandom.Item drop : laserOres) {
            if (!(drop instanceof WeightedRandomItemStack) || !Utils.areStacksSameTypeCraftingSafe(((WeightedRandomItemStack)drop).getStack(), result)) continue;
            ItemStack dropStack = ((WeightedRandomItemStack)drop).getStack();
            for (int i : laserPreferredOres.keySet()) {
                List<ItemStack> preferredStacks = laserPreferredOres.get(i);
                if (preferredStacks == null) continue;
                for (ItemStack preferredStack : preferredStacks) {
                    if (!Utils.areStacksSameTypeCraftingSafe(preferredStack, dropStack)) continue;
                    this.arecipes.add(new CachedLaserDrillRecipe(dropStack, drop.field_76292_a, i));
                }
            }
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingred) {
        int dmg = ingred.func_77960_j();
        if (ingred.func_77973_b() == laserFocus && dmg <= 15) {
            for (WeightedRandom.Item drop : laserOres) {
                if (!(drop instanceof WeightedRandomItemStack)) continue;
                ItemStack dropStack = ((WeightedRandomItemStack)drop).getStack();
                List<ItemStack> preferredStacks = laserPreferredOres.get(dmg);
                if (preferredStacks == null) continue;
                for (ItemStack preferredStack : preferredStacks) {
                    if (!Utils.areStacksSameTypeCraftingSafe(preferredStack, dropStack)) continue;
                    this.arecipes.add(new CachedLaserDrillRecipe(dropStack, drop.field_76292_a, dmg));
                }
            }
        }
    }

    public class CachedLaserDrillRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public PositionedStack output;
        public float chance;
        public PositionedStack focus = null;

        public CachedLaserDrillRecipe(ItemStack output, int weight, Integer focus) {
            this.output = new PositionedStack((Object)output, 74, 24);
            this.chance = (float)weight / (float)totalWeight;
            if (focus != null) {
                this.focus = new PositionedStack((Object)new ItemStack(laserFocus, 1, focus.intValue()), 20, 24);
            }
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public PositionedStack getOtherStack() {
            if (this.focus != null) {
                return this.focus;
            }
            return super.getOtherStack();
        }
    }
}

