/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.network;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.common.utills.ItemNBTHelper;
import com.brandon3055.brandonscore.common.utills.Teleporter;
import com.brandon3055.draconicevolution.common.ModItems;
import com.brandon3055.draconicevolution.common.handler.ConfigHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TeleporterPacket
implements IMessage {
    public static final int ADDDESTINATION = 0;
    public static final int REMOVEDESTINATION = 1;
    public static final int UPDATENAME = 2;
    public static final int UPDATELOCK = 3;
    public static final int CHANGESELECTION = 4;
    public static final int UPDATEOFFSET = 5;
    public static final int ADDFUEL = 6;
    public static final int UPDATEDESTINATION = 7;
    public static final int TELEPORT = 8;
    public static final int SCROLL = 9;
    public static final int MOVELOCATION = 10;
    private int data = 0;
    private boolean dataB;
    private byte function = (byte)-1;
    private Teleporter.TeleportLocation location;

    public TeleporterPacket() {
    }

    public TeleporterPacket(int function, int data, boolean b) {
        this.data = data;
        this.function = (byte)function;
        this.dataB = b;
    }

    public TeleporterPacket(Teleporter.TeleportLocation location, int function) {
        this.location = location;
        this.function = (byte)function;
    }

    public TeleporterPacket(Teleporter.TeleportLocation location, int function, int data) {
        this.data = data;
        this.location = location;
        this.function = (byte)function;
    }

    public void toBytes(ByteBuf bytes) {
        bytes.writeByte((int)this.function);
        if (this.function == 0 || this.function == 7) {
            bytes.writeDouble(this.location.getXCoord());
            bytes.writeDouble(this.location.getYCoord());
            bytes.writeDouble(this.location.getZCoord());
            bytes.writeInt(this.location.getDimension());
            bytes.writeFloat(this.location.getPitch());
            bytes.writeFloat(this.location.getYaw());
            ByteBufUtils.writeUTF8String((ByteBuf)bytes, (String)this.location.getName());
            if (this.function == 7) {
                bytes.writeInt(this.data);
            }
        }
        if (this.function == 3 || this.function == 10) {
            bytes.writeInt(this.data);
            bytes.writeBoolean(this.dataB);
        }
        if (this.function == 5 || this.function == 4 || this.function == 1 || this.function == 6 || this.function == 9) {
            bytes.writeInt(this.data);
        }
        if (this.function == 2) {
            ByteBufUtils.writeUTF8String((ByteBuf)bytes, (String)this.location.getName());
            bytes.writeInt(this.data);
        }
        if (this.function == 8) {
            bytes.writeInt(this.data);
        }
    }

    public void fromBytes(ByteBuf bytes) {
        this.function = bytes.readByte();
        if (this.function == 0 || this.function == 7) {
            this.location = new Teleporter.TeleportLocation();
            this.location.setXCoord(bytes.readDouble());
            this.location.setYCoord(bytes.readDouble());
            this.location.setZCoord(bytes.readDouble());
            this.location.setDimension(bytes.readInt());
            this.location.setPitch(bytes.readFloat());
            this.location.setYaw(bytes.readFloat());
            this.location.setName(ByteBufUtils.readUTF8String((ByteBuf)bytes));
            if (this.function == 7) {
                this.data = bytes.readInt();
            }
        }
        if (this.function == 3 || this.function == 10) {
            this.data = bytes.readInt();
            this.dataB = bytes.readBoolean();
        }
        if (this.function == 5 || this.function == 4 || this.function == 1 || this.function == 6 || this.function == 9) {
            this.data = bytes.readInt();
        }
        if (this.function == 2) {
            this.location = new Teleporter.TeleportLocation();
            this.location.setName(ByteBufUtils.readUTF8String((ByteBuf)bytes));
            this.data = bytes.readInt();
        }
        if (this.function == 8) {
            this.data = bytes.readInt();
        }
    }

    public static class Handler
    implements IMessageHandler<TeleporterPacket, IMessage> {
        public IMessage onMessage(TeleporterPacket message, MessageContext ctx) {
            int maxOffset;
            int maxSelect;
            int selectionOffset;
            NBTTagCompound tag;
            NBTTagList list;
            ItemStack teleporter = ctx.getServerHandler().field_147369_b.func_70694_bm();
            if (teleporter == null || teleporter.func_77973_b() != ModItems.teleporterMKII) {
                return null;
            }
            NBTTagCompound compound = teleporter.func_77978_p();
            if (compound == null) {
                compound = new NBTTagCompound();
            }
            if ((list = (NBTTagList)compound.func_74781_a("Locations")) == null) {
                list = new NBTTagList();
            }
            if (message.function == 0) {
                tag = new NBTTagCompound();
                message.location.setDimentionName(BrandonsCore.proxy.getMCServer().func_71218_a((int)((TeleporterPacket)message).location.getDimension()).field_73011_w.func_80007_l());
                message.location.writeToNBT(tag);
                list.func_74742_a((NBTBase)tag);
                compound.func_74782_a("Locations", (NBTBase)list);
                teleporter.func_77982_d(compound);
            }
            if (message.function == 9) {
                short selected = ItemNBTHelper.getShort((ItemStack)teleporter, (String)"Selection", (short)0);
                selectionOffset = ItemNBTHelper.getInteger((ItemStack)teleporter, (String)"SelectionOffset", (int)0);
                maxSelect = Math.min(list.func_74745_c() - 1, 11);
                maxOffset = Math.max(list.func_74745_c() - 12, 0);
                if (message.data > 0 && selected < maxSelect) {
                    ItemNBTHelper.setShort((ItemStack)teleporter, (String)"Selection", (short)((short)(selected + 1)));
                    return null;
                }
                if (message.data > 0 && selectionOffset < maxOffset) {
                    ItemNBTHelper.setInteger((ItemStack)teleporter, (String)"SelectionOffset", (int)(selectionOffset + 1));
                    return null;
                }
                if (message.data < 0 && selected > 0) {
                    ItemNBTHelper.setShort((ItemStack)teleporter, (String)"Selection", (short)((short)(selected - 1)));
                    return null;
                }
                if (message.data < 0 && selectionOffset > 0) {
                    ItemNBTHelper.setInteger((ItemStack)teleporter, (String)"SelectionOffset", (int)(selectionOffset - 1));
                    return null;
                }
            }
            if (message.function == 7) {
                tag = list.func_150305_b(message.data);
                message.location.setDimentionName(BrandonsCore.proxy.getMCServer().func_71218_a((int)((TeleporterPacket)message).location.getDimension()).field_73011_w.func_80007_l());
                message.location.writeToNBT(tag);
                list.func_150304_a(message.data, (NBTBase)tag);
                compound.func_74782_a("Locations", (NBTBase)list);
                teleporter.func_77982_d(compound);
            }
            if (message.function == 3) {
                list.func_150305_b(message.data).func_74757_a("WP", message.dataB);
                compound.func_74782_a("Locations", (NBTBase)list);
                teleporter.func_77982_d(compound);
            }
            if (message.function == 1) {
                list.func_74744_a(message.data);
                compound.func_74782_a("Locations", (NBTBase)list);
                teleporter.func_77982_d(compound);
            }
            if (message.function == 2) {
                list.func_150305_b(message.data).func_74778_a("Name", message.location.getName());
                compound.func_74782_a("Locations", (NBTBase)list);
                teleporter.func_77982_d(compound);
            }
            if (message.function == 8) {
                int fuel = ItemNBTHelper.getInteger((ItemStack)teleporter, (String)"Fuel", (int)0);
                if (!ctx.getServerHandler().field_147369_b.field_71075_bZ.field_75098_d) {
                    ItemNBTHelper.setInteger((ItemStack)teleporter, (String)"Fuel", (int)(fuel - 1));
                }
                Teleporter.TeleportLocation destination = new Teleporter.TeleportLocation();
                destination.readFromNBT(list.func_150305_b(message.data));
                destination.sendEntityToCoords((Entity)ctx.getServerHandler().field_147369_b);
            }
            if (message.function == 10) {
                NBTTagCompound temp;
                short selected = ItemNBTHelper.getShort((ItemStack)teleporter, (String)"Selection", (short)0);
                selectionOffset = ItemNBTHelper.getInteger((ItemStack)teleporter, (String)"SelectionOffset", (int)0);
                maxSelect = Math.min(list.func_74745_c() - 1, 11);
                maxOffset = Math.max(list.func_74745_c() - 12, 0);
                if (message.dataB) {
                    if (selected > 0) {
                        temp = list.func_150305_b(selected + selectionOffset);
                        list.func_150304_a(selected + selectionOffset, (NBTBase)list.func_150305_b(selected + selectionOffset - 1));
                        list.func_150304_a(selected + selectionOffset - 1, (NBTBase)temp);
                        compound.func_74782_a("Locations", (NBTBase)list);
                        teleporter.func_77982_d(compound);
                        ItemNBTHelper.setShort((ItemStack)teleporter, (String)"Selection", (short)((short)(ItemNBTHelper.getShort((ItemStack)teleporter, (String)"Selection", (short)0) - 1)));
                    }
                } else if (selected < maxSelect) {
                    temp = list.func_150305_b(selected + selectionOffset);
                    list.func_150304_a(selected + selectionOffset, (NBTBase)list.func_150305_b(selected + selectionOffset + 1));
                    list.func_150304_a(selected + selectionOffset + 1, (NBTBase)temp);
                    compound.func_74782_a("Locations", (NBTBase)list);
                    teleporter.func_77982_d(compound);
                    ItemNBTHelper.setShort((ItemStack)teleporter, (String)"Selection", (short)((short)(ItemNBTHelper.getShort((ItemStack)teleporter, (String)"Selection", (short)0) + 1)));
                }
            }
            if (message.function == 6) {
                int fuel = ItemNBTHelper.getInteger((ItemStack)teleporter, (String)"Fuel", (int)0);
                int count = 0;
                for (int i = 0; i < message.data && ctx.getServerHandler().field_147369_b.field_71071_by.func_146028_b(Items.field_151079_bi); ++i) {
                    ctx.getServerHandler().field_147369_b.field_71071_by.func_146026_a(Items.field_151079_bi);
                    ++count;
                }
                ItemNBTHelper.setInteger((ItemStack)teleporter, (String)"Fuel", (int)(fuel + ConfigHandler.teleporterUsesPerPearl * count));
            }
            if (message.function == 4) {
                ItemNBTHelper.setShort((ItemStack)teleporter, (String)"Selection", (short)((short)message.data));
            }
            if (message.function == 5) {
                ItemNBTHelper.setInteger((ItemStack)teleporter, (String)"SelectionOffset", (int)message.data);
            }
            return null;
        }
    }
}

