/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.converter.outbound;

import com.google.common.collect.Maps;
import java.lang.reflect.Array;
import java.util.HashMap;
import openperipheral.api.converter.IConverter;
import openperipheral.api.converter.IOutboundTypeConverter;

public class ConverterArrayOutbound
implements IOutboundTypeConverter {
    private final int offset;

    public ConverterArrayOutbound(int offset) {
        this.offset = offset;
    }

    @Override
    public Object fromJava(IConverter registry, Object o) {
        if (o.getClass().isArray()) {
            HashMap ret = Maps.newHashMap();
            int length = Array.getLength(o);
            for (int i = 0; i < length; ++i) {
                Object value = Array.get(o, i);
                Object converted = registry.fromJava(value);
                ret.put(i + this.offset, converted);
            }
            return ret;
        }
        return null;
    }
}

