/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import openperipheral.adapter.types.BoundedType;
import openperipheral.adapter.types.IRange;
import openperipheral.adapter.types.SingleArgType;
import openperipheral.adapter.types.SingleReturnType;
import openperipheral.adapter.types.SingleType;
import openperipheral.adapter.types.TupleType;
import openperipheral.adapter.types.classifier.TypeClassifier;
import openperipheral.api.adapter.IScriptType;
import openperipheral.api.adapter.method.ArgType;
import openperipheral.api.adapter.method.ReturnType;

public class TypeHelper {
    public static IScriptType single(ArgType type) {
        return SingleArgType.valueOf(type);
    }

    public static IScriptType single(ReturnType type) {
        return SingleReturnType.valueOf(type);
    }

    public static IScriptType create(ReturnType ... types) {
        return TypeHelper.createFromReturn(Arrays.asList(types));
    }

    public static IScriptType create(ArgType ... types) {
        return TypeHelper.createFromArg(Arrays.asList(types));
    }

    public static IScriptType single(ReturnType type, IRange range) {
        Preconditions.checkNotNull((Object)((Object)type));
        Preconditions.checkNotNull((Object)range);
        return new BoundedType(SingleReturnType.valueOf(type), range);
    }

    public static IScriptType single(ArgType type, IRange range) {
        Preconditions.checkNotNull((Object)((Object)type));
        Preconditions.checkNotNull((Object)range);
        return new BoundedType(SingleArgType.valueOf(type), range);
    }

    public static IScriptType bounded(IScriptType type, IRange range) {
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull((Object)range);
        return new BoundedType(type, range);
    }

    public static IScriptType createFromReturn(List<ReturnType> types) {
        if (types.size() == 0) {
            return SingleType.VOID;
        }
        if (types.size() == 1) {
            return SingleReturnType.valueOf(types.get(0));
        }
        return TypeHelper.wrapSingleReturnTypes(types);
    }

    public static IScriptType createFromArg(List<ArgType> types) {
        if (types.size() == 0) {
            return SingleType.VOID;
        }
        if (types.size() == 1) {
            return SingleArgType.valueOf(types.get(0));
        }
        return TypeHelper.wrapSingleArgTypes(types);
    }

    public static IScriptType wrapSingleTypes(ReturnType ... types) {
        return TypeHelper.wrapSingleReturnTypes(Arrays.asList(types));
    }

    public static IScriptType wrapSingleTypes(ArgType ... types) {
        return TypeHelper.wrapSingleArgTypes(Arrays.asList(types));
    }

    public static IScriptType wrapSingleReturnTypes(List<ReturnType> types) {
        ArrayList result = Lists.newArrayList();
        for (ReturnType t : types) {
            result.add(SingleReturnType.valueOf(t));
        }
        return new TupleType(result);
    }

    public static IScriptType wrapSingleArgTypes(List<ArgType> types) {
        ArrayList result = Lists.newArrayList();
        for (ArgType t : types) {
            result.add(SingleArgType.valueOf(t));
        }
        return new TupleType(result);
    }

    public static boolean isVoid(IScriptType type) {
        return type == SingleType.VOID;
    }

    public static boolean compareTypes(IScriptType left, IScriptType right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        String rightDescription = right.describe();
        String leftDescription = left.describe();
        return leftDescription.equals(rightDescription);
    }

    public static IScriptType interpretArgType(ArgType givenType, Type targetType) {
        return givenType == ArgType.AUTO ? TypeClassifier.INSTANCE.classifyType(targetType) : SingleArgType.valueOf(givenType);
    }
}

