/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.farming.cropplant;

import com.InfinityRaider.AgriCraft.api.v1.IGrowthRequirement;
import com.InfinityRaider.AgriCraft.api.v3.ICrop;
import com.InfinityRaider.AgriCraft.farming.cropplant.CropPlant;
import com.InfinityRaider.AgriCraft.farming.growthrequirement.GrowthRequirementHandler;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.utility.OreDictHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public abstract class CropPlantGeneric
extends CropPlant {
    private final ItemSeeds seed;
    private final Block plant;
    private ArrayList<ItemStack> fruits;

    public CropPlantGeneric(ItemSeeds seed) {
        this.seed = seed;
        this.plant = seed.getPlant(null, 0, 0, 0);
        this.fruits = OreDictHelper.getFruitsFromOreDict(this.getSeed(), this.modSpecificFruits());
    }

    protected boolean modSpecificFruits() {
        return ConfigurationHandler.modSpecifDrops;
    }

    public abstract int transformMeta(int var1);

    @Override
    public int tier() {
        return 2;
    }

    @Override
    public ItemStack getSeed() {
        return new ItemStack((Item)this.seed);
    }

    @Override
    public Block getBlock() {
        return this.plant;
    }

    @Override
    public ArrayList<ItemStack> getAllFruits() {
        return this.fruits;
    }

    @Override
    public ItemStack getRandomFruit(Random rand) {
        ArrayList<ItemStack> list = this.getAllFruits();
        if (list != null && list.size() > 0) {
            return list.get(rand.nextInt(list.size())).func_77946_l();
        }
        return null;
    }

    @Override
    public ArrayList<ItemStack> getFruitsOnHarvest(int gain, Random rand) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int amount = (int)Math.ceil(((double)gain + 0.0) / 3.0); amount > 0; --amount) {
            list.add(this.getRandomFruit(rand));
        }
        return list;
    }

    @Override
    public boolean canBonemeal() {
        return this.getTier() < 4;
    }

    @Override
    protected IGrowthRequirement initGrowthRequirement() {
        return GrowthRequirementHandler.getNewBuilder().build();
    }

    @Override
    public boolean onAllowedGrowthTick(World world, int x, int y, int z, int oldGrowthStage, ICrop crop) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getHeight(int meta) {
        return 0.8125f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getPlantIcon(int growthStage) {
        return this.getBlock().func_149691_a(0, this.transformMeta(growthStage));
    }
}

