/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.core;

import binnie.Binnie;
import binnie.core.resource.BinnieResource;
import binnie.core.resource.IBinnieTexture;
import binnie.core.resource.ResourceType;
import binnie.extratrees.ExtraTrees;

public enum ExtraTreeTexture implements IBinnieTexture
{
    Gui(ResourceType.GUI, "gui"),
    Nursery(ResourceType.Tile, "Nursery");

    String texture;
    ResourceType type;
    public static String carpenterTexture;
    public static String panelerTexture;
    public static String tileworkerTexture;
    public static String incubatorTexture;
    public static String lumbermillTexture;
    public static String pressTexture;
    public static String distilleryTexture;
    public static String breweryTexture;
    public static String infuserTexture;

    private ExtraTreeTexture(ResourceType base, String texture) {
        this.texture = texture;
        this.type = base;
    }

    @Override
    public BinnieResource getTexture() {
        return Binnie.Resource.getPNG(ExtraTrees.instance, this.type, this.texture);
    }

    static {
        carpenterTexture = "extratrees/carpenter_";
        panelerTexture = "extratrees/paneler_";
        tileworkerTexture = "extratrees/tileworker_";
        incubatorTexture = "extratrees/incubator_";
        lumbermillTexture = "extratrees/sawmill_";
        pressTexture = "extratrees/press_";
        distilleryTexture = "extratrees/distillery_";
        breweryTexture = "extratrees/brewery_";
        infuserTexture = "extratrees/infuser_";
    }
}

