/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.genetics.machine;

import binnie.Binnie;
import binnie.core.AbstractMod;
import binnie.core.genetics.BreedingSystem;
import binnie.core.genetics.Gene;
import binnie.craftgui.controls.ControlText;
import binnie.craftgui.controls.ControlTextEdit;
import binnie.craftgui.controls.scroll.ControlScrollableContent;
import binnie.craftgui.controls.tab.ControlTab;
import binnie.craftgui.controls.tab.ControlTabBar;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Tooltip;
import binnie.craftgui.core.geometry.IPoint;
import binnie.craftgui.core.geometry.Position;
import binnie.craftgui.events.EventHandler;
import binnie.craftgui.events.EventTextEdit;
import binnie.craftgui.events.EventValueChanged;
import binnie.craftgui.genetics.machine.ControlGeneScroll;
import binnie.craftgui.genetics.machine.WindowMachine;
import binnie.craftgui.minecraft.MinecraftGUI;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.minecraft.control.ControlPlayerInventory;
import binnie.craftgui.minecraft.control.ControlTabIcon;
import binnie.craftgui.window.Panel;
import binnie.genetics.Genetics;
import binnie.genetics.genetics.Engineering;
import binnie.genetics.genetics.GeneTracker;
import cpw.mods.fml.relauncher.Side;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class WindowGeneBank
extends WindowMachine {
    public static IIcon[] iconsDNA;
    public boolean isNei;
    ControlGeneScroll genes;

    @Override
    public void recieveGuiNBT(Side side, EntityPlayer player, String name, NBTTagCompound action) {
        Gene gene;
        super.recieveGuiNBT(side, player, name, action);
        if (side == Side.SERVER && name.equals("gene-select") && (gene = new Gene(action.func_74775_l("gene"))) != null && !gene.isCorrupted()) {
            ItemStack held = this.getHeldItemStack();
            ItemStack converted = Engineering.addGene(held, gene);
            this.getPlayer().field_71071_by.func_70437_b(converted);
            this.getPlayer().field_71071_by.func_70296_d();
            if (this.getPlayer() instanceof EntityPlayerMP) {
                ((EntityPlayerMP)this.getPlayer()).func_71120_a(player.field_71069_bz);
            }
        }
    }

    public static Window create(EntityPlayer player, IInventory inventory, Side side) {
        return new WindowGeneBank(player, inventory, side, false);
    }

    public WindowGeneBank(EntityPlayer player, IInventory inventory, Side side, boolean isNEI) {
        super(320, 224, player, inventory, side);
        this.isNei = isNEI;
    }

    @Override
    public void initialiseServer() {
        GeneTracker tracker = GeneTracker.getTracker(this.getWorld(), this.getUsername());
        if (tracker != null) {
            tracker.synchToPlayer(this.getPlayer());
        }
    }

    @Override
    public void initialiseClient() {
        this.setTitle("Gene Bank");
        this.addEventHandler((EventHandler)new EventValueChanged.Handler(){

            @Override
            public void onEvent(EventValueChanged event) {
                if (event.value instanceof BreedingSystem) {
                    WindowGeneBank.this.genes.setValue((BreedingSystem)event.value);
                }
            }
        });
        int boxX = 100;
        int x = 16;
        int y = 32;
        new ControlPlayerInventory(this, x, y);
        boxX = x += 124;
        int geneBoxWidth = 120;
        new Panel(this, boxX + 24, 32.0f, geneBoxWidth, 120.0f, MinecraftGUI.PanelType.Black);
        new Panel(this, boxX + 24 + geneBoxWidth, 32.0f, 14.0f, 120.0f, MinecraftGUI.PanelType.Gray);
        ControlScrollableContent<ControlGeneScroll> scroll = new ControlScrollableContent<ControlGeneScroll>(this, boxX + 24 + 2, 34.0f, geneBoxWidth + 10, 116.0f, 12.0f);
        ControlTextEdit edit = new ControlTextEdit(this, boxX + 27 + geneBoxWidth - 70, 18.0f, 80.0f, 12.0f);
        this.addEventHandler(new EventTextEdit.Handler(){

            @Override
            public void onEvent(EventTextEdit event) {
                WindowGeneBank.this.genes.setFilter((String)event.getValue());
            }
        }.setOrigin(EventHandler.Origin.Self, edit));
        this.genes = new ControlGeneScroll(scroll, 1.0f, 1.0f, geneBoxWidth, 116.0f);
        scroll.setScrollableContent(this.genes);
        this.genes.setGenes(Binnie.Genetics.beeBreedingSystem);
        ControlTabBar<BreedingSystem> tabBar = new ControlTabBar<BreedingSystem>((IWidget)this, (float)boxX, 32.0f, 24.0f, 120.0f, Position.Left){

            @Override
            public ControlTab<BreedingSystem> createTab(float x, float y, float w, float h, BreedingSystem value) {
                return new ControlTabIcon<BreedingSystem>((ControlTabBar)this, x, y, w, h, value){

                    @Override
                    public void getTooltip(Tooltip tooltip) {
                        tooltip.add(((BreedingSystem)this.getValue()).toString());
                        int totalGenes = 0;
                        int seqGenes = 0;
                        GeneTracker tracker = GeneTracker.getTracker(WindowGeneBank.this.getWorld(), WindowGeneBank.this.getUsername());
                        Map<IChromosomeType, List<IAllele>> genes = Binnie.Genetics.getChromosomeMap(((BreedingSystem)this.getValue()).getSpeciesRoot());
                        for (Map.Entry<IChromosomeType, List<IAllele>> entry : genes.entrySet()) {
                            totalGenes += entry.getValue().size();
                            for (IAllele allele : entry.getValue()) {
                                Gene gene = new Gene(allele, entry.getKey(), ((BreedingSystem)this.getValue()).getSpeciesRoot());
                                if (!tracker.isSequenced(gene)) continue;
                                ++seqGenes;
                            }
                        }
                        tooltip.add("" + seqGenes + "/" + totalGenes + " Genes");
                    }
                };
            }
        };
        tabBar.setValues(Binnie.Genetics.getActiveSystems());
        tabBar.setValue(Binnie.Genetics.beeBreedingSystem);
        ControlTabBar<String> infoTabs = new ControlTabBar<String>(this, (boxX -= 8) + 8, 160.0f, 16.0f, 50.0f, Position.Left);
        infoTabs.setValues(Arrays.asList("Stats", "Ranking"));
        infoTabs.setValue("Info");
        Panel panelProject = new Panel(this, boxX + 24, 160.0f, geneBoxWidth + 20, 50.0f, MinecraftGUI.PanelType.Black);
        int totalGenes = 0;
        int seqGenes = 0;
        for (BreedingSystem system : Binnie.Genetics.getActiveSystems()) {
            GeneTracker tracker = GeneTracker.getTracker(this.getWorld(), this.getUsername());
            Map<IChromosomeType, List<IAllele>> genes = Binnie.Genetics.getChromosomeMap(system.getSpeciesRoot());
            for (Map.Entry<IChromosomeType, List<IAllele>> entry : genes.entrySet()) {
                totalGenes += entry.getValue().size();
                for (IAllele allele : entry.getValue()) {
                    Gene gene = new Gene(allele, entry.getKey(), system.getSpeciesRoot());
                    if (!tracker.isSequenced(gene)) continue;
                    ++seqGenes;
                }
            }
        }
        new ControlText((IWidget)panelProject, new IPoint(4.0f, 4.0f), "\u00a7nFull Genome Project");
        new ControlText((IWidget)panelProject, new IPoint(4.0f, 18.0f), "\u00a7oSequenced \u00a7r" + seqGenes + "/" + totalGenes + " \u00a7oGenes");
    }

    @Override
    public String getTitle() {
        return "Gene Bank";
    }

    @Override
    protected AbstractMod getMod() {
        return Genetics.instance;
    }

    @Override
    protected String getName() {
        return "GeneBank";
    }

    public static class ChromosomeType {
        IChromosomeType chromosome;
        BreedingSystem system;

        public ChromosomeType(IChromosomeType chromosome, BreedingSystem system) {
            this.chromosome = chromosome;
            this.system = system;
        }

        public String toString() {
            return this.system.getChromosomeName(this.chromosome);
        }
    }
}

