/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.flower;

import binnie.Binnie;
import binnie.botany.Botany;
import binnie.botany.CreativeTabBotany;
import binnie.botany.api.EnumFlowerChromosome;
import binnie.botany.api.EnumFlowerStage;
import binnie.botany.api.IAlleleFlowerSpecies;
import binnie.botany.api.IFlower;
import binnie.botany.api.IFlowerType;
import binnie.botany.core.BotanyCore;
import binnie.botany.flower.BlockFlower;
import binnie.botany.genetics.EnumFlowerType;
import binnie.botany.genetics.Flower;
import binnie.core.BinnieCore;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.core.config.Config;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class ItemBotany
extends Item {
    @SideOnly(value=Side.CLIENT)
    public int func_94901_k() {
        return 0;
    }

    public ItemBotany(String name) {
        this.func_77637_a(CreativeTabBotany.instance);
        this.func_77655_b(name);
        this.field_77787_bX = true;
    }

    public boolean func_77645_m() {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean func_77651_p() {
        return true;
    }

    public boolean func_77636_d(ItemStack itemstack) {
        if (!itemstack.func_77942_o()) {
            return false;
        }
        IIndividual individual = this.getIndividual(itemstack);
        return individual != null && individual.getGenome() != null && individual.hasEffect();
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean flag) {
        if (!itemstack.func_77942_o()) {
            return;
        }
        IFlower individual = (IFlower)this.getIndividual(itemstack);
        if (individual == null) {
            list.add("This item is bugged. Destroy it!");
            return;
        }
        list.add("\u00a7e" + individual.getGenome().getPrimaryColor().getName() + (individual.getGenome().getPrimaryColor() == individual.getGenome().getSecondaryColor() ? "" : " and " + individual.getGenome().getSecondaryColor().getName()) + ", " + individual.getGenome().getStemColor().getName() + " Stem");
        if (individual.isAnalyzed()) {
            if (BinnieCore.proxy.isShiftDown()) {
                individual.addTooltip(list);
            } else {
                list.add("\u00a7o<Hold shift for details>");
            }
        } else {
            list.add("<Unknown>");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
    }

    protected IIndividual getIndividual(ItemStack itemstack) {
        return new Flower(itemstack.func_77978_p());
    }

    private IAlleleFlowerSpecies getPrimarySpecies(ItemStack itemstack) {
        IFlower tree = BotanyCore.speciesRoot.getMember(itemstack);
        if (tree == null) {
            return (IAlleleFlowerSpecies)BotanyCore.speciesRoot.getDefaultTemplate()[EnumFlowerChromosome.SPECIES.ordinal()];
        }
        return tree.getGenome().getPrimary();
    }

    public String func_77653_i(ItemStack itemstack) {
        if (!itemstack.func_77942_o()) {
            return "Unknown";
        }
        IIndividual individual = this.getIndividual(itemstack);
        return individual != null && individual.getGenome() != null ? individual.getDisplayName() + this.getTag() : "Corrupted Flower";
    }

    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        this.addCreativeItems(itemList, true);
    }

    public void addCreativeItems(List itemList, boolean hideSecrets) {
        for (IIndividual individual : BotanyCore.speciesRoot.getIndividualTemplates()) {
            if (hideSecrets && individual.isSecret() && !Config.isDebug) continue;
            itemList.add(BotanyCore.speciesRoot.getMemberStack(individual.copy(), this.getStage().ordinal()));
        }
    }

    public int func_82790_a(ItemStack itemstack, int renderPass) {
        IFlower flower = BotanyCore.speciesRoot.getMember(itemstack);
        if (flower == null || flower.getGenome() == null) {
            return 0xFFFFFF;
        }
        return renderPass == 0 ? flower.getGenome().getStemColor().getColor(flower.isWilted()) : (renderPass == 1 ? flower.getGenome().getPrimaryColor().getColor(flower.isWilted()) : flower.getGenome().getSecondaryColor().getColor(flower.isWilted()));
    }

    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return 3;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack itemstack, int renderPass) {
        IFlower flower = BotanyCore.speciesRoot.getMember(itemstack);
        if (flower == null || flower.getGenome() == null || flower.getGenome().getPrimary() == null) {
            return EnumFlowerType.Allium.getBlank();
        }
        IFlowerType type = flower.getGenome().getPrimary().getType();
        if (renderPass == 0) {
            return type.getStem(this.getStage(), flower.hasFlowered(), type.getSections() - 1);
        }
        if (renderPass == 1) {
            return type.getPetalIcon(this.getStage(), flower.hasFlowered(), type.getSections() - 1);
        }
        return type.getVariantIcon(this.getStage(), flower.hasFlowered(), type.getSections() - 1);
    }

    public boolean func_77648_a(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int side, float px, float py, float pz) {
        if (this.getStage() == EnumFlowerStage.POLLEN) {
            IFlower flower = Binnie.Genetics.getFlowerRoot().getMember(itemstack);
            TileEntity target = world.func_147438_o(x, y, z);
            if (!(target instanceof IPollinatable)) {
                return false;
            }
            IPollinatable pollinatable = (IPollinatable)target;
            if (!pollinatable.canMateWith((IIndividual)flower)) {
                return false;
            }
            pollinatable.mateWith((IIndividual)flower);
            if (!player.field_71075_bZ.field_75098_d) {
                --itemstack.field_77994_a;
            }
            return true;
        }
        BlockFlower blockFlower = Botany.flower;
        Block blockAlreadyThere = world.func_147439_a(x, y, z);
        if (blockAlreadyThere == Blocks.field_150431_aC && (world.func_72805_g(x, y, z) & 7) < 1) {
            side = 1;
        } else if (blockAlreadyThere != Blocks.field_150395_bd && blockAlreadyThere != Blocks.field_150329_H && blockAlreadyThere != Blocks.field_150330_I && !blockAlreadyThere.isReplaceable((IBlockAccess)world, x, y, z)) {
            if (side == 0) {
                --y;
            }
            if (side == 1) {
                ++y;
            }
            if (side == 2) {
                --z;
            }
            if (side == 3) {
                ++z;
            }
            if (side == 4) {
                --x;
            }
            if (side == 5) {
                ++x;
            }
        }
        if (itemstack.field_77994_a == 0) {
            return false;
        }
        if (!player.func_82247_a(x, y, z, side, itemstack)) {
            return false;
        }
        if (y == 255 && blockFlower.func_149688_o().func_76220_a()) {
            return false;
        }
        if (world.func_147472_a((Block)blockFlower, x, y, z, false, side, (Entity)player, itemstack)) {
            int i1 = this.func_77647_b(itemstack.func_77960_j());
            int j1 = blockFlower.func_149660_a(world, x, y, z, side, px, py, pz, i1);
            if (this.placeBlockAt(itemstack, player, world, x, y, z, side, px, py, pz, j1)) {
                world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), ((Block)blockFlower).field_149762_H.func_150496_b(), (((Block)blockFlower).field_149762_H.func_150497_c() + 1.0f) / 2.0f, ((Block)blockFlower).field_149762_H.func_150494_d() * 0.8f);
                --itemstack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_150936_a(World p_150936_1_, int p_150936_2_, int p_150936_3_, int p_150936_4_, int p_150936_5_, EntityPlayer p_150936_6_, ItemStack p_150936_7_) {
        BlockFlower field_150939_a = Botany.flower;
        Block block = p_150936_1_.func_147439_a(p_150936_2_, p_150936_3_, p_150936_4_);
        if (block == Blocks.field_150431_aC) {
            p_150936_5_ = 1;
        } else if (block != Blocks.field_150395_bd && block != Blocks.field_150329_H && block != Blocks.field_150330_I && !block.isReplaceable((IBlockAccess)p_150936_1_, p_150936_2_, p_150936_3_, p_150936_4_)) {
            if (p_150936_5_ == 0) {
                --p_150936_3_;
            }
            if (p_150936_5_ == 1) {
                ++p_150936_3_;
            }
            if (p_150936_5_ == 2) {
                --p_150936_4_;
            }
            if (p_150936_5_ == 3) {
                ++p_150936_4_;
            }
            if (p_150936_5_ == 4) {
                --p_150936_2_;
            }
            if (p_150936_5_ == 5) {
                ++p_150936_2_;
            }
        }
        return p_150936_1_.func_147472_a((Block)field_150939_a, p_150936_2_, p_150936_3_, p_150936_4_, false, p_150936_5_, (Entity)null, p_150936_7_);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        BlockFlower field_150939_a = Botany.flower;
        if (!world.func_147465_d(x, y, z, (Block)field_150939_a, metadata, 3)) {
            return false;
        }
        if (world.func_147439_a(x, y, z) == field_150939_a) {
            field_150939_a.func_149689_a(world, x, y, z, (EntityLivingBase)player, stack);
            field_150939_a.func_149714_e(world, x, y, z, metadata);
        }
        return true;
    }

    public abstract EnumFlowerStage getStage();

    public abstract String getTag();
}

