/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import openmods.access.ApiSingleton;
import openperipheral.addons.api.ITerminalIdAccess;
import openperipheral.addons.api.ITerminalIdGetter;
import openperipheral.addons.api.ITerminalIdSetter;
import openperipheral.addons.api.ITerminalItem;
import openperipheral.addons.glasses.TerminalUtils;
import org.apache.commons.lang3.ArrayUtils;

@ApiSingleton
public class TerminalIdAccess
implements ITerminalIdAccess {
    public static final TerminalIdAccess instance = new TerminalIdAccess();
    private ITerminalIdGetter[] getters = new ITerminalIdGetter[0];
    private ITerminalIdSetter[] setters = new ITerminalIdSetter[0];

    private TerminalIdAccess() {
    }

    @Override
    public Optional<Long> getIdFrom(EntityPlayer player) {
        for (ITerminalIdGetter getter : this.getters) {
            Optional<Long> result = getter.getFor(player);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.absent();
    }

    @Override
    public void register(ITerminalIdGetter getter) {
        Preconditions.checkNotNull((Object)getter);
        this.getters = (ITerminalIdGetter[])ArrayUtils.add((Object[])this.getters, (Object)getter);
        Arrays.sort(this.getters, new Comparator<ITerminalIdGetter>(){

            @Override
            public int compare(ITerminalIdGetter o1, ITerminalIdGetter o2) {
                return Ints.compare((int)o1.getPriority(), (int)o2.getPriority());
            }
        });
    }

    @Override
    public boolean setIdFor(EntityPlayer player, long guid) {
        for (ITerminalIdSetter setter : this.setters) {
            if (!setter.setFor(player, guid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void register(ITerminalIdSetter setter) {
        Preconditions.checkNotNull((Object)setter);
        this.setters = (ITerminalIdSetter[])ArrayUtils.add((Object[])this.setters, (Object)setter);
        Arrays.sort(this.setters, new Comparator<ITerminalIdSetter>(){

            @Override
            public int compare(ITerminalIdSetter o1, ITerminalIdSetter o2) {
                return Ints.compare((int)o1.getPriority(), (int)o2.getPriority());
            }
        });
    }

    public static class InterfaceSetter
    extends HandSetterAdapter {
        @Override
        public boolean setFor(ItemStack stack, long guid) {
            Item item = stack.func_77973_b();
            if (item instanceof ITerminalItem) {
                ITerminalItem terminalItem = (ITerminalItem)item;
                terminalItem.bindToTerminal(stack, guid);
                return true;
            }
            return false;
        }
    }

    public static class InterfaceGetter
    extends HelmetGetterAdapter {
        @Override
        public Optional<Long> getFor(ItemStack stack) {
            Item item = stack.func_77973_b();
            if (item instanceof ITerminalItem) {
                ITerminalItem terminalItem = (ITerminalItem)item;
                return Optional.fromNullable((Object)terminalItem.getTerminalGuid(stack));
            }
            return Optional.absent();
        }
    }

    static abstract class HandSetterAdapter
    implements ITerminalIdSetter {
        HandSetterAdapter() {
        }

        @Override
        public boolean setFor(EntityPlayer player, long guid) {
            ItemStack stack = player.func_70694_bm();
            return stack != null ? this.setFor(stack, guid) : false;
        }

        protected abstract boolean setFor(ItemStack var1, long var2);

        @Override
        public int getPriority() {
            return 0;
        }
    }

    static abstract class HelmetGetterAdapter
    implements ITerminalIdGetter {
        HelmetGetterAdapter() {
        }

        @Override
        public Optional<Long> getFor(EntityPlayer player) {
            ItemStack stack = TerminalUtils.getHeadSlot(player);
            return stack != null ? this.getFor(stack) : Optional.absent();
        }

        protected abstract Optional<Long> getFor(ItemStack var1);

        @Override
        public int getPriority() {
            return 0;
        }
    }
}

