/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import openmods.calc.IValueParser;
import openmods.calc.PositionalNotationParser;
import openmods.calc.Token;
import org.apache.commons.lang3.math.Fraction;
import org.apache.commons.lang3.tuple.Pair;

public class FractionParser
implements IValueParser<Fraction> {
    private static final PositionalNotationParser<Fraction> PARSER = new PositionalNotationParser<Fraction>(){

        public PositionalNotationParser.Accumulator<Fraction> createIntegerAccumulator(int radix) {
            final Fraction fractionalRadix = Fraction.getFraction((int)radix, (int)1);
            return new PositionalNotationParser.Accumulator<Fraction>(){
                private Fraction value = Fraction.ZERO;

                @Override
                public void add(int digit) {
                    this.value = this.value.multiplyBy(fractionalRadix).add(Fraction.getFraction((int)digit, (int)1));
                }

                @Override
                public Fraction get() {
                    return this.value;
                }
            };
        }

        protected PositionalNotationParser.Accumulator<Fraction> createFractionalAccumulator(final int radix) {
            return new PositionalNotationParser.Accumulator<Fraction>(){
                private Fraction value = Fraction.ZERO;
                private int weight = radix;

                @Override
                public void add(int digit) {
                    this.value = this.value.add(Fraction.getFraction((int)digit, (int)this.weight));
                    this.weight *= radix;
                }

                @Override
                public Fraction get() {
                    return this.value.reduce();
                }
            };
        }
    };

    public Fraction parseToken(Token token) {
        Pair result = PARSER.parseToken(token);
        Fraction left = (Fraction)result.getLeft();
        Fraction right = (Fraction)result.getRight();
        return right != null ? left.add(right) : left;
    }
}

