/*
 * Decompiled with CFR 0.152.
 */
package solarexpansion.utilities;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import solarexpansion.blocks.SolarPanel;
import solarexpansion.utilities.Utils;

public class TooltipSolarPanel
extends ItemBlock {
    public TooltipSolarPanel(Block block) {
        super(block);
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean bool) {
        SolarPanel solarPanel = (SolarPanel)this.field_150939_a;
        if (!Utils.isShiftKeyDown()) {
            list.add(Utils.shiftForDetails());
        } else {
            list.add(String.format(Utils.addEnergyGenerationTooltip() + EnumChatFormatting.DARK_GREEN + " %,d" + Utils.addRFtTooltip(), solarPanel.getEnergyGeneration()));
            list.add(String.format(Utils.addEnergyTransferTooltip() + EnumChatFormatting.DARK_GREEN + " %,d" + Utils.addRFtTooltip(), solarPanel.getEnergyTransfer()));
            list.add(String.format(Utils.addEnergyCapacityTooltip() + EnumChatFormatting.DARK_GREEN + " %,d" + Utils.addRFTooltip(), solarPanel.getEnergyCapacity()));
        }
        if (!Utils.isControlKeyDown()) {
            list.add(Utils.controlForDetails());
        } else {
            int maxEnergy;
            int energy = solarPanel.getEnergyStored(itemStack);
            if (energy > (maxEnergy = solarPanel.getMaxEnergyStored(itemStack)) / 4 * 3) {
                list.add(String.format(EnumChatFormatting.DARK_GREEN + "%,d / %,d", energy, maxEnergy) + Utils.addRFTooltip());
            }
            if (energy <= maxEnergy / 4 * 3 && energy > maxEnergy / 4) {
                list.add(String.format(EnumChatFormatting.YELLOW + "%,d / %,d", energy, maxEnergy) + Utils.addRFTooltip());
            }
            if (energy <= maxEnergy / 4 && energy > 0) {
                list.add(String.format(EnumChatFormatting.RED + "%,d / %,d", energy, maxEnergy) + Utils.addRFTooltip());
            }
            if (energy == 0) {
                list.add(String.format("%,d / %,d", energy, maxEnergy) + Utils.addRFTooltip());
            }
        }
    }

    public boolean showDurabilityBar(ItemStack itemStack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        SolarPanel solarPanel = (SolarPanel)this.field_150939_a;
        int energy = solarPanel.getEnergyStored(itemStack);
        int maxEnergy = solarPanel.getMaxEnergyStored(itemStack);
        return 1.0 - (double)energy / (double)maxEnergy;
    }
}

