/*
 * Decompiled with CFR 0.152.
 */
package neresources.registry;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import neresources.entries.DungeonEntry;
import neresources.utils.ReflectionHelper;
import neresources.utils.TranslationHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ChestGenHooks;

public class DungeonRegistry {
    private Map<String, DungeonEntry> registry = new LinkedHashMap<String, DungeonEntry>();
    public static Map<String, String> categoryToLocalKeyMap = new LinkedHashMap<String, String>();
    private static DungeonRegistry instance = null;

    public static DungeonRegistry getInstance() {
        if (instance == null) {
            instance = new DungeonRegistry();
            return instance;
        }
        return instance;
    }

    public DungeonRegistry() {
        DungeonRegistry.addCategoryMapping("mineshaftCorridor", "ner.dungeon.mineshaftCorridor");
        DungeonRegistry.addCategoryMapping("pyramidDesertyChest", "ner.dungeon.pyramidDesertyChest");
        DungeonRegistry.addCategoryMapping("pyramidJungleChest", "ner.dungeon.pyramidJungleChest");
        DungeonRegistry.addCategoryMapping("pyramidJungleDispenser", "ner.dungeon.pyramidJungleDispenser");
        DungeonRegistry.addCategoryMapping("strongholdCorridor", "ner.dungeon.strongholdCorridor");
        DungeonRegistry.addCategoryMapping("strongholdLibrary", "ner.dungeon.strongholdLibrary");
        DungeonRegistry.addCategoryMapping("strongholdCrossing", "ner.dungeon.strongholdCrossing");
        DungeonRegistry.addCategoryMapping("villageBlacksmith", "ner.dungeon.villageBlacksmith");
        DungeonRegistry.addCategoryMapping("bonusChest", "ner.dungeon.bonusChest");
        DungeonRegistry.addCategoryMapping("dungeonChest", "ner.dungeon.dungeonChest");
    }

    public static boolean addCategoryMapping(String category, String name) {
        if (!categoryToLocalKeyMap.containsKey(category)) {
            categoryToLocalKeyMap.put(category, name);
            return true;
        }
        return false;
    }

    public boolean registerChestHook(String name, ChestGenHooks chestGenHooks) {
        if (!this.registry.containsKey(name)) {
            this.registry.put(name, new DungeonEntry(name, chestGenHooks));
            return true;
        }
        return false;
    }

    public boolean registerChestHook(ChestGenHooks chestGenHooks) {
        String name = ReflectionHelper.getString(ChestGenHooks.class, "category", chestGenHooks);
        if (categoryToLocalKeyMap.containsKey(name)) {
            return this.registerChestHook(categoryToLocalKeyMap.get(name), chestGenHooks);
        }
        return this.registerChestHook(name, chestGenHooks);
    }

    public void registerDungeonEntry(DungeonEntry entry) {
        String name = entry.getName();
        if (this.registry.containsKey(name)) {
            return;
        }
        this.registry.put(name, entry);
    }

    public List<DungeonEntry> getDungeons(ItemStack item) {
        ArrayList<DungeonEntry> list = new ArrayList<DungeonEntry>();
        for (DungeonEntry entry : this.registry.values()) {
            if (!entry.containsItem(item)) continue;
            list.add(entry);
        }
        return list;
    }

    public List<DungeonEntry> getDungeons() {
        return new ArrayList<DungeonEntry>(this.registry.values());
    }

    public String getNumStacks(DungeonEntry entry) {
        int max = entry.getMaxStacks();
        int min = entry.getMinStacks();
        if (min == max) {
            return String.format(TranslationHelper.translateToLocal("ner.stacks"), max);
        }
        return String.format(TranslationHelper.translateToLocal("ner.stacks"), min + " - " + max);
    }

    public void clear() {
        instance = new DungeonRegistry();
    }
}

