/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.items;

import com.InfinityRaider.AgriCraft.AgriCraft;
import com.InfinityRaider.AgriCraft.api.v2.IJournal;
import com.InfinityRaider.AgriCraft.farming.CropPlantHandler;
import com.InfinityRaider.AgriCraft.items.ItemAgricraft;
import com.InfinityRaider.AgriCraft.renderers.items.RenderItemBase;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import com.InfinityRaider.AgriCraft.utility.NBTHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemJournal
extends ItemAgricraft
implements IJournal {
    public ItemJournal() {
        this.func_77625_d(1);
    }

    @Override
    protected String getInternalName() {
        return "journal";
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public boolean func_77630_h(ItemStack itemStack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        return itemStack.func_77946_l();
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        NBTTagCompound tag;
        ItemStack journal = player.func_71045_bC();
        if (journal.func_77942_o() && (tag = journal.field_77990_d).func_74764_b("discoveredSeeds")) {
            NBTTagList list = tag.func_150295_c("discoveredSeeds", 10);
            NBTHelper.clearEmptyStacksFromNBT(list);
            tag.func_74782_a("discoveredSeeds", (NBTBase)list);
        }
        if (world.field_72995_K) {
            player.openGui((Object)AgriCraft.instance, 2, world, player.field_70118_ct, player.field_70117_cu, player.field_70116_cv);
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean flag) {
        int nr = 0;
        if (stack.func_77942_o() && stack.field_77990_d.func_74764_b("discoveredSeeds")) {
            nr = stack.field_77990_d.func_150295_c("discoveredSeeds", 10).func_74745_c();
        }
        list.add(StatCollector.func_74838_a((String)"agricraft_tooltip.discoveredSeeds") + ": " + nr);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        LogHelper.debug("registering icon for: " + this.func_77658_a());
        this.field_77791_bV = reg.func_94245_a(this.func_77658_a().substring(this.func_77658_a().indexOf(46) + 1));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public RenderItemBase getItemRenderer() {
        return null;
    }

    private NBTTagList getDiscoveredSeedsTaglist(ItemStack journal) {
        NBTTagList list;
        NBTTagCompound tag;
        if (!journal.func_77942_o()) {
            journal.func_77982_d(new NBTTagCompound());
        }
        if ((tag = journal.field_77990_d).func_74764_b("discoveredSeeds")) {
            list = tag.func_150295_c("discoveredSeeds", 10);
            NBTHelper.clearEmptyStacksFromNBT(list);
        } else {
            list = new NBTTagList();
        }
        return list;
    }

    @Override
    public void addEntry(ItemStack journal, ItemStack newEntry) {
        if (journal == null || journal.func_77973_b() == null || !CropPlantHandler.isValidSeed(newEntry)) {
            return;
        }
        NBTTagList list = this.getDiscoveredSeedsTaglist(journal);
        NBTTagCompound tag = journal.field_77990_d;
        if (!this.isSeedDiscovered(journal, newEntry)) {
            NBTTagCompound seedTag = new NBTTagCompound();
            ItemStack write = newEntry.func_77946_l();
            write.field_77994_a = 1;
            write.field_77990_d = null;
            write.func_77955_b(seedTag);
            list.func_74742_a((NBTBase)seedTag);
        }
        NBTHelper.sortStacks(list);
        tag.func_74782_a("discoveredSeeds", (NBTBase)list);
    }

    @Override
    public boolean isSeedDiscovered(ItemStack journal, ItemStack seed) {
        if (journal == null || journal.func_77973_b() == null || !CropPlantHandler.isValidSeed(seed)) {
            return false;
        }
        return NBTHelper.listContainsStack(this.getDiscoveredSeedsTaglist(journal), seed);
    }

    @Override
    public ArrayList<ItemStack> getDiscoveredSeeds(ItemStack journal) {
        ArrayList<ItemStack> seeds = new ArrayList<ItemStack>();
        NBTTagCompound tag = null;
        if (journal != null && journal.field_77994_a > 0 && journal.func_77973_b() instanceof ItemJournal && journal.func_77942_o()) {
            tag = journal.func_77978_p();
        }
        if (tag != null && tag.func_74764_b("discoveredSeeds")) {
            NBTTagList tagList = tag.func_150295_c("discoveredSeeds", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                ItemStack seed = ItemStack.func_77949_a((NBTTagCompound)tagList.func_150305_b(i));
                if (!CropPlantHandler.isValidSeed(seed)) continue;
                seeds.add(seed);
            }
        }
        return seeds;
    }
}

