/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.farming.mutation;

import com.InfinityRaider.AgriCraft.api.v1.IMutation;
import com.InfinityRaider.AgriCraft.farming.CropPlantHandler;
import com.InfinityRaider.AgriCraft.farming.cropplant.CropPlant;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class Mutation
implements IMutation {
    private ItemStack result;
    private ItemStack parent1;
    private ItemStack parent2;
    private double chance;

    public Mutation(ItemStack result, ItemStack parent1, ItemStack parent2, double chance) {
        this.result = result;
        this.parent1 = parent1;
        this.parent2 = parent2;
        this.chance = chance;
    }

    public Mutation(ItemStack result, ItemStack parent1, ItemStack parent2) {
        this(result, parent1, parent2, 100);
        CropPlant plant = CropPlantHandler.getPlantFromStack(result);
        this.chance = plant == null ? 0.0 : (double)plant.getSpreadChance() / 100.0;
    }

    public Mutation(IMutation mutation) {
        this.result = mutation.getResult();
        this.parent1 = mutation.getParents()[0];
        this.parent2 = mutation.getParents()[1];
        this.chance = mutation.getChance();
    }

    @Override
    public ItemStack getResult() {
        return this.result.func_77946_l();
    }

    @Override
    public ItemStack[] getParents() {
        ItemStack[] parents = new ItemStack[]{this.parent1.func_77946_l(), this.parent2.func_77946_l()};
        return parents;
    }

    @Override
    public double getChance() {
        return this.chance;
    }

    @Override
    public void setChance(double d) {
        this.chance = d;
    }

    public Mutation(ItemStack result, ItemStack parent1, ItemStack parent2, int chance) {
        this(result, parent1, parent2, (double)chance / 100.0);
    }

    public boolean equals(Object object) {
        boolean isEqual = false;
        if (object instanceof Mutation) {
            Mutation mutation = (Mutation)object;
            if (this.chance == mutation.chance && this.result.func_77969_a(mutation.result)) {
                if (this.parent1.func_77969_a(mutation.parent1) && this.parent2.func_77969_a(mutation.parent2)) {
                    isEqual = true;
                } else if (this.parent1.func_77969_a(mutation.parent2) && this.parent2.func_77969_a(mutation.parent1)) {
                    isEqual = true;
                }
            }
        }
        return isEqual;
    }

    public String getFormula() {
        String result = this.result != null ? Item.field_150901_e.func_148750_c((Object)this.result.func_77973_b()) + ':' + this.result.func_77960_j() : "null";
        String parent1 = this.parent1.func_77973_b() != null ? Item.field_150901_e.func_148750_c((Object)this.parent1.func_77973_b()) + ':' + this.parent1.func_77960_j() : "null";
        String parent2 = this.parent2.func_77973_b() != null ? Item.field_150901_e.func_148750_c((Object)this.parent2.func_77973_b()) + ':' + this.parent2.func_77960_j() : "null";
        return result + " = " + parent1 + " + " + parent2;
    }
}

