/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.commands.commands.wrapper;

import logisticspipes.asm.wrapper.AbstractWrapper;
import logisticspipes.asm.wrapper.LogisticsWrapperHandler;
import logisticspipes.asm.wrapper.WrapperState;
import logisticspipes.commands.abstracts.ICommandHandler;
import logisticspipes.commands.chathelper.MorePageDisplay;
import logisticspipes.utils.string.ChatColor;
import net.minecraft.command.ICommandSender;

public class ListCommand
implements ICommandHandler {
    @Override
    public String[] getNames() {
        return new String[]{"list"};
    }

    @Override
    public boolean isCommandUsableBy(ICommandSender sender) {
        return true;
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Lists all wrapper and their status."};
    }

    @Override
    public void executeCommand(ICommandSender sender, String[] args) {
        MorePageDisplay display = new MorePageDisplay(new String[]{"|< Wrapper status - Page: %/$ >|"}, sender);
        for (AbstractWrapper controller : LogisticsWrapperHandler.wrapperController) {
            StringBuilder builder = new StringBuilder();
            builder.append((Object)ChatColor.AQUA);
            builder.append(controller.getName());
            builder.append(controller.getTypeName());
            builder.append(": ");
            if (controller.getState() == WrapperState.Enabled) {
                builder.append((Object)ChatColor.GREEN);
                builder.append("enabled");
            } else if (controller.getState() == WrapperState.ModMissing) {
                builder.append((Object)ChatColor.GRAY);
                builder.append("disabled (mod not found)");
            } else if (controller.getState() == WrapperState.Exception) {
                builder.append((Object)ChatColor.RED);
                builder.append("disabled (exception)");
            } else {
                builder.append((Object)ChatColor.BLUE);
                builder.append("disabled (" + controller.getReason() + ")");
            }
            display.append(builder.toString());
        }
        display.display(sender);
    }
}

