/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.network;

import hardcorequesting.FileVersion;
import hardcorequesting.QuestingData;
import hardcorequesting.network.DataReader;
import hardcorequesting.network.DataWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public abstract class FileHelper {
    private static final String BACKUP_SUFFIX = "-backup";
    private static final String PRE_CRASH_SUFFIX = "-pre-crash-";

    private void createFolder(File dir) throws IOException {
        if (dir == null) {
            return;
        }
        File parent = dir.getParentFile();
        this.createFolder(parent);
        if (!dir.isDirectory()) {
            dir.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SaveResult saveData(File file) {
        if (!this.backup(file)) {
            return SaveResult.BACKUP_FAIL;
        }
        try (DataWriter dw = null;){
            this.createFolder(file.getParentFile());
            dw = new DataWriter(new FileOutputStream(file));
            dw.writeByte(QuestingData.FILE_VERSION.ordinal());
            this.write(dw);
            dw.writeFinalBits();
            SaveResult saveResult = SaveResult.SUCCESS;
            return saveResult;
        }
    }

    private boolean moveUpFileIndices(String path, int id) {
        File file = new File(path + id);
        return !file.exists() || this.moveUpFileIndices(path, id + 1) && file.renameTo(new File(path + (id + 1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadData(File file) {
        try (DataReader dr = null;){
            this.createFolder(file.getParentFile());
            if (!file.exists()) {
                boolean bl = false;
                return bl;
            }
            dr = new DataReader(new FileInputStream(file));
            this.read(dr, dr.readVersion());
            boolean bl = true;
            return bl;
        }
    }

    public boolean backup(File fileToBackUp) {
        return this.backup(fileToBackUp, new File(fileToBackUp.getAbsolutePath() + BACKUP_SUFFIX));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean backup(File fileToBackUp, File backup) {
        if (fileToBackUp.exists()) {
            FileInputStream inputStream = null;
            FileOutputStream outputStream = null;
            try {
                inputStream = new FileInputStream(fileToBackUp);
                outputStream = new FileOutputStream(backup);
                while (inputStream.available() > 0) {
                    outputStream.write(inputStream.read());
                }
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                e.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public abstract void write(DataWriter var1);

    public abstract void read(DataReader var1, FileVersion var2);

    public static enum SaveResult {
        SUCCESS("Success", "Everything was successfully saved"),
        BACKUP_FAIL("Backup failure", "Couldn't backup the previous saved data. Please fix this and save again."),
        SAVE_FAIL("Save failure", "Couldn't save the data to file. Your previous backup has been saved."),
        PRE_CRASH_FAILURE("Double save failure", "Couldn't save the data to file. And when trying to backup your previously saved data, this didn't work either.");

        private String name;
        private String text;

        private SaveResult(String name, String text) {
            this.name = name;
            this.text = text;
        }

        public String getName() {
            return this.name;
        }

        public String getText() {
            return this.text;
        }
    }
}

