/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.client.interfaces;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hardcorequesting.DeathStats;
import hardcorequesting.DeathType;
import hardcorequesting.QuestingData;
import hardcorequesting.Translator;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiEditMenu;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.client.interfaces.ResourceHelper;
import hardcorequesting.client.interfaces.ScrollBar;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiEditMenuDeath
extends GuiEditMenu {
    private String selectedName;
    private boolean showTotal;
    private boolean showBest;
    private static final int PLAYER_INFO_X = 180;
    private static final int PLAYER_INFO_Y = 20;
    private static final int PLAYER_TOTAL_DEATHS_Y = 12;
    private static final int BACKGROUND_SIZE = 22;
    private static final int ICON_OFFSET = 1;
    private static final int BACKGROUND_SRC_X = 234;
    private static final int BACKGROUND_SRC_Y = 55;
    private static final int ICON_SRC_X = 179;
    private static final int ICON_SRC_Y = 156;
    private static final int ICON_SIZE = 20;
    private static final int TYPE_LOCATION_X = 180;
    private static final int TYPE_LOCATION_Y = 50;
    private static final int TYPE_SPACING_X = 47;
    private static final int TYPE_SPACING_Y = 30;
    private static final int TEXT_OFFSET_X = 28;
    private static final int TEXT_OFFSET_Y = 7;
    private static final int PLAYERS_X = 20;
    private static final int PLAYERS_Y = 20;
    private static final int PLAYERS_SPACING = 20;
    private static final int DEATHS_RIGHT = 140;
    private static final String BEST_LABEL = "hqm.deathMenu.showWorst";
    private static final String TOTAL_LABEL = "hqm.deathMenu.showTotal";
    private static final int BEST_X = 185;
    private static final int TOTAL_X = 255;
    private static final int LABEL_Y = 210;
    private ScrollBar scrollBar;
    private static final int VISIBLE_PLAYERS = 10;
    private static final float[] DIGIT_TEXT_SIZE = new float[]{1.0f, 1.0f, 0.8f, 0.6f, 0.4f};

    public GuiEditMenuDeath(GuiQuestBook guiQuestBook, EntityPlayer player) {
        super(guiQuestBook, player);
        this.selectedName = QuestingData.getUserName(player);
        this.scrollBar = new ScrollBar(160, 18, 186, 171, 69, 20){

            @Override
            public boolean isVisible(GuiBase gui) {
                return DeathStats.getDeathStats().length > 10;
            }
        };
    }

    @Override
    public void draw(GuiBase gui, int mX, int mY) {
        super.draw(gui, mX, mY);
        this.scrollBar.draw(gui);
        DeathStats[] deathStats = DeathStats.getDeathStats();
        int start = this.scrollBar.isVisible(gui) ? Math.round((float)(deathStats.length - 10) * this.scrollBar.getScroll()) : 0;
        int end = Math.min(deathStats.length, start + 10);
        for (int i = start; i < end; ++i) {
            DeathStats stats = deathStats[i];
            boolean selected = stats.getName().equals(this.selectedName);
            boolean inBounds = gui.inBounds(20, 20 + (i - start) * 20, 130, 9, mX, mY);
            gui.drawString(i + 1 + ". " + stats.getName(), 20, 20 + (i - start) * 20, this.getColor(selected, inBounds));
            String deaths = String.valueOf(stats.getTotalDeaths());
            gui.drawString(deaths, 140 - gui.getStringWidth(deaths), 20 + (i - start) * 20, 0x404040);
        }
        gui.drawString(Translator.translate(BEST_LABEL), 185, 210, this.getColor(this.showBest, gui.inBounds(185, 210, gui.getStringWidth(BEST_LABEL), 9, mX, mY)));
        gui.drawString(Translator.translate(TOTAL_LABEL), 255, 210, this.getColor(this.showTotal, gui.inBounds(255, 210, gui.getStringWidth(TOTAL_LABEL), 9, mX, mY)));
        DeathStats stats = this.getStats();
        if (stats != null) {
            int y;
            int x;
            int i;
            ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (i = 0; i < DeathType.values().length; ++i) {
                x = i % 3;
                y = i / 3;
                gui.drawRect(180 + 47 * x, 50 + 30 * y, 234, 55, 22, 22);
                gui.drawRect(180 + 47 * x + 1, 50 + 30 * y + 1, 179 + 20 * x, 156 + 20 * y, 20, 20);
            }
            gui.drawString(stats.getName(), 180, 20, 0x404040);
            gui.drawString(Translator.translate("hqm.deathMenu.total", stats.getTotalDeaths()), 180, 32, 0.7f, 0x404040);
            for (i = 0; i < DeathType.values().length; ++i) {
                float f;
                x = i % 3;
                y = i / 3;
                String str = String.valueOf(stats.getDeaths(i));
                if (str.length() > 5) {
                    str = Translator.translate("hqm.deathMenu.lots");
                }
                int offset = (f = DIGIT_TEXT_SIZE[str.length() - 1]) == 1.0f ? 0 : Math.round(9.0f * (1.0f - f) - 1.0f);
                gui.drawString(str, 180 + 47 * x + 28, 50 + 30 * y + 7 + offset, f, 0x404040);
            }
        }
    }

    private DeathStats getStats() {
        if (this.showBest) {
            return DeathStats.getBest();
        }
        if (this.showTotal) {
            return DeathStats.getTotal();
        }
        if (this.selectedName != null) {
            return DeathStats.getDeathStats(this.selectedName);
        }
        return null;
    }

    @Override
    public void drawMouseOver(GuiBase gui, int mX, int mY) {
        super.drawMouseOver(gui, mX, mY);
        DeathStats stats = this.getStats();
        if (stats != null) {
            for (int i = 0; i < DeathType.values().length; ++i) {
                int x = i % 3;
                int y = i / 3;
                if (!gui.inBounds(180 + 47 * x, 50 + 30 * y, 22, 22, mX, mY)) continue;
                gui.drawMouseOver(stats.getDescription(i), mX + gui.getLeft(), mY + gui.getTop());
                break;
            }
        }
    }

    private int getColor(boolean selected, boolean inBounds) {
        return selected ? (inBounds ? 0xC0C0C0 : 0xA0A0A0) : (inBounds ? 0x707070 : 0x404040);
    }

    @Override
    public void onClick(GuiBase gui, int mX, int mY, int b) {
        super.onClick(gui, mX, mY, b);
        this.scrollBar.onClick(gui, mX, mY);
        if (gui.inBounds(185, 210, gui.getStringWidth(Translator.translate(BEST_LABEL)), 9, mX, mY)) {
            this.showBest = !this.showBest;
            this.showTotal = false;
            this.selectedName = null;
        } else if (gui.inBounds(255, 210, gui.getStringWidth(Translator.translate(TOTAL_LABEL)), 9, mX, mY)) {
            this.showBest = false;
            this.showTotal = !this.showTotal;
            this.selectedName = null;
        } else {
            this.showTotal = false;
            this.showBest = false;
            DeathStats[] deathStats = DeathStats.getDeathStats();
            int start = this.scrollBar.isVisible(gui) ? Math.round((float)(deathStats.length - 10) * this.scrollBar.getScroll()) : 0;
            int end = Math.min(deathStats.length, start + 10);
            for (int i = start; i < end; ++i) {
                DeathStats stats = deathStats[i];
                if (!gui.inBounds(20, 20 + (i - start) * 20, 130, 9, mX, mY)) continue;
                this.selectedName = stats.getName().equals(this.selectedName) ? null : stats.getName();
            }
        }
    }

    @Override
    public void onDrag(GuiBase gui, int mX, int mY) {
        this.scrollBar.onDrag(gui, mX, mY);
    }

    @Override
    public void onRelease(GuiBase gui, int mX, int mY) {
        this.scrollBar.onRelease(gui, mX, mY);
    }

    @Override
    public void onScroll(GuiBase gui, int mX, int mY, int scroll) {
        this.scrollBar.onScroll(gui, mX, mY, scroll);
    }

    @Override
    protected void save(GuiBase gui) {
    }
}

