/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.monitor;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.gui.Scrollable;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.ChoiceEvent;
import mcjty.lib.gui.events.DefaultSelectionEvent;
import mcjty.lib.gui.events.SelectionEvent;
import mcjty.lib.gui.events.ValueEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.ScrollableLabel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.varia.Coordinate;
import mcjty.rftools.BlockInfo;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.monitor.LiquidMonitorBlockTileEntity;
import mcjty.rftools.blocks.monitor.PacketContentsMonitor;
import mcjty.rftools.blocks.monitor.PacketGetAdjacentTankBlocks;
import mcjty.rftools.blocks.monitor.RFMonitorMode;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.block.Block;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.world.World;

public class GuiLiquidMonitor
extends GenericGuiContainer<LiquidMonitorBlockTileEntity> {
    private WidgetList list;
    private ChoiceLabel alarmModeChoiceLabel;
    private ScrollableLabel alarmLabel;
    private int listDirty;
    public static final int TEXT_COLOR_SELECTED = 0xFFFFFF;
    private List<Coordinate> adjacentBlocks = null;
    public static List<Coordinate> fromServer_clientAdjacentBlocks = null;

    public GuiLiquidMonitor(LiquidMonitorBlockTileEntity liquidMonitorBlockTileEntity, Container container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)liquidMonitorBlockTileEntity, container, RFTools.GUI_MANUAL_MAIN, "liqmonitor");
        this.field_146999_f = 256;
        this.field_147000_g = 180;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.list = new WidgetList(this.field_146297_k, (Gui)this).addSelectionEvent((SelectionEvent)new DefaultSelectionEvent(){

            public void select(Widget parent, int index) {
                GuiLiquidMonitor.this.setSelectedBlock(index);
            }
        });
        this.listDirty = 0;
        Slider listSlider = ((Slider)new Slider(this.field_146297_k, (Gui)this).setDesiredWidth(10)).setVertical().setScrollable((Scrollable)this.list);
        Panel listPanel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setHorizontalMargin(3)).setSpacing(1)).addChild((Widget)this.list)).addChild((Widget)listSlider);
        this.alarmModeChoiceLabel = ((ChoiceLabel)((ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).addChoices(new String[]{RFMonitorMode.MODE_OFF.getDescription(), RFMonitorMode.MODE_LESS.getDescription(), RFMonitorMode.MODE_MORE.getDescription()}).setDesiredWidth(60)).setDesiredHeight(15)).setTooltips(new String[]{"Control when a redstone", "signal should be sent"})).addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiLiquidMonitor.this.changeAlarmMode(RFMonitorMode.getModeFromDescription(newChoice));
            }
        });
        this.alarmModeChoiceLabel.setChoice(((LiquidMonitorBlockTileEntity)this.tileEntity).getAlarmMode().getDescription());
        this.alarmLabel = ((ScrollableLabel)new ScrollableLabel(this.field_146297_k, (Gui)this).setSuffix("%").setDesiredWidth(30)).setRealMinimum(0).setRealMaximum(100).setRealValue(((LiquidMonitorBlockTileEntity)this.tileEntity).getAlarmLevel()).addValueEvent(new ValueEvent(){

            public void valueChanged(Widget parent, int newValue) {
                GuiLiquidMonitor.this.changeAlarmValue(newValue);
            }
        });
        Slider alarmSlider = ((Slider)((Slider)new Slider(this.field_146297_k, (Gui)this).setDesiredHeight(15)).setMinimumKnobSize(15).setHorizontal().setTooltips(new String[]{"Alarm level"})).setScrollable((Scrollable)this.alarmLabel);
        Panel alarmPanel = (Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout()).addChild((Widget)this.alarmModeChoiceLabel)).addChild((Widget)alarmSlider)).addChild((Widget)this.alarmLabel)).setDesiredHeight(20);
        AbstractContainerWidget toplevel = ((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setFilledRectThickness(2)).setLayout((Layout)new VerticalLayout()).addChild((Widget)listPanel)).addChild((Widget)alarmPanel);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
        fromServer_clientAdjacentBlocks = new ArrayList<Coordinate>();
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetAdjacentTankBlocks(((LiquidMonitorBlockTileEntity)this.tileEntity).field_145851_c, ((LiquidMonitorBlockTileEntity)this.tileEntity).field_145848_d, ((LiquidMonitorBlockTileEntity)this.tileEntity).field_145849_e));
    }

    private void changeAlarmMode(RFMonitorMode mode) {
        int alarmLevel = this.alarmLabel.getRealValue();
        ((LiquidMonitorBlockTileEntity)this.tileEntity).setAlarm(mode, alarmLevel);
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketContentsMonitor(((LiquidMonitorBlockTileEntity)this.tileEntity).field_145851_c, ((LiquidMonitorBlockTileEntity)this.tileEntity).field_145848_d, ((LiquidMonitorBlockTileEntity)this.tileEntity).field_145849_e, mode, alarmLevel));
    }

    private void changeAlarmValue(int newValue) {
        RFMonitorMode mode = RFMonitorMode.getModeFromDescription(this.alarmModeChoiceLabel.getCurrentChoice());
        ((LiquidMonitorBlockTileEntity)this.tileEntity).setAlarm(mode, newValue);
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketContentsMonitor(((LiquidMonitorBlockTileEntity)this.tileEntity).field_145851_c, ((LiquidMonitorBlockTileEntity)this.tileEntity).field_145848_d, ((LiquidMonitorBlockTileEntity)this.tileEntity).field_145849_e, mode, newValue));
    }

    private void refreshList() {
    }

    private void setSelectedBlock(int index) {
        if (index != -1) {
            Coordinate c = this.adjacentBlocks.get(index);
            ((LiquidMonitorBlockTileEntity)this.tileEntity).setMonitor(c);
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketContentsMonitor(((LiquidMonitorBlockTileEntity)this.tileEntity).field_145851_c, ((LiquidMonitorBlockTileEntity)this.tileEntity).field_145848_d, ((LiquidMonitorBlockTileEntity)this.tileEntity).field_145849_e, c));
        } else {
            ((LiquidMonitorBlockTileEntity)this.tileEntity).setInvalid();
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketContentsMonitor(((LiquidMonitorBlockTileEntity)this.tileEntity).field_145851_c, ((LiquidMonitorBlockTileEntity)this.tileEntity).field_145848_d, ((LiquidMonitorBlockTileEntity)this.tileEntity).field_145849_e, Coordinate.INVALID));
        }
    }

    private void populateList() {
        List<Coordinate> newAdjacentBlocks = fromServer_clientAdjacentBlocks;
        if (newAdjacentBlocks == null) {
            return;
        }
        if (newAdjacentBlocks.equals(this.adjacentBlocks)) {
            this.refreshList();
            return;
        }
        this.adjacentBlocks = new ArrayList<Coordinate>(newAdjacentBlocks);
        this.list.removeChildren();
        int index = 0;
        int sel = -1;
        for (Coordinate coordinate : this.adjacentBlocks) {
            Block block = this.field_146297_k.field_71441_e.func_147439_a(coordinate.getX(), coordinate.getY(), coordinate.getZ());
            int meta = this.field_146297_k.field_71441_e.func_72805_g(coordinate.getX(), coordinate.getY(), coordinate.getZ());
            int color = StyleConfig.colorTextInListNormal;
            String displayName = BlockInfo.getReadableName(block, coordinate, meta, (World)this.field_146297_k.field_71441_e);
            if (coordinate.getX() == ((LiquidMonitorBlockTileEntity)this.tileEntity).getMonitorX() && coordinate.getY() == ((LiquidMonitorBlockTileEntity)this.tileEntity).getMonitorY() && coordinate.getZ() == ((LiquidMonitorBlockTileEntity)this.tileEntity).getMonitorZ()) {
                sel = index;
                color = 0xFFFFFF;
            }
            Panel panel = new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout());
            panel.addChild((Widget)new BlockRender(this.field_146297_k, (Gui)this).setRenderItem((Object)block));
            panel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText(displayName).setColor(color).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setDesiredWidth(90));
            panel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setDynamic(true).setText(coordinate.toString()).setColor(color));
            this.list.addChild((Widget)panel);
            ++index;
        }
        this.list.setSelected(sel);
    }

    protected void func_146976_a(float v, int i, int i2) {
        --this.listDirty;
        if (this.listDirty <= 0) {
            this.populateList();
            this.listDirty = 5;
        }
        this.drawWindow();
    }
}

