/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.blocks.multiblock;

import com.brandon3055.draconicevolution.common.ModBlocks;
import com.brandon3055.draconicevolution.common.blocks.BlockDE;
import com.brandon3055.draconicevolution.common.lib.References;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TileDislocatorReceptacle;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TilePortalBlock;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Portal
extends BlockDE
implements ITileEntityProvider {
    public Portal() {
        super(Material.field_151567_E);
        this.func_149722_s();
        this.func_149663_c("portal");
        ModBlocks.register(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a(References.RESOURCESPREFIX + "transparency");
    }

    public int func_149645_b() {
        return References.idPortal;
    }

    public AxisAlignedBB func_149633_g(World p_149633_1_, int p_149633_2_, int p_149633_3_, int p_149633_4_) {
        return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public TileEntity func_149915_a(World world, int i) {
        return new TilePortalBlock();
    }

    public AxisAlignedBB func_149668_a(World p_149668_1_, int p_149668_2_, int p_149668_3_, int p_149668_4_) {
        return null;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (world.field_72995_K) {
            return;
        }
        if (this.getMaster(world, x, y, z) == null) {
            world.func_147468_f(x, y, z);
            return;
        }
        if (this.getMaster((World)world, (int)x, (int)y, (int)z).isActive) {
            this.getMaster(world, x, y, z).validateActivePortal();
        }
        if (!this.getMaster((World)world, (int)x, (int)y, (int)z).isActive && !this.getMaster((World)world, (int)x, (int)y, (int)z).updating) {
            world.func_147468_f(x, y, z);
            return;
        }
        this.updateMetadata(world, x, y, z);
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (world.field_72995_K) {
            return;
        }
        TileDislocatorReceptacle tile = this.getMaster(world, x, y, z);
        if (tile != null && tile.isActive && tile.getLocation() != null) {
            if (tile.coolDown > 0) {
                return;
            }
            tile.coolDown = 1;
            tile.getLocation().sendEntityToCoords(entity);
        } else if (tile != null) {
            tile.validateActivePortal();
        } else {
            world.func_147468_f(x, y, z);
        }
    }

    private TileDislocatorReceptacle getMaster(World world, int x, int y, int z) {
        return world.func_147438_o(x, y, z) instanceof TilePortalBlock ? ((TilePortalBlock)world.func_147438_o(x, y, z)).getMaster() : null;
    }

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return null;
    }

    private boolean isPortalOrFrame(IBlockAccess access, int x, int y, int z) {
        Block block = access.func_147439_a(x, y, z);
        return block == ModBlocks.portal || block == ModBlocks.infusedObsidian || block == ModBlocks.dislocatorReceptacle;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        this.updateMetadata(world, x, y, z);
    }

    private void updateMetadata(World world, int x, int y, int z) {
        if (world.field_72995_K || world.func_72805_g(x, y, z) != 0) {
            return;
        }
        int meta = 0;
        if (this.isPortalOrFrame((IBlockAccess)world, x, y + 1, z) && this.isPortalOrFrame((IBlockAccess)world, x, y - 1, z) && this.isPortalOrFrame((IBlockAccess)world, x + 1, y, z) && this.isPortalOrFrame((IBlockAccess)world, x - 1, y, z)) {
            meta = 1;
        } else if (this.isPortalOrFrame((IBlockAccess)world, x, y + 1, z) && this.isPortalOrFrame((IBlockAccess)world, x, y - 1, z) && this.isPortalOrFrame((IBlockAccess)world, x, y, z + 1) && this.isPortalOrFrame((IBlockAccess)world, x, y, z - 1)) {
            meta = 2;
        } else if (this.isPortalOrFrame((IBlockAccess)world, x + 1, y, z) && this.isPortalOrFrame((IBlockAccess)world, x - 1, y, z) && this.isPortalOrFrame((IBlockAccess)world, x, y, z + 1) && this.isPortalOrFrame((IBlockAccess)world, x, y, z - 1)) {
            meta = 3;
        }
        world.func_72921_c(x, y, z, meta, 2);
    }
}

