/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import mcjty.lib.entity.SyncedObject;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class SyncedValueList<T>
implements List<T>,
SyncedObject {
    private final List<T> value = new ArrayList<T>();
    private int serverVersion = 0;
    private int clientVersion = -1;

    public int getClientVersion() {
        return this.clientVersion;
    }

    public int getServerVersion() {
        return this.serverVersion;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        this.serverVersion = tagCompound.func_74762_e("version");
        NBTTagList list = tagCompound.func_150295_c("list", 10);
        this.value.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.value.add(this.readElementFromNBT(list.func_150305_b(i)));
        }
    }

    public void readFromNBT(NBTTagCompound tagCompound, String tagName) {
        NBTTagCompound compound = tagCompound.func_74775_l(tagName);
        if (compound != null) {
            this.readFromNBT(compound);
        }
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("version", this.serverVersion);
        NBTTagList list = new NBTTagList();
        for (T element : this.value) {
            list.func_74742_a((NBTBase)this.writeElementToNBT(element));
        }
        tagCompound.func_74782_a("list", (NBTBase)list);
    }

    public void writeToNBT(NBTTagCompound tagCompound, String tagName) {
        NBTTagCompound compound = new NBTTagCompound();
        this.writeToNBT(compound);
        tagCompound.func_74782_a(tagName, (NBTBase)compound);
    }

    public abstract T readElementFromNBT(NBTTagCompound var1);

    public abstract NBTTagCompound writeElementToNBT(T var1);

    @Override
    public void setInvalid() {
        this.value.clear();
        this.serverVersion = 0;
        this.clientVersion = -1;
    }

    @Override
    public boolean isClientValueUptodate() {
        return this.serverVersion == this.clientVersion;
    }

    @Override
    public void updateClientValue() {
        this.clientVersion = this.serverVersion;
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.value.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.value.iterator();
    }

    @Override
    public T[] toArray() {
        return this.value.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.value.toArray(a);
    }

    @Override
    public boolean add(Object o) {
        ++this.serverVersion;
        return this.value.add(o);
    }

    @Override
    public boolean remove(Object o) {
        ++this.serverVersion;
        return this.value.remove(o);
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.value.containsAll(c);
    }

    @Override
    public boolean addAll(Collection c) {
        ++this.serverVersion;
        return this.value.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection c) {
        ++this.serverVersion;
        return this.value.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection c) {
        ++this.serverVersion;
        return this.value.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection c) {
        ++this.serverVersion;
        return this.value.retainAll(c);
    }

    @Override
    public void clear() {
        ++this.serverVersion;
        this.value.clear();
    }

    @Override
    public T get(int index) {
        return this.value.get(index);
    }

    @Override
    public T set(int index, T element) {
        ++this.serverVersion;
        return this.value.set(index, element);
    }

    @Override
    public void add(int index, T element) {
        ++this.serverVersion;
        this.value.add(index, element);
    }

    @Override
    public T remove(int index) {
        ++this.serverVersion;
        return this.value.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.value.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.value.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.value.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.value.listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.value.subList(fromIndex, toIndex);
    }
}

