/*
 * Decompiled with CFR 0.152.
 */
package magicbees.main.utils;

import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.recipes.RecipeManagers;
import java.util.Hashtable;
import java.util.Map;
import magicbees.item.ItemCapsule;
import magicbees.item.types.CombType;
import magicbees.item.types.DropType;
import magicbees.item.types.FluidType;
import magicbees.item.types.NuggetType;
import magicbees.item.types.PollenType;
import magicbees.item.types.PropolisType;
import magicbees.item.types.ResourceType;
import magicbees.item.types.WaxType;
import magicbees.main.Config;
import magicbees.main.utils.ItemInterface;
import magicbees.main.utils.compat.ArsMagicaHelper;
import magicbees.main.utils.compat.ForestryHelper;
import magicbees.main.utils.compat.ThaumcraftHelper;
import magicbees.main.utils.compat.ThermalModsHelper;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class CraftingManager {
    public static void registerLiquidContainers() {
        CraftingManager.registerLiquidContainer(Config.magicCapsule);
        CraftingManager.registerLiquidContainer(Config.voidCapsule);
    }

    public static void setupCrafting() {
        CraftingManager.setupVanillaCrafting();
        CraftingManager.setupCentrifugeRecipes();
        CraftingManager.setupCarpenterRecipes();
    }

    private static void setupVanillaCrafting() {
        ItemStack output = new ItemStack((Item)Config.magicCapsule);
        output.field_77994_a = 4;
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(output, new Object[]{"WWW", Character.valueOf('W'), "waxMagical"}));
        ItemStack input = Config.miscResources.getStackForType(ResourceType.EXTENDED_FERTILIZER);
        output = ItemInterface.getItemStack("Forestry", "fertilizerCompound", 6);
        GameRegistry.addRecipe((ItemStack)output, (Object[])new Object[]{" S ", " F ", " S ", Character.valueOf('F'), input, Character.valueOf('S'), Blocks.field_150354_m});
        GameRegistry.addRecipe((ItemStack)output, (Object[])new Object[]{"   ", "SFS", "   ", Character.valueOf('F'), input, Character.valueOf('S'), Blocks.field_150354_m});
        output = output.func_77946_l();
        output.field_77994_a = 12;
        GameRegistry.addRecipe((ItemStack)output, (Object[])new Object[]{"aaa", "aFa", "aaa", Character.valueOf('F'), input, Character.valueOf('a'), ItemInterface.getItemStack("ash")});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.field_151062_by), (Object[])new Object[]{"DDD", "DBD", "DDD", Character.valueOf('D'), Config.drops.getStackForType(DropType.INTELLECT), Character.valueOf('B'), Items.field_151069_bo});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Blocks.field_150425_aM, 4), (Object[])new Object[]{"SwS", "wDw", "SwS", Character.valueOf('S'), Blocks.field_150354_m, Character.valueOf('D'), Blocks.field_150346_d, Character.valueOf('w'), Config.wax.getStackForType(WaxType.SOUL)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Blocks.field_150425_aM, 4), (Object[])new Object[]{"wSw", "SDS", "wSw", Character.valueOf('S'), Blocks.field_150354_m, Character.valueOf('D'), Blocks.field_150346_d, Character.valueOf('w'), Config.wax.getStackForType(WaxType.SOUL)});
        output = new ItemStack((Item)Config.hiveFrameMagic);
        input = ItemInterface.getItemStack("frameUntreated");
        GameRegistry.addRecipe((ItemStack)output, (Object[])new Object[]{"www", "wfw", "www", Character.valueOf('w'), Config.wax.getStackForType(WaxType.MAGIC), Character.valueOf('f'), input});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)Config.hiveFrameTemporal), (Object[])new Object[]{"sPs", "PfP", "sPs", Character.valueOf('s'), Blocks.field_150354_m, Character.valueOf('P'), Config.pollen.getStackForType(PollenType.PHASED), Character.valueOf('f'), Config.hiveFrameMagic});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)Config.effectJar), new Object[]{"GSG", "QPQ", "GGG", Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('S'), "slabWood", Character.valueOf('P'), Config.pollen.getStackForType(PollenType.UNUSUAL), Character.valueOf('Q'), Items.field_151128_bU}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)Config.moonDial), new Object[]{"DqD", "qrq", "DqD", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('q'), Items.field_151128_bU, Character.valueOf('D'), "dyeGreen"}));
        GameRegistry.addRecipe((ItemStack)Config.miscResources.getStackForType(ResourceType.SKULL_FRAGMENT), (Object[])new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), Config.miscResources.getStackForType(ResourceType.SKULL_CHIP)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.field_151144_bL, 1, 1), (Object[])new Object[]{"xxx", "xxx", Character.valueOf('x'), Config.miscResources.getStackForType(ResourceType.SKULL_FRAGMENT)});
        GameRegistry.addRecipe((ItemStack)Config.miscResources.getStackForType(ResourceType.DRAGON_CHUNK), (Object[])new Object[]{"xxx", "xxx", Character.valueOf('x'), Config.miscResources.getStackForType(ResourceType.DRAGON_DUST)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Blocks.field_150380_bt, 1), (Object[])new Object[]{"ccc", "cec", "ccc", Character.valueOf('c'), Config.miscResources.getStackForType(ResourceType.DRAGON_CHUNK), Character.valueOf('e'), Config.miscResources.getStackForType(ResourceType.ESSENCE_FALSE_LIFE)});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(Config.miscResources.getStackForType(ResourceType.ESSENCE_EVERLASTING_DURABILITY), new Object[]{"gwg", "wiw", "gwg", Character.valueOf('g'), Blocks.field_150359_w, Character.valueOf('w'), "waxMagical", Character.valueOf('i'), Blocks.field_150339_S}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(Config.miscResources.getStackForType(ResourceType.ESSENCE_EVERLASTING_DURABILITY), new Object[]{"wgw", "gig", "wgw", Character.valueOf('g'), Blocks.field_150359_w, Character.valueOf('w'), "waxMagical", Character.valueOf('i'), Blocks.field_150339_S}));
        GameRegistry.addRecipe((ItemStack)Config.miscResources.getStackForType(ResourceType.ESSENCE_FALSE_LIFE), (Object[])new Object[]{"gwg", "wfw", "gwg", Character.valueOf('g'), Blocks.field_150359_w, Character.valueOf('w'), Config.wax.getStackForType(WaxType.SOUL), Character.valueOf('f'), Blocks.field_150328_O});
        GameRegistry.addRecipe((ItemStack)Config.miscResources.getStackForType(ResourceType.ESSENCE_FALSE_LIFE), (Object[])new Object[]{"wgw", "gfg", "wgw", Character.valueOf('g'), Blocks.field_150359_w, Character.valueOf('w'), Config.wax.getStackForType(WaxType.SOUL), Character.valueOf('f'), Blocks.field_150328_O});
        GameRegistry.addRecipe((ItemStack)Config.miscResources.getStackForType(ResourceType.ESSENCE_SHALLOW_GRAVE), (Object[])new Object[]{"gwg", "wfw", "gwg", Character.valueOf('g'), Blocks.field_150359_w, Character.valueOf('w'), Config.wax.getStackForType(WaxType.SOUL), Character.valueOf('f'), Items.field_151078_bh});
        GameRegistry.addRecipe((ItemStack)Config.miscResources.getStackForType(ResourceType.ESSENCE_SHALLOW_GRAVE), (Object[])new Object[]{"wgw", "gfg", "wgw", Character.valueOf('g'), Blocks.field_150359_w, Character.valueOf('w'), Config.wax.getStackForType(WaxType.SOUL), Character.valueOf('f'), Items.field_151078_bh});
        GameRegistry.addRecipe((ItemStack)Config.miscResources.getStackForType(ResourceType.ESSENCE_LOST_TIME), (Object[])new Object[]{"wgw", "gcg", "wgw", Character.valueOf('g'), Blocks.field_150359_w, Character.valueOf('w'), Config.wax.getStackForType(WaxType.SOUL), Character.valueOf('c'), Items.field_151113_aN});
        GameRegistry.addRecipe((ItemStack)Config.miscResources.getStackForType(ResourceType.ESSENCE_LOST_TIME), (Object[])new Object[]{"gwg", "wcw", "gwg", Character.valueOf('g'), Blocks.field_150359_w, Character.valueOf('w'), Config.wax.getStackForType(WaxType.SOUL), Character.valueOf('c'), Items.field_151113_aN});
        GameRegistry.addRecipe((ItemStack)Config.miscResources.getStackForType(ResourceType.ESSENCE_FICKLE_PERMANENCE), (Object[])new Object[]{"wew", "gcg", "wew", Character.valueOf('w'), Config.wax.getStackForType(WaxType.SOUL), Character.valueOf('c'), Items.field_151064_bs, Character.valueOf('e'), Items.field_151110_aK, Character.valueOf('g'), Blocks.field_150426_aN});
        GameRegistry.addRecipe((ItemStack)Config.miscResources.getStackForType(ResourceType.ESSENCE_FICKLE_PERMANENCE), (Object[])new Object[]{"wgw", "ece", "wgw", Character.valueOf('w'), Config.wax.getStackForType(WaxType.SOUL), Character.valueOf('c'), Items.field_151064_bs, Character.valueOf('e'), Items.field_151110_aK, Character.valueOf('g'), Blocks.field_150426_aN});
        GameRegistry.addRecipe((ItemStack)Config.miscResources.getStackForType(ResourceType.ESSENCE_SCORNFUL_OBLIVION), (Object[])new Object[]{"gst", "sEs", "tsg", Character.valueOf('g'), Config.miscResources.getStackForType(ResourceType.ESSENCE_SHALLOW_GRAVE), Character.valueOf('t'), Config.miscResources.getStackForType(ResourceType.ESSENCE_LOST_TIME), Character.valueOf('s'), new ItemStack(Items.field_151144_bL, 1, 1), Character.valueOf('E'), Blocks.field_150380_bt});
        input = new ItemStack((Item)Config.hiveFrameMagic);
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)Config.hiveFrameResilient), (Object[])new Object[]{Config.miscResources.getStackForType(ResourceType.ESSENCE_EVERLASTING_DURABILITY), input});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)Config.hiveFrameGentle), (Object[])new Object[]{Config.miscResources.getStackForType(ResourceType.ESSENCE_FALSE_LIFE), input});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)Config.hiveFrameNecrotic), (Object[])new Object[]{Config.miscResources.getStackForType(ResourceType.ESSENCE_SHALLOW_GRAVE), input});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)Config.hiveFrameMetabolic), (Object[])new Object[]{Config.miscResources.getStackForType(ResourceType.ESSENCE_FICKLE_PERMANENCE), input});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)Config.hiveFrameTemporal), (Object[])new Object[]{Config.miscResources.getStackForType(ResourceType.ESSENCE_LOST_TIME), input});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)Config.hiveFrameOblivion), (Object[])new Object[]{Config.miscResources.getStackForType(ResourceType.ESSENCE_SCORNFUL_OBLIVION), ItemInterface.getItemStack("frameProven")});
        output = new ItemStack((Block)Config.magicApiary);
        GameRegistry.addShapelessRecipe((ItemStack)output, (Object[])new Object[]{Config.pollen.getStackForType(PollenType.UNUSUAL, 2), Config.drops.getStackForType(DropType.ENCHANTED, 2), new ItemStack(ForestryHelper.apicultureBlock, 1, ForestryHelper.ApicultureBlock.APIARY.ordinal())});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)Config.enchantedEarth), (Object[])new Object[]{"d d", " e ", "d d", Character.valueOf('d'), new ItemStack(Blocks.field_150346_d, 1, Short.MAX_VALUE), Character.valueOf('e'), Config.miscResources.getStackForType(ResourceType.ESSENCE_FALSE_LIFE)});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)Config.enchantedEarth), (Object[])new Object[]{" d ", "ded", " d ", Character.valueOf('d'), new ItemStack(Blocks.field_150346_d, 1, Short.MAX_VALUE), Character.valueOf('e'), Config.miscResources.getStackForType(ResourceType.ESSENCE_FALSE_LIFE)});
        if (OreDictionary.getOres((String)"ingotCopper").size() <= 0) {
            NuggetType.COPPER.setInactive();
        } else {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((ItemStack)OreDictionary.getOres((String)"ingotCopper").get(0), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), "nuggetCopper"}));
        }
        if (OreDictionary.getOres((String)"ingotTin").size() <= 0) {
            NuggetType.TIN.setInactive();
        } else {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((ItemStack)OreDictionary.getOres((String)"ingotTin").get(0), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), "nuggetTin"}));
        }
        if (OreDictionary.getOres((String)"ingotSilver").size() <= 0) {
            NuggetType.SILVER.setInactive();
        } else {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((ItemStack)OreDictionary.getOres((String)"ingotSilver").get(0), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), "nuggetSilver"}));
        }
        if (OreDictionary.getOres((String)"ingotLead").size() <= 0) {
            NuggetType.LEAD.setInactive();
        } else {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((ItemStack)OreDictionary.getOres((String)"ingotLead").get(0), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), "nuggetLead"}));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.field_151042_j), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), "nuggetIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.field_151045_i), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), "shardDiamond"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.field_151166_bC), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), "shardEmerald"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ItemInterface.getItemStack("apatite"), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), Config.nuggets.getStackForType(NuggetType.APATITE)}));
        output = Config.miscResources.getStackForType(ResourceType.DIMENSIONAL_SINGULARITY);
        GameRegistry.addRecipe((ItemStack)output, (Object[])new Object[]{" G ", "QEQ", " W ", Character.valueOf('E'), Items.field_151061_bv, Character.valueOf('Q'), Blocks.field_150371_ca, Character.valueOf('W'), Blocks.field_150377_bs, Character.valueOf('G'), Blocks.field_150340_R});
        output = Config.voidCapsule.getCapsuleForLiquid(FluidType.EMPTY);
        output.field_77994_a = 4;
        GameRegistry.addRecipe((ItemStack)output, (Object[])new Object[]{"T T", "GFG", "T T", Character.valueOf('G'), Blocks.field_150410_aZ, Character.valueOf('F'), Config.miscResources.getStackForType(ResourceType.DIMENSIONAL_SINGULARITY), Character.valueOf('T'), Items.field_151074_bl});
        output = new ItemStack((Item)Config.magnet);
        GameRegistry.addRecipe((ItemStack)output, (Object[])new Object[]{" i ", "cSc", " d ", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('c'), Items.field_151111_aL, Character.valueOf('d'), Items.field_151045_i, Character.valueOf('S'), Config.miscResources.getStackForType(ResourceType.DIMENSIONAL_SINGULARITY)});
        for (int level = 1; level <= 8; ++level) {
            output = new ItemStack((Item)Config.magnet, 1, level * 2);
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(output, new Object[]{" d ", "mSm", " B ", Character.valueOf('d'), Items.field_151045_i, Character.valueOf('m'), "mb.magnet.level" + (level - 1), Character.valueOf('B'), Blocks.field_150451_bX, Character.valueOf('S'), Config.miscResources.getStackForType(ResourceType.DIMENSIONAL_SINGULARITY)}));
        }
        if (ThaumcraftHelper.isActive()) {
            input = Config.miscResources.getStackForType(ResourceType.LORE_FRAGMENT);
            output = new ItemStack(ThaumcraftHelper.miscResource, 1, ThaumcraftHelper.MiscResource.KNOWLEDGE_FRAGMENT.ordinal());
            GameRegistry.addShapelessRecipe((ItemStack)output, (Object[])new Object[]{input, input, input, input});
            if (Config.thaumaturgeBackpackActive) {
                GameRegistry.addRecipe((ItemStack)new ItemStack(Config.thaumaturgeBackpackT1), (Object[])new Object[]{"SWS", "NCN", "SWS", Character.valueOf('S'), Items.field_151007_F, Character.valueOf('W'), Blocks.field_150325_L, Character.valueOf('N'), new ItemStack(ThaumcraftHelper.miscResource, 1, ThaumcraftHelper.MiscResource.AMBER.ordinal()), Character.valueOf('C'), Blocks.field_150486_ae});
            }
        }
        if (ArsMagicaHelper.isActive()) {
            input = ItemInterface.getItemStack("apatite");
            output = Config.miscResources.getStackForType(ResourceType.EXTENDED_FERTILIZER, 4);
            GameRegistry.addShapelessRecipe((ItemStack)output, (Object[])new Object[]{new ItemStack(ArsMagicaHelper.essence, 1, ArsMagicaHelper.EssenceType.EARTH.ordinal()), input, input});
            GameRegistry.addShapelessRecipe((ItemStack)output, (Object[])new Object[]{new ItemStack(ArsMagicaHelper.essence, 1, ArsMagicaHelper.EssenceType.PLANT.ordinal()), input, input});
        }
    }

    private static Map<ItemStack, Float> newMap() {
        return new Hashtable<ItemStack, Float>();
    }

    private static void setupCentrifugeRecipes() {
        ItemStack beeswax = ItemInterface.getItemStack("beeswax");
        ItemStack propolis = ItemInterface.getItemStack("propolis");
        propolis.func_77964_b(ForestryHelper.Propolis.PULSATING.ordinal());
        Map<ItemStack, Float> output = CraftingManager.newMap();
        output.put(beeswax, Float.valueOf(0.9f));
        output.put(ItemInterface.getItemStack("honeyDrop"), Float.valueOf(0.6f));
        output.put(Config.wax.getStackForType(WaxType.MAGIC), Float.valueOf(0.1f));
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.MUNDANE), output);
        output = CraftingManager.newMap();
        output.put(ItemInterface.getItemStack("refractoryWax"), Float.valueOf(0.86f));
        output.put(ItemInterface.getItemStack("honeyDrop"), Float.valueOf(0.087f));
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.MOLTEN), output);
        output = CraftingManager.newMap();
        output.put(Config.wax.getStackForType(WaxType.AMNESIC), Float.valueOf(0.5f));
        output.put(propolis, Float.valueOf(0.5f));
        output.put(ItemInterface.getItemStack("honeyDrop"), Float.valueOf(0.4f));
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.FORGOTTEN), output);
        output = CraftingManager.newMap();
        output.put(Config.wax.getStackForType(WaxType.MAGIC), Float.valueOf(1.0f));
        output.put(ItemInterface.getItemStack("honeyDrop"), Float.valueOf(0.6f));
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.OCCULT), output);
        output = CraftingManager.newMap();
        output.put(beeswax, Float.valueOf(0.5f));
        output.put(Config.wax.getStackForType(WaxType.MAGIC), Float.valueOf(0.22f));
        output.put(ItemInterface.getItemStack("honeyDrop"), Float.valueOf(1.0f));
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.OTHERWORLDLY), output);
        output = CraftingManager.newMap();
        output.put(ItemInterface.getItemStack("beeswax"), Float.valueOf(0.8f));
        output.put(Config.wax.getStackForType(WaxType.MAGIC), Float.valueOf(0.2f));
        output.put(new ItemStack(Items.field_151121_aF), Float.valueOf(0.057f));
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.PAPERY), output);
        output = CraftingManager.newMap();
        output.put(Config.wax.getStackForType(WaxType.MAGIC), Float.valueOf(0.9f));
        output.put(ItemInterface.getItemStack("honeydew"), Float.valueOf(0.4f));
        output.put(Config.drops.getStackForType(DropType.INTELLECT), Float.valueOf(0.1f));
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.INTELLECT), output);
        propolis.func_77964_b(ForestryHelper.Propolis.NORMAL.ordinal());
        output = CraftingManager.newMap();
        output.put(ItemInterface.getItemStack("beeswax"), Float.valueOf(0.9f));
        output.put(propolis, Float.valueOf(0.2f));
        output.put(ItemInterface.getItemStack("honeydew"), Float.valueOf(0.35f));
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.FURTIVE), output);
        output = CraftingManager.newMap();
        output.put(Config.wax.getStackForType(WaxType.SOUL), Float.valueOf(0.95f));
        output.put(ItemInterface.getItemStack("honeydew"), Float.valueOf(0.26f));
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.SOUL), output);
        output = CraftingManager.newMap();
        output.put(Config.wax.getStackForType(WaxType.MAGIC), Float.valueOf(1.0f));
        output.put(Config.pollen.getStackForType(PollenType.PHASED), Float.valueOf(0.055f));
        output.put(new ItemStack(ForestryHelper.honeydew, 1), Float.valueOf(0.6f));
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.TEMPORAL), output);
        output = CraftingManager.newMap();
        output.put(ItemInterface.getItemStack("beeswax"), Float.valueOf(0.8f));
        output.put(Config.wax.getStackForType(WaxType.MAGIC), Float.valueOf(0.8f));
        output.put(Config.propolis.getStackForType(PropolisType.UNSTABLE), Float.valueOf(0.15f));
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.TRANSMUTED), output);
        output = CraftingManager.newMap();
        output.put(Config.wax.getStackForType(WaxType.MAGIC), Float.valueOf(1.0f));
        output.put(new ItemStack(Items.field_151008_G), Float.valueOf(0.6f));
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.AIRY), output);
        output = CraftingManager.newMap();
        output.put(Config.wax.getStackForType(WaxType.MAGIC), Float.valueOf(1.0f));
        output.put(new ItemStack(Items.field_151065_br), Float.valueOf(0.6f));
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.FIREY), output);
        output = CraftingManager.newMap();
        output.put(Config.wax.getStackForType(WaxType.MAGIC), Float.valueOf(1.0f));
        output.put(new ItemStack(Items.field_151100_aR), Float.valueOf(0.6f));
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.WATERY), output);
        output = CraftingManager.newMap();
        output.put(Config.wax.getStackForType(WaxType.MAGIC), Float.valueOf(1.0f));
        output.put(new ItemStack(Items.field_151119_aD), Float.valueOf(0.6f));
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.EARTHY), output);
        if (ThaumcraftHelper.isActive()) {
            output = CraftingManager.newMap();
            output.put(Config.wax.getStackForType(WaxType.MAGIC), Float.valueOf(1.0f));
            output.put(new ItemStack(Items.field_151008_G), Float.valueOf(0.6f));
            output.put(Config.propolis.getStackForType(PropolisType.AIR), Float.valueOf(0.8f));
            RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.TC_AIR), output);
            output = CraftingManager.newMap();
            output.put(Config.wax.getStackForType(WaxType.MAGIC), Float.valueOf(1.0f));
            output.put(new ItemStack(Items.field_151065_br), Float.valueOf(0.6f));
            output.put(Config.propolis.getStackForType(PropolisType.FIRE), Float.valueOf(0.8f));
            RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.TC_FIRE), output);
            output = CraftingManager.newMap();
            output.put(Config.wax.getStackForType(WaxType.MAGIC), Float.valueOf(1.0f));
            output.put(new ItemStack(Items.field_151100_aR), Float.valueOf(0.6f));
            output.put(Config.propolis.getStackForType(PropolisType.WATER), Float.valueOf(0.8f));
            RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.TC_WATER), output);
            output = CraftingManager.newMap();
            output.put(Config.wax.getStackForType(WaxType.MAGIC), Float.valueOf(1.0f));
            output.put(new ItemStack(Items.field_151119_aD), Float.valueOf(0.6f));
            output.put(Config.propolis.getStackForType(PropolisType.EARTH), Float.valueOf(0.8f));
            RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.TC_EARTH), output);
            output = CraftingManager.newMap();
            output.put(Config.wax.getStackForType(WaxType.MAGIC), Float.valueOf(1.0f));
            output.put(new ItemStack(Items.field_151137_ax), Float.valueOf(0.6f));
            output.put(Config.propolis.getStackForType(PropolisType.ORDER), Float.valueOf(0.8f));
            RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.TC_ORDER), output);
            output = CraftingManager.newMap();
            output.put(Config.wax.getStackForType(WaxType.MAGIC), Float.valueOf(1.0f));
            output.put(new ItemStack(Items.field_151016_H), Float.valueOf(0.6f));
            output.put(Config.propolis.getStackForType(PropolisType.CHAOS), Float.valueOf(0.8f));
            RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.TC_CHAOS), output);
            output = CraftingManager.newMap();
            output.put(propolis, Float.valueOf(1.0f));
            output.put(Config.miscResources.getStackForType(ResourceType.TC_DUST_AIR), Float.valueOf(0.9f));
            RecipeManagers.centrifugeManager.addRecipe(8, Config.propolis.getStackForType(PropolisType.AIR), output);
            output = CraftingManager.newMap();
            output.put(propolis, Float.valueOf(1.0f));
            output.put(Config.miscResources.getStackForType(ResourceType.TC_DUST_FIRE), Float.valueOf(0.9f));
            RecipeManagers.centrifugeManager.addRecipe(8, Config.propolis.getStackForType(PropolisType.FIRE), output);
            output = CraftingManager.newMap();
            output.put(propolis, Float.valueOf(1.0f));
            output.put(Config.miscResources.getStackForType(ResourceType.TC_DUST_WATER), Float.valueOf(0.9f));
            RecipeManagers.centrifugeManager.addRecipe(8, Config.propolis.getStackForType(PropolisType.WATER), output);
            output = CraftingManager.newMap();
            output.put(propolis, Float.valueOf(1.0f));
            output.put(Config.miscResources.getStackForType(ResourceType.TC_DUST_EARTH), Float.valueOf(0.9f));
            RecipeManagers.centrifugeManager.addRecipe(8, Config.propolis.getStackForType(PropolisType.EARTH), output);
            output = CraftingManager.newMap();
            output.put(propolis, Float.valueOf(1.0f));
            output.put(Config.miscResources.getStackForType(ResourceType.TC_DUST_ORDER), Float.valueOf(0.9f));
            RecipeManagers.centrifugeManager.addRecipe(8, Config.propolis.getStackForType(PropolisType.ORDER), output);
            output = CraftingManager.newMap();
            output.put(propolis, Float.valueOf(1.0f));
            output.put(Config.miscResources.getStackForType(ResourceType.TC_DUST_CHAOS), Float.valueOf(0.9f));
            RecipeManagers.centrifugeManager.addRecipe(8, Config.propolis.getStackForType(PropolisType.CHAOS), output);
        }
        if (ArsMagicaHelper.isActive()) {
            output = CraftingManager.newMap();
            output.put(Config.wax.getStackForType(WaxType.MAGIC), Float.valueOf(0.85f));
            output.put(new ItemStack(ArsMagicaHelper.itemResource), Float.valueOf(0.1f));
            output.put(new ItemStack(ArsMagicaHelper.itemResource), Float.valueOf(0.024f));
            RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.AM_ESSENCE), output);
            output = CraftingManager.newMap();
            output.put(ItemInterface.getItemStack("beeswax"), Float.valueOf(0.5f));
            output.put(ItemInterface.getItemStack("refractoryWax"), Float.valueOf(0.5f));
            output.put(ItemInterface.getItemStack("honeydew"), Float.valueOf(0.65f));
            RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.AM_POTENT), output);
        }
        if (ThermalModsHelper.isActive()) {
            output = CraftingManager.newMap();
            output.put(Config.wax.getStackForType(WaxType.MAGIC), Float.valueOf(0.55f));
            output.put(Config.drops.getStackForType(DropType.DESTABILIZED), Float.valueOf(0.22f));
            RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.TE_DESTABILIZED), output);
            output = CraftingManager.newMap();
            output.put(Config.wax.getStackForType(WaxType.MAGIC), Float.valueOf(0.55f));
            output.put(Config.drops.getStackForType(DropType.CARBON), Float.valueOf(0.22f));
            RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.TE_CARBON), output);
            output = CraftingManager.newMap();
            output.put(Config.wax.getStackForType(WaxType.MAGIC), Float.valueOf(0.55f));
            output.put(Config.drops.getStackForType(DropType.LUX), Float.valueOf(0.22f));
            RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.TE_LUX), output);
            output = CraftingManager.newMap();
            output.put(Config.wax.getStackForType(WaxType.MAGIC), Float.valueOf(0.55f));
            output.put(Config.drops.getStackForType(DropType.ENDEARING), Float.valueOf(0.22f));
            RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.TE_ENDEARING), output);
        }
    }

    private static void setupCarpenterRecipes() {
        ItemStack output = ItemInterface.getItemStack("Forestry", "candle", 24);
        RecipeManagers.carpenterManager.addRecipe(30, new FluidStack(FluidRegistry.WATER, 600), null, output, new Object[]{" S ", "WWW", "WWW", Character.valueOf('W'), Config.wax, Character.valueOf('S'), Items.field_151007_F});
        output = ItemInterface.getItemStack("Forestry", "candle", 6);
        ItemStack input = ItemInterface.getItemStack("craftingMaterial");
        input.func_77964_b(ForestryHelper.CraftingMaterial.SILK_WISP.ordinal());
        RecipeManagers.carpenterManager.addRecipe(30, new FluidStack(FluidRegistry.WATER, 600), null, output, new Object[]{"WSW", Character.valueOf('W'), Config.wax, Character.valueOf('S'), input});
        output = Config.miscResources.getStackForType(ResourceType.AROMATIC_LUMP, 2);
        RecipeManagers.carpenterManager.addRecipe(30, FluidRegistry.getFluidStack((String)"for.honey", (int)1000), null, output, new Object[]{" P ", "JDJ", " P ", Character.valueOf('P'), ItemInterface.getItemStack("pollen"), Character.valueOf('J'), ItemInterface.getItemStack("royalJelly"), Character.valueOf('D'), Config.drops.getStackForType(DropType.ENCHANTED)});
        RecipeManagers.carpenterManager.addRecipe(30, FluidRegistry.getFluidStack((String)"for.honey", (int)1000), null, output, new Object[]{" J ", "PDP", " J ", Character.valueOf('P'), ItemInterface.getItemStack("pollen"), Character.valueOf('J'), ItemInterface.getItemStack("royalJelly"), Character.valueOf('D'), Config.drops.getStackForType(DropType.ENCHANTED)});
        if (ThaumcraftHelper.isActive()) {
            input = ItemInterface.getItemStack("craftingMaterial");
            input.func_77964_b(3);
            output = new ItemStack(Config.thaumaturgeBackpackT2);
            RecipeManagers.carpenterManager.addRecipe(200, new FluidStack(FluidRegistry.WATER, 1000), null, output, new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), Items.field_151045_i, Character.valueOf('W'), input, Character.valueOf('T'), new ItemStack(Config.thaumaturgeBackpackT1)});
        }
    }

    private static void registerLiquidContainer(ItemCapsule baseCapsule) {
        ItemStack empty = new ItemStack((Item)baseCapsule, 1, 0);
        FluidStack liquid = null;
        for (FluidType fluidType : FluidType.values()) {
            switch (fluidType) {
                case EMPTY: {
                    liquid = null;
                    break;
                }
                case WATER: {
                    liquid = new FluidStack(FluidRegistry.WATER, baseCapsule.getType().capacity);
                    break;
                }
                case LAVA: {
                    liquid = new FluidStack(FluidRegistry.LAVA, baseCapsule.getType().capacity);
                    break;
                }
                default: {
                    liquid = FluidRegistry.getFluidStack((String)fluidType.liquidID, (int)baseCapsule.getType().capacity);
                }
            }
            if (liquid == null) continue;
            ItemStack filled = new ItemStack((Item)baseCapsule, 1, fluidType.ordinal());
            FluidContainerRegistry.registerFluidContainer((FluidStack)liquid, (ItemStack)filled, (ItemStack)empty);
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{filled}, liquid, Config.wax.getStackForType(WaxType.MAGIC), 20);
            fluidType.available = true;
        }
        FluidType.EMPTY.available = true;
    }
}

