/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees.allele.effect;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.genetics.IEffectData;
import java.util.List;
import magicbees.bees.AlleleEffect;
import magicbees.bees.BeeManager;
import magicbees.bees.allele.effect.EffectData;
import magicbees.main.utils.BlockUtil;
import magicbees.main.utils.compat.thaumcraft.NodeHelper;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class AlleleEffectEmpowering
extends AlleleEffect {
    public AlleleEffectEmpowering(String id, boolean isDominant) {
        super(id, isDominant, 200);
        this.combinable = true;
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (storedData == null || !(storedData instanceof EffectData)) {
            storedData = new EffectData(1, 0, 0);
        }
        return storedData;
    }

    @Override
    protected IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorld();
        ChunkCoordinates coords = housing.getCoordinates();
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        int range = Math.max((int)Math.ceil((float)genome.getTerritory()[0] * beeModifier.getTerritoryModifier(genome, 1.0f)), 1);
        List<Chunk> chunks = BlockUtil.getChunksInSearchRange(world, coords.field_71574_a, coords.field_71573_c, range);
        if (NodeHelper.growNodeInRange(chunks, world, coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, range)) {
            storedData.setInteger(0, storedData.getInteger(0) - this.throttle);
        }
        return storedData;
    }
}

