/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.interfaces.oc.asm.peripheral;

import li.cil.oc.api.Network;
import li.cil.oc.api.driver.NamedBlock;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.ManagedEnvironment;
import openmods.utils.CachedFactory;
import openperipheral.adapter.IMethodCall;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.adapter.PeripheralTypeProvider;
import openperipheral.api.architecture.IArchitectureAccess;
import openperipheral.api.architecture.IAttachable;
import openperipheral.api.architecture.oc.IOpenComputersAttachable;
import openperipheral.interfaces.oc.ModuleOpenComputers;
import openperipheral.interfaces.oc.asm.ICallerBase;

public class PeripheralEnvironmentBase
extends ManagedEnvironment
implements NamedBlock,
ICallerBase {
    private final String type;
    private final CachedFactory<Context, IArchitectureAccess> accessCache = new CachedFactory<Context, IArchitectureAccess>(){

        protected IArchitectureAccess create(Context context) {
            return ModuleOpenComputers.ENV.createAccess(PeripheralEnvironmentBase.this.node(), context);
        }
    };

    public PeripheralEnvironmentBase(Object target) {
        this.type = PeripheralTypeProvider.INSTANCE.generateType(target);
        this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.type).create());
    }

    @Override
    public Object[] call(Object target, IMethodExecutor executor, Context context, Arguments arguments) throws Exception {
        Object[] args = arguments.toArray();
        return this.prepareCall(target, executor, context).call(args);
    }

    protected IMethodCall prepareCall(Object target, IMethodExecutor executor, Context context) {
        IMethodCall call = executor.startCall(target);
        return ModuleOpenComputers.ENV.addPeripheralArgs(call, this.node(), context);
    }

    protected void onConnect(IAttachable target, Node node) {
        Environment host = node.host();
        if (host instanceof Context) {
            IArchitectureAccess access = (IArchitectureAccess)this.accessCache.getOrCreate((Object)((Context)host));
            target.addComputer(access);
        }
    }

    protected void onDisconnect(IAttachable target, Node node) {
        IArchitectureAccess access;
        Environment host = node.host();
        if (host instanceof Context && (access = (IArchitectureAccess)this.accessCache.remove((Object)((Context)host))) != null) {
            target.removeComputer(access);
        }
    }

    protected static void onConnect(IOpenComputersAttachable target, Node node) {
        target.onConnect(node);
    }

    protected static void onDisconnect(IOpenComputersAttachable target, Node node) {
        target.onDisconnect(node);
    }

    public String preferredName() {
        return this.type;
    }

    public int priority() {
        return -1;
    }

    @Override
    public Object[] invalidState() {
        throw new IllegalStateException("Peripheral is no longer valid");
    }
}

