/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.interfaces.oc;

import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Node;
import openperipheral.adapter.IMethodCall;
import openperipheral.api.architecture.IArchitecture;
import openperipheral.api.architecture.IArchitectureAccess;
import openperipheral.api.converter.IConverter;
import openperipheral.api.helpers.Index;
import openperipheral.interfaces.oc.ModuleOpenComputers;

public class OpenComputersEnv {
    private final IConverter converter;

    public OpenComputersEnv(IConverter converter) {
        this.converter = converter;
    }

    public IArchitectureAccess createAccess(Node ownNode, Context context) {
        return new OCArchitectureAccess(ownNode, context, this.converter);
    }

    private IMethodCall addCommonArgs(IMethodCall call, Context context) {
        return call.setEnv("converter", this.converter).setEnv("context", context);
    }

    public IMethodCall addObjectArgs(IMethodCall call, Context context) {
        return this.addCommonArgs(call, context).setEnv("architecture", new OCArchitecture(this.converter));
    }

    public IMethodCall addPeripheralArgs(IMethodCall call, Node node, Context context) {
        OCArchitectureAccess wrapper = new OCArchitectureAccess(node, context, this.converter);
        return this.addCommonArgs(call, context).setEnv("architecture", wrapper).setEnv("access", wrapper).setEnv("node", node);
    }

    private static class OCArchitectureAccess
    extends OCArchitecture
    implements IArchitectureAccess {
        private final Node ownNode;
        private final Context context;

        private OCArchitectureAccess(Node ownNode, Context context, IConverter converter) {
            super(converter);
            this.ownNode = ownNode;
            this.context = context;
        }

        @Override
        public String callerName() {
            return this.context.node().address();
        }

        @Override
        public String peripheralName() {
            return this.ownNode.address();
        }

        @Override
        public boolean canSignal() {
            return this.context.isRunning() || this.context.isPaused();
        }

        @Override
        public boolean signal(String name, Object ... args) {
            return this.context.signal(name, args);
        }
    }

    private static class OCArchitecture
    implements IArchitecture {
        private final IConverter converter;

        public OCArchitecture(IConverter converter) {
            this.converter = converter;
        }

        @Override
        public String architecture() {
            return "OpenComputers";
        }

        @Override
        public Object wrapObject(Object target) {
            return ModuleOpenComputers.wrapObject(target);
        }

        @Override
        public Index createIndex(int value) {
            return Index.fromJava(value, 1);
        }

        @Override
        public IConverter getConverter() {
            return this.converter;
        }
    }
}

