/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.property;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashSet;
import openmods.reflection.TypeUtils;
import openperipheral.adapter.property.IndexedTypeInfo;
import openperipheral.adapter.types.SingleArgType;
import openperipheral.adapter.types.SingleType;
import openperipheral.adapter.types.classifier.TypeClassifier;
import openperipheral.api.adapter.IScriptType;
import openperipheral.api.helpers.Index;
import openperipheral.api.property.IIndexedCustomProperty;
import openperipheral.api.property.IIndexedTypedCustomProperty;
import openperipheral.api.property.PropertyKeyDocType;
import openperipheral.api.property.PropertyValueDocType;
import openperipheral.converter.StructHandlerProvider;

public class IndexedTypeInfoBuilder {
    private static final TypeToken<?> CUSTOM_PROPERTY_TYPE = TypeToken.of(IIndexedCustomProperty.class);
    private static final TypeVariable<?> CUSTOM_PROPERTY_KEY_TYPE;
    private static final TypeVariable<?> CUSTOM_PROPERTY_VALUE_TYPE;
    private static final TypeToken<?> CUSTOM_TYPED_PROPERTY_TYPE;
    private static final TypeVariable<?> CUSTOM_TYPED_PROPERTY_KEY_TYPE;
    private static final TypeVariable<?> CUSTOM_TYPED_PROPERTY_VALUE_TYPE;
    private final TypeToken<?> fieldType;
    private static final ITypeProvider DELEGATING_TYPE_PROVIDER;
    private ITypesProvider typesProvider;
    private Type overridenKeyType;
    private IScriptType overridenKeyDocType;
    private Type overridenValueType;
    private IScriptType overridenValueDocType;

    public IndexedTypeInfoBuilder(Type fieldType) {
        this.fieldType = TypeToken.of((Type)fieldType);
    }

    private static IScriptType classifyType(Type type) {
        return TypeClassifier.INSTANCE.classifyType(type);
    }

    private static Type getTypeVariable(TypeToken<?> type, TypeVariable<?> var) {
        return type.resolveType(var).getType();
    }

    private static ITypeProvider createConstantTypeProvider(final Type type) {
        return new ITypeProvider(){

            @Override
            public Type getType(Object target, Object key) {
                return type;
            }
        };
    }

    public void overrideKeyType(Class<?> type) {
        this.overridenKeyType = type;
    }

    public void overrideKeyDocType(IScriptType type) {
        this.overridenKeyDocType = type;
    }

    public void overrideValueType(Class<?> type) {
        this.overridenValueType = type;
    }

    public void overrideValueDocType(IScriptType type) {
        this.overridenValueDocType = type;
    }

    private static ITypesProvider createTypesProvider(TypeToken<?> fieldType) {
        if (CUSTOM_PROPERTY_TYPE.isAssignableFrom(fieldType)) {
            if (CUSTOM_TYPED_PROPERTY_TYPE.isAssignableFrom(fieldType)) {
                return new CustomTypedPropertyTypesProvider(fieldType);
            }
            return new CustomPropertyTypesProvider(fieldType);
        }
        if (TypeUtils.MAP_TOKEN.isAssignableFrom(fieldType)) {
            return new MapTypesProvider(fieldType);
        }
        if (TypeUtils.LIST_TOKEN.isAssignableFrom(fieldType)) {
            return new ListTypesProvider(fieldType);
        }
        if (fieldType.isArray()) {
            return new ArrayTypesProvider(fieldType);
        }
        Class rawType = fieldType.getRawType();
        if (StructHandlerProvider.instance.isStruct(rawType)) {
            return new StructTypesProvider(rawType);
        }
        throw new IllegalArgumentException("Failed to deduce value type from" + fieldType);
    }

    private ITypesProvider getTypesProvider() {
        if (this.typesProvider == null) {
            this.typesProvider = IndexedTypeInfoBuilder.createTypesProvider(this.fieldType);
        }
        return this.typesProvider;
    }

    private static IndexedTypeInfo createTypeInfo(Type keyType, IScriptType keyDocType, final ITypeProvider valueTypeProvider, IScriptType valueDocType) {
        Preconditions.checkNotNull((Object)keyType, (Object)"Failed to deduce key type");
        Preconditions.checkNotNull((Object)keyDocType, (Object)"Failed to deduce key doc type");
        Preconditions.checkNotNull((Object)valueTypeProvider, (Object)"Failed to deduce value type");
        Preconditions.checkNotNull((Object)valueDocType, (Object)"Failed to deduce value doc type");
        return new IndexedTypeInfo(keyType, keyDocType, valueDocType){

            @Override
            public Type getValueType(Object target, Object key) {
                return valueTypeProvider.getType(target, key);
            }
        };
    }

    public IndexedTypeInfo build() {
        Type keyType = this.overridenKeyType == null ? this.getTypesProvider().getKeyType() : this.overridenKeyType;
        IScriptType keyDocType = this.overridenKeyDocType == null ? (this.overridenKeyType == null ? this.getTypesProvider().getKeyDocType() : IndexedTypeInfoBuilder.classifyType(this.overridenKeyType)) : this.overridenKeyDocType;
        ITypeProvider valueTypeProvider = this.overridenValueType == null ? this.getTypesProvider().getValueType() : IndexedTypeInfoBuilder.createConstantTypeProvider(this.overridenValueType);
        IScriptType valueDocType = this.overridenValueDocType == null ? (this.overridenValueType == null ? this.getTypesProvider().getValueDocType() : IndexedTypeInfoBuilder.classifyType(this.overridenValueType)) : this.overridenValueDocType;
        return IndexedTypeInfoBuilder.createTypeInfo(keyType, keyDocType, valueTypeProvider, valueDocType);
    }

    static {
        CUSTOM_TYPED_PROPERTY_TYPE = TypeToken.of(IIndexedTypedCustomProperty.class);
        TypeVariable<Class<T>>[] vars = IIndexedCustomProperty.class.getTypeParameters();
        CUSTOM_PROPERTY_KEY_TYPE = vars[0];
        CUSTOM_PROPERTY_VALUE_TYPE = vars[1];
        vars = IIndexedTypedCustomProperty.class.getTypeParameters();
        CUSTOM_TYPED_PROPERTY_KEY_TYPE = vars[0];
        CUSTOM_TYPED_PROPERTY_VALUE_TYPE = vars[1];
        DELEGATING_TYPE_PROVIDER = new ITypeProvider(){

            @Override
            public Type getType(Object target, Object key) {
                return ((IIndexedTypedCustomProperty)target).getType(key);
            }
        };
    }

    private static class CustomTypedPropertyTypesProvider
    extends CustomPropertyTypesProviderBase {
        public CustomTypedPropertyTypesProvider(TypeToken<?> fieldType) {
            super(fieldType, CUSTOM_TYPED_PROPERTY_KEY_TYPE, CUSTOM_TYPED_PROPERTY_VALUE_TYPE);
        }

        @Override
        public ITypeProvider getValueType() {
            return DELEGATING_TYPE_PROVIDER;
        }
    }

    private static class CustomPropertyTypesProvider
    extends CustomPropertyTypesProviderBase {
        public CustomPropertyTypesProvider(TypeToken<?> fieldType) {
            super(fieldType, CUSTOM_PROPERTY_KEY_TYPE, CUSTOM_PROPERTY_VALUE_TYPE);
        }

        @Override
        public ITypeProvider getValueType() {
            return IndexedTypeInfoBuilder.createConstantTypeProvider(this.valueType);
        }
    }

    private static abstract class CustomPropertyTypesProviderBase
    implements ITypesProvider {
        private final Class<?> fieldType;
        private final Type keyType;
        protected final Type valueType;

        public CustomPropertyTypesProviderBase(TypeToken<?> fieldType, TypeVariable<?> keyVar, TypeVariable<?> valueVar) {
            this.fieldType = fieldType.getRawType();
            this.keyType = fieldType.resolveType(keyVar).getType();
            this.valueType = fieldType.resolveType(valueVar).getType();
        }

        @Override
        public Type getKeyType() {
            return this.keyType;
        }

        @Override
        public IScriptType getKeyDocType() {
            PropertyKeyDocType customKeyDoc = this.fieldType.getAnnotation(PropertyKeyDocType.class);
            return customKeyDoc == null ? IndexedTypeInfoBuilder.classifyType(this.keyType) : SingleArgType.valueOf(customKeyDoc.value());
        }

        @Override
        public IScriptType getValueDocType() {
            PropertyValueDocType customValueDoc = this.fieldType.getAnnotation(PropertyValueDocType.class);
            return customValueDoc == null ? IndexedTypeInfoBuilder.classifyType(this.valueType) : SingleArgType.valueOf(customValueDoc.value());
        }
    }

    private static class StructTypesProvider
    implements ITypesProvider {
        private final StructHandlerProvider.IStructHandler handler;

        public StructTypesProvider(Class<?> structCls) {
            this.handler = StructHandlerProvider.instance.getHandler(structCls);
        }

        private static IScriptType identityCommonStructType(StructHandlerProvider.IStructHandler handler) {
            HashSet types = Sets.newHashSet();
            for (StructHandlerProvider.IFieldHandler fieldHandler : handler.fields()) {
                types.add(fieldHandler.type());
            }
            if (types.size() == 1) {
                Type type = (Type)types.iterator().next();
                return IndexedTypeInfoBuilder.classifyType(type);
            }
            return SingleType.WILDCHAR;
        }

        private static ITypeProvider createStructTypeProvider(final StructHandlerProvider.IStructHandler handler) {
            return new ITypeProvider(){

                @Override
                public Type getType(Object target, Object key) {
                    String fieldName = key.toString();
                    StructHandlerProvider.IFieldHandler field = handler.field(fieldName);
                    Preconditions.checkNotNull((Object)field, (String)"Failed to found field '%s'", (Object[])new Object[]{fieldName});
                    return field.type();
                }
            };
        }

        @Override
        public Type getKeyType() {
            return String.class;
        }

        @Override
        public IScriptType getKeyDocType() {
            return SingleArgType.STRING;
        }

        @Override
        public ITypeProvider getValueType() {
            return StructTypesProvider.createStructTypeProvider(this.handler);
        }

        @Override
        public IScriptType getValueDocType() {
            return StructTypesProvider.identityCommonStructType(this.handler);
        }
    }

    private static class ArrayTypesProvider
    extends ConstantTypesProvider {
        public ArrayTypesProvider(TypeToken<?> type) {
            super((Type)((Object)Index.class), type.getComponentType().getType());
        }
    }

    private static class ListTypesProvider
    extends ConstantTypesProvider {
        public ListTypesProvider(TypeToken<?> type) {
            super((Type)((Object)Index.class), IndexedTypeInfoBuilder.getTypeVariable(type, TypeUtils.LIST_VALUE_PARAM));
        }
    }

    private static class MapTypesProvider
    extends ConstantTypesProvider {
        public MapTypesProvider(TypeToken<?> type) {
            super(IndexedTypeInfoBuilder.getTypeVariable(type, TypeUtils.MAP_KEY_PARAM), IndexedTypeInfoBuilder.getTypeVariable(type, TypeUtils.MAP_VALUE_PARAM));
        }
    }

    private static class ConstantTypesProvider
    implements ITypesProvider {
        private final Type keyType;
        private final Type valueType;

        public ConstantTypesProvider(Type keyType, Type valueType) {
            this.keyType = keyType;
            this.valueType = valueType;
        }

        @Override
        public Type getKeyType() {
            return this.keyType;
        }

        @Override
        public IScriptType getKeyDocType() {
            return IndexedTypeInfoBuilder.classifyType(this.keyType);
        }

        @Override
        public ITypeProvider getValueType() {
            return IndexedTypeInfoBuilder.createConstantTypeProvider(this.valueType);
        }

        @Override
        public IScriptType getValueDocType() {
            return IndexedTypeInfoBuilder.classifyType(this.valueType);
        }
    }

    private static interface ITypesProvider {
        public Type getKeyType();

        public IScriptType getKeyDocType();

        public ITypeProvider getValueType();

        public IScriptType getValueDocType();
    }

    private static interface ITypeProvider {
        public Type getType(Object var1, Object var2);
    }
}

