/*
 * Decompiled with CFR 0.152.
 */
package openperipheral;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import openmods.Log;
import openmods.config.properties.ConfigProcessing;
import openperipheral.ApiSetup;
import openperipheral.ArchitectureChecker;
import openperipheral.CommandDump;
import openperipheral.Config;
import openperipheral.ConfigGuiFactory;
import openperipheral.adapter.FeatureGroupManager;
import openperipheral.adapter.PeripheralTypeProvider;
import openperipheral.adapter.TileEntityBlacklist;
import openperipheral.adapter.types.classifier.MinecraftTypeClassifier;
import openperipheral.adapter.types.classifier.TypeClassifier;
import openperipheral.api.peripheral.IOpenPeripheral;
import openperipheral.interfaces.cc.ComputerCraftChecker;
import openperipheral.interfaces.cc.ModuleComputerCraft;
import openperipheral.interfaces.oc.ModuleOpenComputers;
import openperipheral.interfaces.oc.OpenComputersChecker;

@Mod(modid="OpenPeripheralCore", name="OpenPeripheralCore", version="1.4", dependencies="required-after:OpenMods@[0.10,0.11);after:ComputerCraft@[1.70,];after:OpenComputers@[1.5.0,];", acceptableRemoteVersions="*", guiFactory="openperipheral.ConfigGuiFactory")
public class OpenPeripheralCore {
    private final ApiSetup apiSetup = new ApiSetup();
    @Mod.Instance(value="OpenPeripheralCore")
    public static OpenPeripheralCore instance;
    private Configuration config;

    Configuration config() {
        return this.config;
    }

    @Mod.EventHandler
    public void construct(FMLConstructionEvent evt) {
        ArchitectureChecker.INSTANCE.register("ComputerCraft", new ComputerCraftChecker());
        ArchitectureChecker.INSTANCE.register("OpenComputers", new OpenComputersChecker());
        this.apiSetup.setupApis();
        this.apiSetup.installProviderAccess();
        if (ArchitectureChecker.INSTANCE.isEnabled("OpenComputers")) {
            ModuleOpenComputers.init();
        }
        if (ArchitectureChecker.INSTANCE.isEnabled("ComputerCraft")) {
            ModuleComputerCraft.init();
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        this.apiSetup.installHolderAccess(evt.getAsmData());
        PeripheralTypeProvider.INSTANCE.initialize(evt.getModConfigurationDirectory());
        File configFile = evt.getSuggestedConfigurationFile();
        this.config = new Configuration(configFile);
        ConfigProcessing.processAnnotations((String)"OpenPeripheralCore", (Configuration)this.config, Config.class);
        if (this.config.hasChanged()) {
            this.config.save();
        }
        FeatureGroupManager.INSTANCE.loadBlacklist(Config.featureGroupsBlacklist);
        FMLCommonHandler.instance().bus().register((Object)new ConfigGuiFactory.ConfigChangeListener(this.config));
        MinecraftForge.EVENT_BUS.register((Object)TileEntityBlacklist.INSTANCE);
        FMLInterModComms.sendMessage((String)"OpenComputers", (String)"blacklistPeripheral", (String)IOpenPeripheral.class.getName());
        TypeClassifier.INSTANCE.registerClassifier(new MinecraftTypeClassifier());
        FeatureGroupManager.INSTANCE.loadFeatureGroupsFromAnnotations(evt.getAsmData());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        if (ArchitectureChecker.INSTANCE.isEnabled("OpenComputers")) {
            ModuleOpenComputers.registerProvider();
        }
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent evt) {
        if (ArchitectureChecker.INSTANCE.isEnabled("ComputerCraft")) {
            ModuleComputerCraft.registerProvider();
        }
    }

    @Mod.EventHandler
    public void processMessage(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage m : event.getMessages()) {
            if (!m.isStringMessage()) continue;
            if ("ignoreTileEntity".equalsIgnoreCase(m.key)) {
                TileEntityBlacklist.INSTANCE.addToBlacklist(m.getStringValue());
                continue;
            }
            if (!"registerClassType".equalsIgnoreCase(m.key)) continue;
            String value = m.getStringValue();
            String[] fields = value.split("\\s+");
            if (fields.length != 2) {
                Log.warn((String)"Invalid IMC from %s: can't decode type '%s'", (Object[])new Object[]{m.getSender(), value});
                continue;
            }
            PeripheralTypeProvider.INSTANCE.setType(fields[0], fields[1]);
        }
    }

    @Mod.EventHandler
    public void severStart(FMLServerStartingEvent evt) {
        evt.registerServerCommand((ICommand)new CommandDump("op_dump", evt.getServer().func_71262_S()));
    }
}

