/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCompat;
import buildcraft.api.transport.IPipeTile;
import buildcraft.compat.bluepower.BRProviderBluePower;
import buildcraft.core.lib.utils.MathUtils;
import buildcraft.transport.TileGenericPipe;
import cofh.api.inventory.IInventoryConnection;
import cofh.api.transport.IItemDuct;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import mods.immibis.redlogic.api.wiring.IBareRedstoneWire;
import mods.immibis.redlogic.api.wiring.IBundledEmitter;
import mods.immibis.redlogic.api.wiring.IBundledUpdatable;
import mods.immibis.redlogic.api.wiring.IBundledWire;
import mods.immibis.redlogic.api.wiring.IConnectable;
import mods.immibis.redlogic.api.wiring.IRedstoneEmitter;
import mods.immibis.redlogic.api.wiring.IWire;
import mrtjp.projectred.api.IBundledTile;
import mrtjp.projectred.api.ProjectRedAPI;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="mods.immibis.redlogic.api.wiring.IBundledEmitter", modid="RedLogic"), @Optional.Interface(iface="mods.immibis.redlogic.api.wiring.IBundledUpdatable", modid="RedLogic"), @Optional.Interface(iface="mods.immibis.redlogic.api.wiring.IConnectable", modid="RedLogic"), @Optional.Interface(iface="mods.immibis.redlogic.api.wiring.IRedstoneEmitter", modid="RedLogic"), @Optional.Interface(iface="mrtjp.projectred.api.IBundledTile", modid="ProjRed|Core")})
public class TileGenericPipeCompat
extends TileGenericPipe
implements IItemDuct,
IBundledEmitter,
IBundledUpdatable,
IConnectable,
IRedstoneEmitter,
IBundledTile {
    public byte[][] bundledCableReceived = new byte[6][16];
    public byte[][] bundledCableSent = new byte[6][16];
    public byte[][] bundledCableSentLast = new byte[6][16];
    public Object bluepowerWrapper;

    public void clearBundledCables() {
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 16; ++j) {
                this.bundledCableSentLast[i][j] = this.bundledCableSent[i][j];
                this.bundledCableSent[i][j] = 0;
            }
        }
    }

    public void setBundledCable(int side, int position, boolean value) {
        if (side == -1) {
            for (int i = 0; i < 6; ++i) {
                this.setBundledCable(i, position, value);
            }
        } else {
            this.bundledCableSent[side][position & 0xF] = (byte)(value ? -1 : 0);
        }
    }

    public boolean getBundledCable(int side, int position) {
        if (side == -1) {
            for (int i = 0; i < 6; ++i) {
                if (!this.getBundledCable(i, position)) continue;
                return true;
            }
            return false;
        }
        return this.bundledCableReceived[side][position & 0xF] != 0;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && BuildCraftCompat.isLoaded("BundledRedstone")) {
            this.clearBundledCables();
            if (this.blockNeighborChange && Loader.isModLoaded((String)"ProjRed|Core")) {
                this.updateProjectRedBundled();
            }
        }
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K && BuildCraftCompat.isLoaded("BundledRedstone")) {
            block0: for (int side = 0; side < 6; ++side) {
                for (int position = 0; position < 16; ++position) {
                    if (this.bundledCableSent[side][position] == this.bundledCableSentLast[side][position]) continue;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    ForgeDirection orientation = ForgeDirection.getOrientation((int)side);
                    this.field_145850_b.func_147460_e(this.field_145851_c + orientation.offsetX, this.field_145848_d + orientation.offsetY, this.field_145849_e + orientation.offsetZ, this.field_145854_h);
                    continue block0;
                }
            }
        }
    }

    protected boolean canPipeConnect_internal(TileEntity with, ForgeDirection side) {
        if (with instanceof IInventoryConnection && this.getPipeType() == IPipeTile.PipeType.ITEM) {
            if (((IInventoryConnection)with).canConnectInventory(side.getOpposite()) == IInventoryConnection.ConnectionType.FORCE) {
                return true;
            }
            if (((IInventoryConnection)with).canConnectInventory(side.getOpposite()) == IInventoryConnection.ConnectionType.DENY) {
                return false;
            }
        }
        if (BuildCraftCompat.isLoaded("BundledRedstone")) {
            if (Loader.isModLoaded((String)"RedLogic") && this.canPipeConnect_RedLogic(with, side)) {
                return true;
            }
            if (Loader.isModLoaded((String)"bluepower") && this.canPipeConnect_BluePower(with, side)) {
                return true;
            }
        }
        return super.canPipeConnect_internal(with, side);
    }

    @Optional.Method(modid="RedLogic")
    protected boolean canPipeConnect_RedLogic(TileEntity with, ForgeDirection side) {
        return with instanceof IBundledWire && ((IBundledWire)with).wireConnectsInDirection(-1, side.getOpposite().ordinal());
    }

    @Optional.Method(modid="RedLogic")
    public boolean connects(IWire wire, int blockFace, int fromDirection) {
        ForgeDirection side = ForgeDirection.getOrientation((int)fromDirection);
        if (this.hasBlockingPluggable(side)) {
            return false;
        }
        if (BuildCraftCompat.isLoaded("BundledRedstone") && wire instanceof IBundledWire) {
            return blockFace == -1;
        }
        return wire instanceof IBareRedstoneWire;
    }

    @Optional.Method(modid="RedLogic")
    public boolean connectsAroundCorner(IWire wire, int blockFace, int fromDirection) {
        return false;
    }

    @Optional.Method(modid="RedLogic")
    public void onBundledInputChanged() {
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 16; ++j) {
                this.bundledCableReceived[i][j] = 0;
            }
        }
        for (int side = 0; side < 6; ++side) {
            byte[] data;
            TileEntity tile = this.getTile(ForgeDirection.getOrientation((int)side));
            if (!(tile instanceof IBundledEmitter) || tile instanceof IBundledWire && !((IBundledWire)tile).wireConnectsInDirection(-1, side ^ 1) || (data = ((IBundledEmitter)tile).getBundledCableStrength(-1, side ^ 1)) == null) continue;
            for (int position = 0; position < 16; ++position) {
                if ((data[position] & 0xFF) <= (this.bundledCableReceived[side][position] & 0xFF)) continue;
                this.bundledCableReceived[side][position] = data[position];
            }
        }
    }

    @Optional.Method(modid="RedLogic")
    public byte[] getBundledCableStrength(int blockFace, int toDirection) {
        if (blockFace != -1) {
            return null;
        }
        return this.bundledCableSent[toDirection];
    }

    @Optional.Method(modid="RedLogic")
    public short getEmittedSignalStrength(int blockFace, int toDirection) {
        int signal = 0;
        if (this.pipe != null) {
            signal = MathUtils.clamp((int)this.pipe.isPoweringTo(toDirection), (int)0, (int)15);
        }
        return (short)(signal << 4 | signal);
    }

    @Override
    public ItemStack insertItem(ForgeDirection from, ItemStack item) {
        int itemsUsed = this.injectItem(item, true, from);
        if (itemsUsed == item.field_77994_a) {
            return null;
        }
        ItemStack out = item.func_77946_l();
        out.field_77994_a -= itemsUsed;
        return out;
    }

    @Optional.Method(modid="ProjRed|Core")
    public boolean canConnectBundled(int fromDirection) {
        ForgeDirection side = ForgeDirection.getOrientation((int)fromDirection);
        if (this.hasBlockingPluggable(side)) {
            return false;
        }
        return BuildCraftCompat.isLoaded("BundledRedstone");
    }

    @Optional.Method(modid="ProjRed|Core")
    public byte[] getBundledSignal(int dir) {
        return this.bundledCableSent[dir];
    }

    @Optional.Method(modid="ProjRed|Core")
    private void updateProjectRedBundled() {
        for (int i = 0; i < 6; ++i) {
            byte[] data = ProjectRedAPI.transmissionAPI.getBundledInput(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, i);
            if (data == null || data.length != 16) continue;
            this.bundledCableReceived[i] = data;
        }
    }

    @Optional.Method(modid="bluepower")
    protected boolean canPipeConnect_BluePower(TileEntity with, ForgeDirection side) {
        return BRProviderBluePower.hasFreestandingBundledWire(with);
    }
}

