/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.types.multi;

import com.google.common.base.Preconditions;
import openmods.calc.Frame;
import openmods.calc.ICallable;
import openmods.calc.ISymbol;
import openmods.calc.types.multi.TypeDomain;
import openmods.calc.types.multi.TypedValue;
import openmods.utils.OptionalInt;

public abstract class CallableValue {
    public static CallableValue from(final ICallable<TypedValue> callable) {
        return new CallableValue(){

            @Override
            public void call(TypedValue self, OptionalInt argumentsCount, OptionalInt returnsCount, Frame<TypedValue> frame) {
                callable.call(frame, argumentsCount, returnsCount);
            }

            @Override
            public ISymbol<TypedValue> toSymbol(TypeDomain domain) {
                TypedValue self = this.selfValue(domain);
                return this.createSymbol(self, callable);
            }

            private ISymbol<TypedValue> createSymbol(final TypedValue self, final ICallable<TypedValue> callable2) {
                return new ISymbol<TypedValue>(){

                    @Override
                    public void call(Frame<TypedValue> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
                        callable2.call(frame, argumentsCount, returnsCount);
                    }

                    @Override
                    public TypedValue get() {
                        return self;
                    }
                };
            }
        };
    }

    public abstract void call(TypedValue var1, OptionalInt var2, OptionalInt var3, Frame<TypedValue> var4);

    public ISymbol<TypedValue> toSymbol(TypeDomain domain) {
        TypedValue self = this.selfValue(domain);
        return this.createSymbol(self);
    }

    public ISymbol<TypedValue> toSymbol(TypedValue value) {
        Preconditions.checkState((value.value == this ? 1 : 0) != 0);
        return this.createSymbol(value);
    }

    private ISymbol<TypedValue> createSymbol(final TypedValue self) {
        return new ISymbol<TypedValue>(){

            @Override
            public void call(Frame<TypedValue> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
                CallableValue.this.call(self, argumentsCount, returnsCount, frame);
            }

            @Override
            public TypedValue get() {
                return self;
            }
        };
    }

    public TypedValue selfValue(TypeDomain domain) {
        return domain.create(CallableValue.class, this);
    }

    public static TypedValue wrap(TypeDomain domain, ICallable<TypedValue> callable) {
        return domain.create(CallableValue.class, CallableValue.from(callable));
    }
}

