/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.gui;

import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.gui.Button;
import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.PanelScrollBar;
import com.feed_the_beast.ftblib.lib.gui.ScrollBar;
import com.feed_the_beast.ftblib.lib.gui.SimpleButton;
import com.feed_the_beast.ftblib.lib.gui.TextField;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetLayout;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.io.DataReader;
import com.feed_the_beast.ftblib.lib.io.HttpDataReader;
import com.feed_the_beast.ftblib.lib.io.RequestMethod;
import com.feed_the_beast.ftblib.lib.util.CommonUtils;
import com.feed_the_beast.ftblib.lib.util.FileUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbutilities.net.MessageViewCrashDelete;
import com.google.gson.JsonElement;
import java.io.File;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class GuiViewCrash
extends GuiBase {
    private final List<String> text;
    private final TextField name;
    private final Panel textPanel;
    private final PanelScrollBar scrollH;
    private final PanelScrollBar scrollV;
    private final Button close;
    private final Button upload;
    private final Button delete;
    private final Button reset;

    public GuiViewCrash(String n, Collection<String> l) {
        this.name = new TextField((Panel)this, n);
        this.name.setPosAndSize(8, 12, 0, 20);
        this.text = new ArrayList<String>(l);
        this.textPanel = new Panel((Panel)this){

            public void addWidgets() {
                for (String s : GuiViewCrash.this.text) {
                    this.add((Widget)new TextField((Panel)this, StringUtils.fixTabs((String)s, (int)2), 8));
                }
            }

            public void alignWidgets() {
                int wi = 0;
                for (Widget w : this.widgets) {
                    w.setX(2);
                    wi = Math.max(w.width, wi);
                }
                GuiViewCrash.this.scrollH.setMaxValue(wi + 4);
                GuiViewCrash.this.scrollV.setMaxValue(this.align(WidgetLayout.VERTICAL));
            }

            public Icon getIcon() {
                return this.getTheme().getContainerSlot();
            }
        };
        this.textPanel.setPos(9, 33);
        this.textPanel.setUnicode(true);
        this.scrollH = new PanelScrollBar((Panel)this, ScrollBar.Plane.HORIZONTAL, this.textPanel);
        this.scrollH.setCanAlwaysScroll(true);
        this.scrollH.setCanAlwaysScrollPlane(false);
        this.scrollH.setScrollStep(30);
        this.scrollV = new PanelScrollBar((Panel)this, this.textPanel);
        this.scrollV.setCanAlwaysScroll(true);
        this.scrollV.setCanAlwaysScrollPlane(false);
        this.scrollV.setScrollStep(30);
        this.close = new SimpleButton((Panel)this, I18n.func_135052_a((String)"gui.close", (Object[])new Object[0]), GuiIcons.CLOSE, (widget, button) -> widget.getGui().closeGui()){

            public Icon getIcon() {
                return this.getButtonBackground().withBorder(-2).combineWith(super.getIcon());
            }
        };
        this.upload = new SimpleButton((Panel)this, I18n.func_135052_a((String)"ftbutilities.lang.upload_crash", (Object[])new Object[0]), GuiIcons.UP, (widget, button) -> {
            new ThreadUploadCrash().start();
            widget.getGui().closeGui(false);
        }){

            public Icon getIcon() {
                return this.getButtonBackground().withBorder(-2).combineWith(super.getIcon());
            }
        };
        this.delete = new SimpleButton((Panel)this, I18n.func_135052_a((String)"selectServer.delete", (Object[])new Object[0]), GuiIcons.REMOVE, (widget, button) -> ClientUtils.MC.func_147108_a((GuiScreen)new GuiYesNo((result, id) -> {
            this.openGui();
            if (result) {
                new MessageViewCrashDelete(this.name.text[0]).sendToServer();
            }
        }, I18n.func_135052_a((String)"delete_item", (Object[])new Object[]{this.name.text[0]}), "", 0))){

            public Icon getIcon() {
                return this.getButtonBackground().withBorder(-2).combineWith(super.getIcon());
            }
        };
        this.reset = new SimpleButton((Panel)this, "", (Icon)Icon.EMPTY, (widget, button) -> {
            this.scrollH.setValue(0);
            this.scrollV.setValue(0);
        });
    }

    public boolean onInit() {
        return this.setFullscreen();
    }

    public void addWidgets() {
        this.add((Widget)this.textPanel);
        this.add((Widget)this.scrollH);
        this.add((Widget)this.scrollV);
        this.add((Widget)this.close);
        this.add((Widget)this.upload);
        this.add((Widget)this.delete);
        this.add((Widget)this.reset);
        this.add((Widget)this.name);
    }

    public void alignWidgets() {
        this.close.setPos(this.width - 24, 8);
        this.upload.setPos(this.width - 48, 8);
        this.delete.setPos(this.width - 72, 8);
        this.reset.setPos(this.width - 24, this.height - 24);
        this.scrollH.setPosAndSize(8, this.height - 24, this.width - 32, 16);
        this.scrollV.setPosAndSize(this.width - 24, 32, 16, this.height - 56);
        this.textPanel.setSize(this.scrollH.width - 2, this.scrollV.height - 2);
        this.textPanel.alignWidgets();
    }

    public class ThreadUploadCrash
    extends Thread {
        @Override
        public void run() {
            try {
                URL hastebinURL;
                JsonElement json;
                File urlFile = new File(CommonUtils.folderLocal, "ftbutilities/uploaded_crash_reports/crash-" + ((GuiViewCrash)GuiViewCrash.this).name.text[0] + ".txt");
                String url = DataReader.get((File)urlFile).safeString();
                if (url.isEmpty() && (json = DataReader.get((URL)(hastebinURL = new URL("https://hastebin.com/documents")), (RequestMethod)RequestMethod.POST, (String)"text/plain; charset=utf-8", (HttpDataReader.HttpDataOutput)new HttpDataReader.HttpDataOutput.StringOutput((Iterable)GuiViewCrash.this.text), (Proxy)ClientUtils.MC.func_110437_J()).json()).isJsonObject() && json.getAsJsonObject().has("key")) {
                    url = "https://hastebin.com/" + json.getAsJsonObject().get("key").getAsString() + ".md";
                    FileUtils.saveSafe((File)urlFile, (String)url);
                }
                if (!url.isEmpty()) {
                    TextComponentTranslation link = new TextComponentTranslation("click_here", new Object[0]);
                    link.func_150256_b().func_150238_a(TextFormatting.GOLD);
                    link.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(url)));
                    link.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
                    ClientUtils.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation("ftbutilities.lang.uploaded_crash", new Object[]{link}));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

