/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.gui;

import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiButtonListBase;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbutilities.data.LeaderboardValue;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiLeaderboard
extends GuiButtonListBase {
    private final List<LeaderboardValue> leaderboard;
    private int rankSize;
    private int usernameSize;
    private int valueSize;

    public GuiLeaderboard(ITextComponent c, List<LeaderboardValue> l) {
        this.setTitle(I18n.func_135052_a((String)"sidebar_button.ftbutilities.leaderboards", (Object[])new Object[0]) + " > " + c.func_150254_d());
        this.setHasSearchBox(true);
        this.leaderboard = l;
    }

    public void addButtons(Panel panel) {
        int i = 0;
        this.rankSize = 0;
        this.usernameSize = 0;
        this.valueSize = 0;
        for (LeaderboardValue value : this.leaderboard) {
            value.rank = ++i;
            panel.add((Widget)new LeaderboardEntry(panel, value));
        }
    }

    public String getFilterText(Widget widget) {
        return ((LeaderboardEntry)((LeaderboardEntry)widget)).value.username;
    }

    private class LeaderboardEntry
    extends Widget {
        private final LeaderboardValue value;
        private final String rank;

        public LeaderboardEntry(Panel panel, LeaderboardValue v) {
            super(panel);
            this.value = v;
            this.rank = this.value.color + "#" + StringUtils.add0s((int)v.rank, (int)GuiLeaderboard.this.leaderboard.size());
            GuiLeaderboard.this.rankSize = Math.max(GuiLeaderboard.this.rankSize, this.getStringWidth(this.rank) + 4);
            GuiLeaderboard.this.usernameSize = Math.max(GuiLeaderboard.this.usernameSize, this.getStringWidth(v.username) + 8);
            GuiLeaderboard.this.valueSize = Math.max(GuiLeaderboard.this.valueSize, this.getStringWidth(this.value.value.func_150254_d()) + 8);
            this.setSize(GuiLeaderboard.this.rankSize + GuiLeaderboard.this.usernameSize + GuiLeaderboard.this.valueSize, 14);
        }

        public void addMouseOverText(List<String> list) {
        }

        public void draw() {
            int ax = this.getAX();
            int ay = this.getAY();
            Icon widget = this.value.color == TextFormatting.DARK_GRAY ? this.getTheme().getButton(WidgetType.DISABLED) : this.getTheme().getButton(WidgetType.mouseOver((boolean)this.isMouseOver()));
            int textY = ay + (this.height - this.getFontHeight() + 1) / 2;
            widget.draw(ax, ay, GuiLeaderboard.this.rankSize, this.height);
            this.drawString(this.rank, ax + 2, textY, 2);
            widget.draw(ax + GuiLeaderboard.this.rankSize, ay, GuiLeaderboard.this.usernameSize, this.height);
            this.drawString(this.value.color + this.value.username, ax + 4 + GuiLeaderboard.this.rankSize, textY, 2);
            widget.draw(ax + GuiLeaderboard.this.rankSize + GuiLeaderboard.this.usernameSize, ay, GuiLeaderboard.this.valueSize, this.height);
            String formattedText = this.value.value.func_150254_d();
            this.drawString(this.value.color + formattedText, ax + GuiLeaderboard.this.rankSize + GuiLeaderboard.this.usernameSize + GuiLeaderboard.this.valueSize - this.getStringWidth(formattedText) - 4, textY, 2);
        }
    }
}

