/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.energy;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.xnet.api.gui.IEditorGui;
import mcjty.xnet.api.gui.IndicatorIcon;
import mcjty.xnet.api.helper.AbstractConnectorSettings;
import mcjty.xnet.config.GeneralConfiguration;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class EnergyConnectorSettings
extends AbstractConnectorSettings {
    public static final ResourceLocation iconGuiElements = new ResourceLocation("xnet", "textures/gui/guielements.png");
    public static final String TAG_MODE = "mode";
    public static final String TAG_RATE = "rate";
    public static final String TAG_MINMAX = "minmax";
    public static final String TAG_PRIORITY = "priority";
    private EnergyMode energyMode = EnergyMode.INS;
    @Nullable
    private Integer priority = 0;
    @Nullable
    private Integer rate = null;
    @Nullable
    private Integer minmax = null;
    private static Set<String> INSERT_TAGS = ImmutableSet.of((Object)"mode", (Object)"rs", (Object)"color0", (Object)"color1", (Object)"color2", (Object)"color3", (Object[])new String[]{"rate", "minmax", "priority"});
    private static Set<String> EXTRACT_TAGS = ImmutableSet.of((Object)"mode", (Object)"rs", (Object)"color0", (Object)"color1", (Object)"color2", (Object)"color3", (Object[])new String[]{"rate", "minmax", "priority"});

    public EnergyConnectorSettings(@Nonnull EnumFacing side) {
        super(side);
    }

    public EnergyMode getEnergyMode() {
        return this.energyMode;
    }

    @Override
    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        switch (this.energyMode) {
            case INS: {
                return new IndicatorIcon(iconGuiElements, 0, 70, 13, 10);
            }
            case EXT: {
                return new IndicatorIcon(iconGuiElements, 13, 70, 13, 10);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public String getIndicator() {
        return null;
    }

    @Override
    public void createGui(IEditorGui gui) {
        this.advanced = gui.isAdvanced();
        this.sideGui(gui);
        this.colorsGui(gui);
        this.redstoneGui(gui);
        gui.nl().choices(TAG_MODE, "Insert or extract mode", this.energyMode, EnergyMode.values()).nl().label("Pri").integer(TAG_PRIORITY, "Insertion priority", this.priority, 30).nl().label("Rate").integer(TAG_RATE, (this.energyMode == EnergyMode.EXT ? "Max energy extraction rate" : "Max energy insertion rate") + "|(limited to " + (gui.isAdvanced() ? GeneralConfiguration.maxRfRateAdvanced : GeneralConfiguration.maxRfRateNormal) + " per tick)", this.rate, 40).shift(10).label(this.energyMode == EnergyMode.EXT ? "Min" : "Max").integer(TAG_MINMAX, this.energyMode == EnergyMode.EXT ? "Disable extraction if energy|is too low" : "Disable insertion if energy|is too high", this.minmax, 50);
    }

    @Override
    public boolean isEnabled(String tag) {
        if (this.energyMode == EnergyMode.INS) {
            if (tag.equals("facing")) {
                return this.advanced;
            }
            return INSERT_TAGS.contains(tag);
        }
        if (tag.equals("facing")) {
            return false;
        }
        return EXTRACT_TAGS.contains(tag);
    }

    @Nonnull
    public Integer getPriority() {
        return this.priority == null ? 0 : this.priority;
    }

    @Nullable
    public Integer getRate() {
        return this.rate;
    }

    @Nullable
    public Integer getMinmax() {
        return this.minmax;
    }

    @Override
    public void update(Map<String, Object> data) {
        super.update(data);
        this.energyMode = EnergyMode.valueOf(((String)data.get(TAG_MODE)).toUpperCase());
        this.rate = (Integer)data.get(TAG_RATE);
        this.minmax = (Integer)data.get(TAG_MINMAX);
        this.priority = (Integer)data.get(TAG_PRIORITY);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.energyMode = EnergyMode.values()[tag.func_74771_c("itemMode")];
        this.priority = tag.func_74764_b(TAG_PRIORITY) ? Integer.valueOf(tag.func_74762_e(TAG_PRIORITY)) : null;
        this.rate = tag.func_74764_b(TAG_RATE) ? Integer.valueOf(tag.func_74762_e(TAG_RATE)) : null;
        this.minmax = tag.func_74764_b(TAG_MINMAX) ? Integer.valueOf(tag.func_74762_e(TAG_MINMAX)) : null;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74774_a("itemMode", (byte)this.energyMode.ordinal());
        if (this.priority != null) {
            tag.func_74768_a(TAG_PRIORITY, this.priority.intValue());
        }
        if (this.rate != null) {
            tag.func_74768_a(TAG_RATE, this.rate.intValue());
        }
        if (this.minmax != null) {
            tag.func_74768_a(TAG_MINMAX, this.minmax.intValue());
        }
    }

    static enum EnergyMode {
        INS,
        EXT;

    }
}

