/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.util;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.IArmor;
import net.silentchaos512.gems.api.ITool;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.item.tool.ItemGemKatana;
import net.silentchaos512.gems.lib.EnumGem;
import net.silentchaos512.gems.util.ArmorHelper;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.lib.util.EntityHelper;

public class ToolRandomizer {
    public static final float SECOND_GEM_CHANCE = 0.7f;
    public static final float THIRD_GEM_CHANCE = 0.5f;
    public static final float FOURTH_GEM_CHANCE = 0.2f;
    public static final float SUPER_TIER_CHANCE = 0.33f;
    private static final String[] NAME_ADJECTIVES_BASE = new String[]{"an abstract", "an ancient", "a bite-sized", "a brave", "a convenient", "a creepy", "a dashing", "a defenestrated", "a disturbed", "a dizzy", "a fanatical", "a grieving", "a languid", "a mysterious", "a psychotic", "a quaint", "a questionable", "a quizzical", "a redundant", "a sentient", "a sturdy", "a tasteful", "a thoughtful", "an unbiased", "an unloved"};
    private static final String[] NAME_NOUNS_BASE = new String[]{"alien", "alpaca", "bench", "buffalo", "cake", "cat", "crate", "dime", "egg", "fish", "fork", "guitar", "hammer", "hatred", "key", "lamp", "mitten", "pair of dice", "pendulum", "pizza", "potato", "rice cooker", "rock", "shelf", "sock puppet", "spoon", "square", "storm", "surprise", "toaster", "toothbrush", "toy", "tree", "twig", "wheel"};
    public List<String> nameAdjectives = Lists.newArrayList((Object[])NAME_ADJECTIVES_BASE);
    public List<String> nameNouns = Lists.newArrayList((Object[])NAME_NOUNS_BASE);
    public static ToolRandomizer INSTANCE = new ToolRandomizer();

    private ToolRandomizer() {
        for (String name : EntityHelper.getEntityNameList()) {
            String entityName = "entity." + name + ".name";
            String localizedName = SilentGems.localizationHelper.getLocalizedString(entityName, new Object[0]);
            if (localizedName.endsWith(".name")) continue;
            this.nameNouns.add(localizedName.toLowerCase());
        }
    }

    public ItemStack randomize(ItemStack tool) {
        return this.randomize(tool, 0.33f);
    }

    public ItemStack randomize(ItemStack tool, float superChance) {
        ItemStack rod;
        ItemStack[] choices;
        EnumGem g1;
        EnumGem[] gems;
        boolean gem3;
        if (tool.func_77973_b() instanceof IArmor) {
            return this.randomizeArmor(tool, superChance);
        }
        if (!(tool.func_77973_b() instanceof ITool) || !ToolHelper.hasNoConstruction(tool)) {
            return tool;
        }
        ITool itool = (ITool)tool.func_77973_b();
        boolean superTier = !itool.getValidTiers().contains((Object)EnumMaterialTier.REGULAR) || SilentGems.random.nextFloat() < superChance && itool.getValidTiers().contains((Object)EnumMaterialTier.SUPER);
        boolean gem2 = SilentGems.random.nextFloat() < 0.7f;
        boolean bl = gem3 = gem2 && SilentGems.random.nextFloat() < 0.5f;
        if (gem3) {
            gems = new EnumGem[]{EnumGem.getRandom(), EnumGem.getRandom(), EnumGem.getRandom()};
        } else if (gem2) {
            g1 = EnumGem.getRandom();
            EnumGem g2 = EnumGem.getRandom();
            gems = tool.func_77973_b() == ModItems.sword ? new EnumGem[]{g1, g2} : new EnumGem[]{g1, g2, g1};
        } else {
            g1 = EnumGem.getRandom();
            gems = new EnumGem[]{g1, g1, g1};
        }
        ItemStack[] craftingStacks = new ItemStack[gems.length];
        for (int i = 0; i < craftingStacks.length; ++i) {
            craftingStacks[i] = superTier ? gems[i].getItemSuper() : gems[i].getItem();
        }
        if (superTier) {
            choices = new ItemStack[]{ModItems.craftingMaterial.toolRodGold, ModItems.craftingMaterial.toolRodSilver, ModItems.craftingMaterial.toolRodIron};
            rod = choices[SilentGems.random.nextInt(choices.length)];
        } else {
            choices = new ItemStack[]{new ItemStack(Items.field_151055_y), new ItemStack(Items.field_151103_aS), ModItems.craftingMaterial.toolRodIron};
            rod = choices[SilentGems.random.nextInt(choices.length)];
        }
        ItemStack temp = ToolHelper.constructTool(tool.func_77973_b(), rod, craftingStacks);
        if (temp.func_77973_b() instanceof ItemGemKatana) {
            temp = ((ItemGemKatana)temp.func_77973_b()).addDefaultGrip(temp);
        }
        String ownerName = this.nameAdjectives.get(SilentGems.random.nextInt(this.nameAdjectives.size())) + " " + this.nameNouns.get(SilentGems.random.nextInt(this.nameNouns.size()));
        ToolHelper.setOriginalOwner(temp, TextFormatting.AQUA + ownerName);
        tool.func_77982_d(temp.func_77978_p());
        return temp;
    }

    public ItemStack randomizeArmor(ItemStack armor, float superChance) {
        EnumGem g1;
        EnumGem[] gems;
        boolean gem4;
        if (!ToolHelper.hasNoConstruction(armor)) {
            return armor;
        }
        IArmor itool = (IArmor)armor.func_77973_b();
        boolean superTier = SilentGems.random.nextFloat() < superChance;
        boolean gem2 = SilentGems.random.nextFloat() < 0.7f;
        boolean gem3 = gem2 && SilentGems.random.nextFloat() < 0.5f;
        boolean bl = gem4 = gem3 && SilentGems.random.nextFloat() < 0.2f;
        if (gem4) {
            gems = new EnumGem[]{EnumGem.getRandom(), EnumGem.getRandom(), EnumGem.getRandom(), EnumGem.getRandom()};
        } else if (gem3) {
            g1 = EnumGem.getRandom();
            gems = new EnumGem[]{g1, EnumGem.getRandom(), EnumGem.getRandom(), g1};
        } else if (gem2) {
            g1 = EnumGem.getRandom();
            EnumGem g2 = EnumGem.getRandom();
            gems = new EnumGem[]{g1, g2, g1, g2};
        } else {
            g1 = EnumGem.getRandom();
            gems = new EnumGem[]{g1, g1, g1, g1};
        }
        ItemStack[] craftingStacks = new ItemStack[gems.length];
        for (int i = 0; i < craftingStacks.length; ++i) {
            craftingStacks[i] = superTier ? gems[i].getItemSuper() : gems[i].getItem();
        }
        ItemStack frame = ModItems.armorFrame.getFrameForArmorPiece((ItemArmor)armor.func_77973_b(), superTier ? EnumMaterialTier.SUPER : EnumMaterialTier.REGULAR);
        ItemStack temp = ArmorHelper.constructArmor(armor.func_77973_b(), frame, craftingStacks);
        String ownerName = this.nameAdjectives.get(SilentGems.random.nextInt(this.nameAdjectives.size())) + " " + this.nameNouns.get(SilentGems.random.nextInt(this.nameNouns.size()));
        ToolHelper.setOriginalOwner(temp, TextFormatting.AQUA + ownerName);
        armor.func_77982_d(temp.func_77978_p());
        return temp;
    }
}

