/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.IArmor;
import net.silentchaos512.gems.api.IBlockPlacer;
import net.silentchaos512.gems.api.ITool;
import net.silentchaos512.gems.api.lib.EnumDecoPos;
import net.silentchaos512.gems.api.lib.EnumMaterialGrade;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.api.lib.ToolPartPosition;
import net.silentchaos512.gems.api.tool.ToolStats;
import net.silentchaos512.gems.api.tool.part.ArmorPartFrame;
import net.silentchaos512.gems.api.tool.part.ToolPart;
import net.silentchaos512.gems.api.tool.part.ToolPartMain;
import net.silentchaos512.gems.api.tool.part.ToolPartRegistry;
import net.silentchaos512.gems.api.tool.part.ToolPartRod;
import net.silentchaos512.gems.config.ConfigOptionToolClass;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.config.GemsConfigHC;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.item.ItemGemArrow;
import net.silentchaos512.gems.item.armor.ItemGemArmor;
import net.silentchaos512.gems.item.tool.ItemGemAxe;
import net.silentchaos512.gems.item.tool.ItemGemHoe;
import net.silentchaos512.gems.item.tool.ItemGemPickaxe;
import net.silentchaos512.gems.item.tool.ItemGemShield;
import net.silentchaos512.gems.item.tool.ItemGemShovel;
import net.silentchaos512.gems.item.tool.ItemGemSword;
import net.silentchaos512.gems.lib.Greetings;
import net.silentchaos512.gems.lib.soul.ToolSoul;
import net.silentchaos512.gems.network.NetworkHandler;
import net.silentchaos512.gems.network.message.MessageItemRename;
import net.silentchaos512.gems.skills.SkillAreaMiner;
import net.silentchaos512.gems.skills.SkillAreaTill;
import net.silentchaos512.gems.skills.SkillLumberjack;
import net.silentchaos512.gems.skills.ToolSkill;
import net.silentchaos512.gems.util.PatronColors;
import net.silentchaos512.gems.util.SoulManager;
import net.silentchaos512.gems.util.ToolRandomizer;
import net.silentchaos512.lib.recipe.IngredientSL;
import net.silentchaos512.lib.registry.IRegistryObject;
import net.silentchaos512.lib.util.ItemHelper;
import net.silentchaos512.lib.util.LocalizationHelper;
import net.silentchaos512.lib.util.PlayerHelper;
import net.silentchaos512.lib.util.StackHelper;
import net.silentchaos512.lib.util.WorldHelper;

public class ToolHelper {
    public static final Item.ToolMaterial FAKE_MATERIAL = EnumHelper.addToolMaterial((String)"silentgems:fake_material", (int)1, (int)512, (float)5.12f, (float)5.12f, (int)32);
    public static final int CHECK_NAME_FREQUENCY = 10;
    public static final String NBT_ROOT_CONSTRUCTION = "SGConstruction";
    public static final String NBT_ROOT_DECORATION = "SGDecoration";
    public static final String NBT_ROOT_PROPERTIES = "SGProperties";
    public static final String NBT_ROOT_TOOL_SOUL = "SGToolSoul";
    public static final String NBT_ROOT_STATISTICS = "SGStatistics";
    public static final String NBT_UUID = "SG_UUID";
    public static final String NBT_SOUL_UUID = "SG_SoulUUID";
    public static final String NBT_SETTINGS_SPECIAL = "SpecialEnabled";
    public static final String NBT_LOCK_STATS = "SG_LockStats";
    public static final String NBT_TOOL_TIER = "ToolTier";
    public static final String NBT_TEMP_PARTLIST = "PartListForName";
    public static final String NBT_PROP_DURABILITY = "Durability";
    public static final String NBT_PROP_HARVEST_LEVEL = "HarvestLevel";
    public static final String NBT_PROP_HARVEST_SPEED = "HarvestSpeed";
    public static final String NBT_PROP_MELEE_DAMAGE = "MeleeDamage";
    public static final String NBT_PROP_MAGIC_DAMAGE = "MagicDamage";
    public static final String NBT_PROP_ENCHANTABILITY = "Enchantability";
    public static final String NBT_PROP_MELEE_SPEED = "MeleeSpeed";
    public static final String NBT_PROP_CHARGE_SPEED = "ChargeSpeed";
    public static final String NBT_PROP_PROTECTION = "Protection";
    public static final String NBT_STATS_ORIGINAL_OWNER = "OriginalOwner";
    public static final String NBT_STATS_REDECORATED = "Redecorated";
    public static final String NBT_STATS_BLOCKS_MINED = "BlocksMined";
    public static final String NBT_STATS_BLOCKS_PLACED = "BlocksPlaced";
    public static final String NBT_STATS_BLOCKS_TILLED = "BlocksTilled";
    public static final String NBT_STATS_HITS = "HitsLanded";
    public static final String NBT_STATS_KILL_COUNT = "KillCount";
    public static final String NBT_STATS_PATHS_MADE = "PathsMade";
    public static final String NBT_STATS_SHOTS_FIRED = "ShotsFired";
    public static final String NBT_STATS_SHOTS_LANDED = "ShotsLanded";
    public static final String NBT_STATS_THROWN = "ThrownCount";
    public static final String NBT_EXAMPLE_TOOL = "ExampleToolItem";
    public static final String NBT_EXAMPLE_TOOL_TIER = "ExampleToolTier";
    static boolean foundEmptyPart = false;
    static Set<ToolPartMain> emptyPartSet = Sets.newHashSet();
    static Map<Item, List<ItemStack>> toolSubItems = new HashMap<Item, List<ItemStack>>();
    static int lastRecipeIndex = -1;
    public static List<IRecipe> EXAMPLE_RECIPES = new ArrayList<IRecipe>();

    public static void init() {
    }

    public static void recalculateStats(ItemStack toolOrArmor) {
        ToolHelper.getUUID(toolOrArmor);
        ToolPart[] parts = ToolHelper.getConstructionParts(toolOrArmor);
        if (parts.length == 0) {
            return;
        }
        ToolHelper.clearOldRenderCache(toolOrArmor);
        if (!toolOrArmor.func_77978_p().func_74767_n(NBT_LOCK_STATS)) {
            ToolStats stats = ToolHelper.getStats(toolOrArmor, true);
            String root = NBT_ROOT_PROPERTIES;
            if (toolOrArmor.func_77973_b() instanceof ITool) {
                ToolHelper.setTagFloat(toolOrArmor, root, NBT_PROP_HARVEST_SPEED, stats.harvestSpeed);
                ToolHelper.setTagFloat(toolOrArmor, root, NBT_PROP_MELEE_DAMAGE, stats.meleeDamage);
                ToolHelper.setTagFloat(toolOrArmor, root, NBT_PROP_MAGIC_DAMAGE, stats.magicDamage);
                ToolHelper.setTagFloat(toolOrArmor, root, NBT_PROP_MELEE_SPEED, stats.meleeSpeed);
                ToolHelper.setTagFloat(toolOrArmor, root, NBT_PROP_CHARGE_SPEED, stats.chargeSpeed);
                ToolHelper.setTagInt(toolOrArmor, root, NBT_PROP_HARVEST_LEVEL, stats.harvestLevel);
            }
            ToolHelper.setTagInt(toolOrArmor, root, NBT_PROP_DURABILITY, (int)stats.durability);
            ToolHelper.setTagFloat(toolOrArmor, root, NBT_PROP_PROTECTION, stats.protection);
            ToolHelper.setTagInt(toolOrArmor, root, NBT_PROP_ENCHANTABILITY, (int)stats.enchantability);
            ToolHelper.setTagInt(toolOrArmor, root, NBT_TOOL_TIER, parts[0].getTier().ordinal());
        }
    }

    public static ToolStats getStats(ItemStack toolOrArmor, boolean applySoulModifiers) {
        ToolSoul soul;
        ToolPart[] parts = ToolHelper.getConstructionParts(toolOrArmor);
        EnumMaterialGrade[] grades = ToolHelper.getConstructionGrades(toolOrArmor);
        if (parts.length == 0) {
            return new ToolStats(toolOrArmor);
        }
        ToolStats stats = new ToolStats(toolOrArmor, parts, grades);
        if (toolOrArmor.func_77978_p().func_74767_n(NBT_LOCK_STATS)) {
            stats.chargeSpeed = ToolHelper.getChargeSpeed(toolOrArmor);
            stats.durability = ToolHelper.getMaxDamage(toolOrArmor);
            stats.enchantability = ToolHelper.getItemEnchantability(toolOrArmor);
            stats.harvestLevel = ToolHelper.getHarvestLevel(toolOrArmor);
            stats.harvestSpeed = ToolHelper.getDigSpeedOnProperMaterial(toolOrArmor);
            stats.magicDamage = ToolHelper.getMagicDamage(toolOrArmor);
            stats.meleeDamage = ToolHelper.getMeleeDamage(toolOrArmor);
            stats.meleeSpeed = ToolHelper.getMeleeSpeed(toolOrArmor);
            stats.protection = ToolHelper.getProtection(toolOrArmor);
            return stats;
        }
        stats.calculate();
        if (applySoulModifiers && (soul = SoulManager.getSoul(toolOrArmor)) != null) {
            soul.applyToStats(stats);
        }
        return stats;
    }

    public static void clearOldRenderCache(ItemStack tool) {
        tool.func_77978_p().func_82580_o("SGModel");
    }

    @Nullable
    public static UUID getUUID(ItemStack tool) {
        if (!(tool.func_77973_b() instanceof ITool) && !(tool.func_77973_b() instanceof IArmor)) {
            return null;
        }
        ToolHelper.initRootTag(tool);
        if (!tool.func_77978_p().func_186855_b(NBT_UUID)) {
            UUID uuid = UUID.randomUUID();
            tool.func_77978_p().func_186854_a(NBT_UUID, uuid);
            return uuid;
        }
        return tool.func_77978_p().func_186857_a(NBT_UUID);
    }

    public static boolean hasUUID(ItemStack tool) {
        return StackHelper.isValid((ItemStack)tool) && tool.func_77942_o() && tool.func_77978_p().func_186855_b(NBT_UUID);
    }

    public static boolean isExampleItem(ItemStack tool) {
        return StackHelper.isValid((ItemStack)tool) && tool.func_77942_o() && tool.func_77978_p().func_74767_n(NBT_EXAMPLE_TOOL);
    }

    public static boolean isExampleRecipeOutput(ItemStack tool) {
        return StackHelper.isValid((ItemStack)tool) && tool.func_77942_o() && tool.func_77978_p().func_74767_n(NBT_EXAMPLE_TOOL_TIER);
    }

    public static boolean getIsRepairable(ItemStack toolOrArmor, ItemStack material) {
        EnumMaterialTier tierTool = ToolHelper.getToolTier(toolOrArmor);
        EnumMaterialTier tierMat = EnumMaterialTier.fromStack(material);
        if (tierTool == null || tierMat == null) {
            return false;
        }
        return tierTool.ordinal() <= tierMat.ordinal();
    }

    public static void attemptDamageTool(ItemStack tool, int amount, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer && ((EntityPlayer)entityLiving).field_71075_bZ.field_75098_d) {
            return;
        }
        if (!GemsConfigHC.TOOLS_BREAK) {
            amount = Math.min(tool.func_77958_k() - tool.func_77952_i(), amount);
        }
        boolean wouldBreak = ItemHelper.attemptDamageItem((ItemStack)tool, (int)amount, (Random)SilentGems.random);
        if (ToolHelper.isBroken(tool)) {
            ToolHelper.recalculateStats(tool);
            ModItems.toolRenderHelper.updateModelCache(tool);
        } else if (GemsConfigHC.TOOLS_BREAK && wouldBreak) {
            ToolSoul soul = SoulManager.getSoul(tool);
            if (soul != null) {
                ItemStack toGive = new ItemStack((Item)ModItems.toolSoul);
                ModItems.toolSoul.setSoul(toGive, soul);
                if (soul.hasName()) {
                    toGive.func_151001_c(soul.getName(StackHelper.empty()));
                }
                PlayerHelper.giveItem((EntityPlayer)((EntityPlayer)entityLiving), (ItemStack)toGive);
            }
            entityLiving.func_70669_a(tool);
            StackHelper.shrink((ItemStack)tool, (int)1);
        }
    }

    public static float getDigSpeed(ItemStack tool, IBlockState state, Material[] extraMaterials) {
        if (ToolHelper.isBroken(tool)) {
            return 0.25f;
        }
        float speed = ToolHelper.getDigSpeedOnProperMaterial(tool);
        if (tool.func_77973_b().canHarvestBlock(state, tool)) {
            return speed;
        }
        for (String type : tool.func_77973_b().getToolClasses(tool)) {
            try {
                if (!state.func_177230_c().isToolEffective(type, state)) continue;
                return speed;
            }
            catch (IllegalArgumentException ex) {
                return 1.0f;
            }
        }
        if (extraMaterials != null) {
            for (Material material : extraMaterials) {
                if (state.func_185904_a() != material) continue;
                return speed;
            }
        }
        return 1.0f;
    }

    public static float getDigSpeedOnProperMaterial(ItemStack tool) {
        return ToolHelper.getTagFloat(tool, NBT_ROOT_PROPERTIES, NBT_PROP_HARVEST_SPEED);
    }

    public static float getMeleeSpeed(ItemStack tool) {
        return ToolHelper.getTagFloat(tool, NBT_ROOT_PROPERTIES, NBT_PROP_MELEE_SPEED);
    }

    public static float getMeleeDamage(ItemStack tool) {
        return ToolHelper.getTagFloat(tool, NBT_ROOT_PROPERTIES, NBT_PROP_MELEE_DAMAGE);
    }

    public static float getMagicDamage(ItemStack tool) {
        return ToolHelper.getTagFloat(tool, NBT_ROOT_PROPERTIES, NBT_PROP_MAGIC_DAMAGE);
    }

    public static float getProtection(ItemStack shieldOrArmor) {
        if (ToolHelper.isBroken(shieldOrArmor)) {
            return 0.0f;
        }
        return ToolHelper.getTagFloat(shieldOrArmor, NBT_ROOT_PROPERTIES, NBT_PROP_PROTECTION);
    }

    public static float getMagicProtection(ItemStack shieldOrArmor) {
        float magic = ToolHelper.getMagicDamage(shieldOrArmor);
        float protection = ToolHelper.getProtection(shieldOrArmor);
        return magic / 16.0f + protection / 300.0f;
    }

    public static int getHarvestLevel(ItemStack tool) {
        return ToolHelper.getTagInt(tool, NBT_ROOT_PROPERTIES, NBT_PROP_HARVEST_LEVEL);
    }

    public static int getMaxDamage(ItemStack tool) {
        return ToolHelper.getTagInt(tool, NBT_ROOT_PROPERTIES, NBT_PROP_DURABILITY);
    }

    public static float getChargeSpeed(ItemStack tool) {
        return ToolHelper.getTagFloat(tool, NBT_ROOT_PROPERTIES, NBT_PROP_CHARGE_SPEED);
    }

    public static boolean isBroken(ItemStack tool) {
        if (tool.func_77973_b() instanceof ItemGemArrow) {
            return true;
        }
        if (GemsConfigHC.TOOLS_BREAK) {
            return false;
        }
        int maxDamage = tool.func_77958_k();
        if (StackHelper.isEmpty((ItemStack)tool) || maxDamage <= 0) {
            return false;
        }
        return tool.func_77952_i() >= maxDamage;
    }

    public static boolean hasNoConstruction(ItemStack tool) {
        String key = ToolHelper.getPartId(tool, ToolPartPosition.HEAD.getKey(0));
        return key == null || key.isEmpty();
    }

    public static int getItemEnchantability(ItemStack tool) {
        return ToolHelper.getTagInt(tool, NBT_ROOT_PROPERTIES, NBT_PROP_ENCHANTABILITY);
    }

    public static Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack tool) {
        if (tool.func_77973_b() instanceof ItemTool) {
            String name = "Tool modifier";
        } else {
            String name = "Weapon modifier";
        }
        Multimap map = tool.func_77973_b().func_111205_h(slot);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            String key = SharedMonsterAttributes.field_111264_e.func_111108_a();
            float value = ToolHelper.getMeleeDamageModifier(tool);
            ToolHelper.replaceAttributeModifierInMap((Multimap<String, AttributeModifier>)map, key, value);
            key = SharedMonsterAttributes.field_188790_f.func_111108_a();
            value = ToolHelper.getMeleeSpeedModifier(tool);
            ToolHelper.replaceAttributeModifierInMap((Multimap<String, AttributeModifier>)map, key, value);
        }
        return map;
    }

    private static void replaceAttributeModifierInMap(Multimap<String, AttributeModifier> map, String key, float value) {
        Iterator iter;
        if (map.containsKey((Object)key) && (iter = map.get((Object)key).iterator()).hasNext()) {
            AttributeModifier mod = (AttributeModifier)iter.next();
            map.removeAll((Object)key);
            map.put((Object)key, (Object)new AttributeModifier(mod.func_111167_a(), mod.func_111166_b(), (double)value, mod.func_111169_c()));
        }
    }

    public static float getMeleeDamageModifier(ItemStack tool) {
        if (ToolHelper.isBroken(tool)) {
            return 1.0f;
        }
        float val = tool.func_77973_b() instanceof ITool ? ((ITool)tool.func_77973_b()).getMeleeDamage(tool) : ToolHelper.getMeleeDamage(tool);
        return val < 0.0f ? 0.0f : val;
    }

    public static float getMagicDamageModifier(ItemStack tool) {
        if (ToolHelper.isBroken(tool)) {
            return 0.0f;
        }
        float val = tool.func_77973_b() instanceof ITool ? ((ITool)tool.func_77973_b()).getMagicDamage(tool) : ToolHelper.getMagicDamage(tool);
        return val < 0.0f ? 0.0f : val;
    }

    public static float getMeleeSpeedModifier(ItemStack tool) {
        if (!(tool.func_77973_b() instanceof ITool)) {
            return 0.0f;
        }
        float base = ((ITool)tool.func_77973_b()).getMeleeSpeedModifier();
        float speed = ToolHelper.getMeleeSpeed(tool) + (ToolHelper.isBroken(tool) ? 0.7f : 0.0f);
        return (base + 4.0f) * speed - 4.0f;
    }

    public static EnumActionResult onItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        ItemStack stackOffHand = player.func_184592_cb();
        if (StackHelper.isValid((ItemStack)stackOffHand) && stackOffHand.func_77973_b() instanceof ItemBlock) {
            ItemBlock itemBlock = (ItemBlock)stackOffHand.func_77973_b();
            BlockPos target = pos;
            if (!itemBlock.func_179223_d().func_176200_f((IBlockAccess)world, pos)) {
                target = pos.func_177972_a(side);
            }
            if (player.func_175151_a(target, side, stackOffHand) && WorldHelper.mayPlace((World)world, (Block)itemBlock.func_179223_d(), (BlockPos)target, (boolean)false, (EnumFacing)side, (Entity)player, (ItemStack)stackOffHand)) {
                return EnumActionResult.PASS;
            }
        }
        if (!GemsConfig.RIGHT_CLICK_TO_PLACE_ENABLED) {
            return EnumActionResult.PASS;
        }
        if (GemsConfig.RIGHT_CLICK_TO_PLACE_ON_SNEAK_ONLY && !player.func_70093_af()) {
            return EnumActionResult.PASS;
        }
        if (ToolHelper.isBroken(stack)) {
            return EnumActionResult.PASS;
        }
        EnumActionResult result = EnumActionResult.PASS;
        int toolSlot = player.field_71071_by.field_70461_c;
        int itemSlot = toolSlot + 1;
        ItemStack nextStack = StackHelper.empty();
        ItemStack lastStack = player.field_71071_by.func_70301_a(8);
        if (toolSlot < 8) {
            Item item;
            boolean emptyOrNoPlacingTag;
            nextStack = player.field_71071_by.func_70301_a(itemSlot);
            boolean bl = emptyOrNoPlacingTag = StackHelper.isEmpty((ItemStack)nextStack) || nextStack.func_77942_o() && nextStack.func_77978_p().func_74764_b("NoPlacing");
            if (emptyOrNoPlacingTag || !(nextStack.func_77973_b() instanceof ItemBlock) && !(nextStack.func_77973_b() instanceof IBlockPlacer)) {
                nextStack = lastStack;
                itemSlot = 8;
            }
            boolean bl2 = emptyOrNoPlacingTag = StackHelper.isEmpty((ItemStack)nextStack) || nextStack.func_77942_o() && nextStack.func_77978_p().func_74764_b("NoPlacing");
            if (!emptyOrNoPlacingTag && ((item = nextStack.func_77973_b()) instanceof ItemBlock || item instanceof IBlockPlacer)) {
                BlockPos targetPos = pos.func_177972_a(side);
                int playerX = (int)Math.floor(player.field_70165_t);
                int playerY = (int)Math.floor(player.field_70163_u);
                int playerZ = (int)Math.floor(player.field_70161_v);
                if (item instanceof ItemBlock) {
                    int px = targetPos.func_177958_n();
                    int py = targetPos.func_177956_o();
                    int pz = targetPos.func_177952_p();
                    AxisAlignedBB blockBounds = new AxisAlignedBB((double)px, (double)py, (double)pz, (double)(px + 1), (double)(py + 1), (double)(pz + 1));
                    AxisAlignedBB playerBounds = player.func_174813_aQ();
                    ItemBlock itemBlock = (ItemBlock)item;
                    Block block = itemBlock.func_179223_d();
                    IBlockState state = block.func_176203_a(itemBlock.getMetadata(nextStack));
                    if (state.func_185904_a().func_76230_c() && playerBounds.func_72326_a(blockBounds)) {
                        return EnumActionResult.FAIL;
                    }
                }
                int prevSize = StackHelper.getCount((ItemStack)nextStack);
                result = ItemHelper.useItemAsPlayer((ItemStack)nextStack, (EntityPlayer)player, (World)world, (BlockPos)pos, (EnumFacing)side, (float)hitX, (float)hitY, (float)hitZ);
                if (player.field_71075_bZ.field_75098_d) {
                    StackHelper.setCount((ItemStack)nextStack, (int)prevSize);
                }
                if (StackHelper.isEmpty((ItemStack)nextStack)) {
                    nextStack = StackHelper.empty();
                    player.field_71071_by.func_70299_a(itemSlot, StackHelper.empty());
                }
            }
        }
        if (result == EnumActionResult.SUCCESS) {
            ToolHelper.incrementStatBlocksPlaced(stack, 1);
        }
        return result;
    }

    @Nullable
    public static ToolSkill getSuperSkill(ItemStack tool) {
        if (ToolHelper.getToolTier(tool).ordinal() < EnumMaterialTier.SUPER.ordinal()) {
            return null;
        }
        Item item = tool.func_77973_b();
        if (item instanceof ItemGemPickaxe || item instanceof ItemGemShovel) {
            return SkillAreaMiner.INSTANCE;
        }
        if (item instanceof ItemGemAxe) {
            return GemsConfig.SWITCH_AXE_SUPER ? SkillAreaMiner.INSTANCE : SkillLumberjack.INSTANCE;
        }
        if (item instanceof ItemGemHoe) {
            return SkillAreaTill.INSTANCE;
        }
        return null;
    }

    public static boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        boolean abilityActivated = false;
        ToolSkill skill = ToolHelper.getSuperSkill(stack);
        if (skill != null) {
            skill.activate(stack, player, pos);
        }
        ToolHelper.incrementStatBlocksMined(stack, 1);
        if (player != null && !player.field_70170_p.field_72995_K) {
            IBlockState stateMined = player.field_70170_p.func_180495_p(pos);
            ToolSoul soul = SoulManager.getSoul(stack);
            if (soul != null) {
                int xpForBlockHarvest = soul.getXpForBlockHarvest(player.field_70170_p, pos, stateMined);
                SoulManager.addSoulXp(xpForBlockHarvest, stack, player);
            }
        }
        return false;
    }

    public static boolean onBlockDestroyed(ItemStack tool, World world, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        boolean isSickle;
        boolean bl = isSickle = tool.func_77973_b() == ModItems.sickle;
        if ((isSickle || state.func_185887_b(world, pos) != 0.0f) && !ToolHelper.isBroken(tool) && state.func_185904_a() != Material.field_151584_j) {
            ToolHelper.attemptDamageTool(tool, isSickle ? 2 : 1, entityLiving);
            if (ToolHelper.isBroken(tool)) {
                entityLiving.func_70669_a(tool);
            }
        }
        return true;
    }

    public static boolean hitEntity(ItemStack tool, EntityLivingBase target, EntityLivingBase attacker) {
        ToolHelper.incrementStatHitsLanded(tool, 1);
        boolean isSword = tool.func_77973_b() instanceof ItemGemSword;
        boolean isShield = tool.func_77973_b() instanceof ItemGemShield;
        boolean isTool = tool.func_77973_b() instanceof ItemTool || tool.func_77973_b() instanceof ItemGemHoe;
        boolean isBroken = ToolHelper.isBroken(tool);
        if (!isBroken) {
            int currentDmg = tool.func_77952_i();
            int maxDmg = tool.func_77958_k();
            ToolHelper.attemptDamageTool(tool, isTool ? 2 : (isSword || isShield ? 1 : 0), attacker);
            if (ToolHelper.isBroken(tool)) {
                attacker.func_70669_a(tool);
            }
        }
        return !isBroken && isTool;
    }

    public static void onUpdate(ItemStack toolOrArmor, World world, Entity entity, int itemSlot, boolean isSelected) {
        ToolSoul soul;
        if (entity instanceof EntityPlayer && (soul = SoulManager.getSoul(toolOrArmor)) != null) {
            soul.updateTick(toolOrArmor, (EntityPlayer)entity);
        }
        if (!world.field_72995_K) {
            if (ToolHelper.hasNoConstruction(toolOrArmor)) {
                soul = ToolRandomizer.INSTANCE.randomize(toolOrArmor);
            }
            if (ToolHelper.isExampleItem(toolOrArmor)) {
                toolOrArmor.func_77978_p().func_82580_o(NBT_EXAMPLE_TOOL);
            }
            ToolHelper.initRootTag(toolOrArmor);
            if (!ToolHelper.hasUUID(toolOrArmor)) {
                toolOrArmor.func_77978_p().func_186854_a(NBT_UUID, UUID.randomUUID());
            }
            return;
        }
        if (world.func_82737_E() % 10L == 0L && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (toolOrArmor.func_77942_o() && toolOrArmor.func_77978_p().func_74764_b(NBT_TEMP_PARTLIST)) {
                NBTTagCompound compound = toolOrArmor.func_77978_p().func_74775_l(NBT_TEMP_PARTLIST);
                int i = 0;
                String key = "part" + i;
                ArrayList parts = Lists.newArrayList();
                do {
                    NBTTagCompound tag = compound.func_74775_l(key);
                    parts.add(StackHelper.loadFromNBT((NBTTagCompound)tag));
                } while (compound.func_74764_b(key = "part" + ++i));
                String displayName = ToolHelper.createToolName(toolOrArmor.func_77973_b(), parts);
                MessageItemRename message = new MessageItemRename(player.func_70005_c_(), itemSlot, displayName, toolOrArmor);
                String line = String.format("%s crafted \"%s\"", player.func_70005_c_(), displayName);
                SilentGems.logHelper.info((Object)line);
                NetworkHandler.INSTANCE.sendToServer((IMessage)message);
            }
        }
    }

    public static boolean onEntityItemUpdate(EntityItem entityItem) {
        if (entityItem.field_70170_p.func_180495_p(new BlockPos((Entity)entityItem)).func_185904_a() == Material.field_151587_i) {
            entityItem.field_70159_w = 0.0;
            entityItem.field_70181_x = 0.2;
            entityItem.field_70179_y = 0.0;
            entityItem.func_174868_q();
            return true;
        }
        return false;
    }

    public static boolean isSpecialAbilityEnabled(ItemStack tool) {
        return ToolHelper.getTagBoolean(tool, NBT_ROOT_PROPERTIES, NBT_SETTINGS_SPECIAL);
    }

    public static void toggleSpecialAbility(ItemStack tool) {
        ToolHelper.setTagBoolean(tool, NBT_ROOT_PROPERTIES, NBT_SETTINGS_SPECIAL, !ToolHelper.getTagBoolean(tool, NBT_ROOT_PROPERTIES, NBT_SETTINGS_SPECIAL));
    }

    public static EnumMaterialTier getToolTier(ItemStack tool) {
        int id = ToolHelper.getTagInt(tool, NBT_ROOT_PROPERTIES, NBT_TOOL_TIER);
        return EnumMaterialTier.values()[MathHelper.func_76125_a((int)id, (int)0, (int)(EnumMaterialTier.values().length - 1))];
    }

    public static ItemStack constructTool(Item item, ItemStack rod, ItemStack head, int headCount) {
        ItemStack[] mats = new ItemStack[headCount];
        for (int i = 0; i < headCount; ++i) {
            mats[i] = head;
        }
        return ToolHelper.constructTool(item, rod, mats);
    }

    public static ItemStack constructTool(Item item, ItemStack rod, ItemStack ... materials) {
        if (materials.length == 1) {
            ItemStack[] newMats = new ItemStack[3];
            for (int i = 0; i < newMats.length; ++i) {
                newMats[i] = materials[0];
            }
            materials = newMats;
        }
        ItemStack result = new ItemStack(item);
        result.func_77982_d(new NBTTagCompound());
        result.func_77978_p().func_74782_a(NBT_TEMP_PARTLIST, (NBTBase)new NBTTagCompound());
        for (int i = 0; i < materials.length; ++i) {
            if (StackHelper.isEmpty((ItemStack)materials[i])) {
                String str = "ToolHelper.constructTool: empty part! ";
                for (ItemStack stack : materials) {
                    str = str + stack + ", ";
                }
                throw new IllegalArgumentException(str);
            }
            ToolPart part = ToolPartRegistry.fromStack(materials[i]);
            EnumMaterialGrade grade = EnumMaterialGrade.fromStack(materials[i]);
            ToolHelper.setTagPart(result, ToolPartPosition.HEAD.getKey(i), part, grade);
            result.func_77978_p().func_74775_l(NBT_TEMP_PARTLIST).func_74782_a("part" + i, (NBTBase)materials[i].func_77955_b(new NBTTagCompound()));
        }
        ToolPart part = ToolPartRegistry.fromStack(rod);
        if (part == null) {
            return StackHelper.empty();
        }
        ToolHelper.setTagPart(result, ToolPartPosition.ROD.getKey(0), part, EnumMaterialGrade.NONE);
        String displayName = ToolHelper.createToolName(item, materials);
        result.func_151001_c(displayName);
        ToolHelper.recalculateStats(result);
        EnumMaterialTier toolTier = ToolHelper.getToolTier(result);
        if (item instanceof ITool && !((ITool)item).getValidTiers().contains((Object)toolTier)) {
            return StackHelper.empty();
        }
        return result;
    }

    public static String createToolName(Item item, ItemStack[] materials) {
        return ToolHelper.createToolName(item, Lists.newArrayList((Object[])materials));
    }

    public static String createToolName(Item item, List<ItemStack> materials) {
        LocalizationHelper loc = SilentGems.localizationHelper;
        LinkedHashSet prefixSet = Sets.newLinkedHashSet();
        LinkedHashSet materialSet = Sets.newLinkedHashSet();
        for (ItemStack stack : materials) {
            ToolPart part = ToolPartRegistry.fromStack(stack);
            if (!(part instanceof ToolPartMain)) continue;
            String prefix = part.getDisplayNamePrefix(stack);
            if (prefix != null && !prefix.isEmpty()) {
                prefixSet.add(prefix);
            }
            materialSet.add(part.getDisplayName(stack));
        }
        String prefix = String.join((CharSequence)" ", prefixSet);
        if (!prefix.isEmpty()) {
            prefix = prefix + " ";
        }
        String delimiter = loc.getLocalizedString("tool.silentgems:delimiter", new Object[0]);
        String materialName = String.join((CharSequence)delimiter, materialSet);
        String toolName = ((IRegistryObject)item).getName();
        String name = loc.getLocalizedString("tool", toolName, new Object[]{materialName});
        return prefix + name;
    }

    public static ToolPart[] getConstructionParts(ItemStack tool) {
        String key;
        if (StackHelper.isEmpty((ItemStack)tool)) {
            return new ToolPart[0];
        }
        ArrayList parts = Lists.newArrayList();
        int index = -1;
        do {
            ToolPart part;
            if ((key = ToolHelper.getPartId(tool, ToolPartPosition.HEAD.getKey(++index))) == null || (part = ToolPartRegistry.getPart(key)) == null) continue;
            parts.add(part);
        } while (key != null && !key.isEmpty());
        return parts.toArray(new ToolPart[parts.size()]);
    }

    public static EnumMaterialGrade[] getConstructionGrades(ItemStack tool) {
        String key;
        if (StackHelper.isEmpty((ItemStack)tool)) {
            return new EnumMaterialGrade[0];
        }
        ArrayList grades = Lists.newArrayList();
        int index = -1;
        do {
            if ((key = ToolHelper.getPartId(tool, ToolPartPosition.HEAD.getKey(++index))) == null) continue;
            grades.add(ToolHelper.getPartGrade(tool, ToolPartPosition.HEAD.getKey(index)));
        } while (key != null && !key.isEmpty());
        return grades.toArray(new EnumMaterialGrade[grades.size()]);
    }

    public static ToolPart getConstructionRod(ItemStack tool) {
        String key = ToolHelper.getPartId(tool, ToolPartPosition.ROD.getKey(0));
        return ToolPartRegistry.getPart(key);
    }

    public static ToolPart getConstructionTip(ItemStack tool) {
        return ToolHelper.getPart(tool, ToolPartPosition.TIP);
    }

    public static void setConstructionTip(ItemStack tool, ToolPart part) {
        ToolHelper.setTagPart(tool, ToolPartPosition.TIP.getKey(0), part, EnumMaterialGrade.NONE);
    }

    public static ItemStack decorateTool(ItemStack tool, ItemStack west, ItemStack north, ItemStack east, ItemStack south) {
        if (StackHelper.isEmpty((ItemStack)tool)) {
            return StackHelper.empty();
        }
        ItemStack result = tool.func_77946_l();
        result = ToolHelper.decorate(result, west, EnumDecoPos.WEST);
        result = ToolHelper.decorate(result, north, EnumDecoPos.NORTH);
        result = ToolHelper.decorate(result, east, EnumDecoPos.EAST);
        result = ToolHelper.decorate(result, south, EnumDecoPos.SOUTH);
        return result;
    }

    private static ItemStack decorate(ItemStack tool, ItemStack material, EnumDecoPos pos) {
        ToolPartRod partRod;
        if (StackHelper.isEmpty((ItemStack)tool)) {
            return StackHelper.empty();
        }
        if (StackHelper.isEmpty((ItemStack)material)) {
            return tool;
        }
        if (tool.func_77973_b() instanceof ItemGemShield) {
            if (pos == EnumDecoPos.NORTH) {
                pos = EnumDecoPos.SOUTH;
            } else if (pos == EnumDecoPos.EAST) {
                pos = EnumDecoPos.NORTH;
            } else if (pos == EnumDecoPos.SOUTH) {
                pos = EnumDecoPos.EAST;
            }
        }
        if (!(pos != EnumDecoPos.SOUTH || tool.func_77973_b() instanceof ItemGemShield || (partRod = (ToolPartRod)ToolHelper.getConstructionRod(tool)) != null && partRod.supportsDecoration())) {
            return tool;
        }
        ToolPart part = ToolPartRegistry.fromDecoStack(material);
        if (part == null) {
            return null;
        }
        if (!(part instanceof ToolPartMain)) {
            return tool;
        }
        ItemStack result = StackHelper.safeCopy((ItemStack)tool);
        ToolHelper.setTagPart(result, pos.nbtKey, part, EnumMaterialGrade.fromStack(material));
        return result;
    }

    public static List<ItemStack> getSubItems(Item item, int materialLength) {
        if (toolSubItems.containsKey(item)) {
            return toolSubItems.get(item);
        }
        ArrayList list = Lists.newArrayList();
        ItemStack rodWood = new ItemStack(Items.field_151055_y);
        ItemStack rodIron = ModItems.craftingMaterial.toolRodIron;
        ItemStack rodGold = ModItems.craftingMaterial.toolRodGold;
        for (ToolPartMain part : ToolPartRegistry.getMains()) {
            if (StackHelper.isEmpty((ItemStack)part.getCraftingStack())) {
                if (emptyPartSet.contains(part)) continue;
                emptyPartSet.add(part);
                SilentGems.logHelper.severe((Object)("Part with empty crafting stack: " + part));
                if (!foundEmptyPart) {
                    Greetings.addExtraMessage(TextFormatting.RED + "Errored tool part found! Please report this issue on the GitHub issue tracker.");
                    foundEmptyPart = true;
                }
                Greetings.addExtraMessage(TextFormatting.ITALIC + part.toString());
                continue;
            }
            if (part.isBlacklisted(part.getCraftingStack()) || item instanceof ITool && !((ITool)item).getValidTiers().contains((Object)part.getTier())) continue;
            ItemStack rod = part.getTier() == EnumMaterialTier.SUPER ? rodGold : (item instanceof ItemGemShield && part.getTier() == EnumMaterialTier.REGULAR ? rodIron : rodWood);
            ItemStack tool = ToolHelper.constructTool(item, rod, part.getCraftingStack());
            tool.func_77978_p().func_74757_a(NBT_EXAMPLE_TOOL, true);
            list.add(tool);
        }
        String makerName = SilentGems.localizationHelper.getMiscText("Tooltip.OriginalOwner.Creative", new Object[0]);
        for (ItemStack stack : list) {
            ToolHelper.setOriginalOwner(stack, makerName);
        }
        toolSubItems.put(item, list);
        return list;
    }

    public static boolean areToolsEqual(ItemStack a, ItemStack b) {
        return a.func_77969_a(b) && ToolHelper.getUUID(a).equals(ToolHelper.getUUID(b));
    }

    public static void addExampleRecipe(Item item, String ... lines) {
        ToolHelper.addExampleRecipe(item, EnumMaterialTier.values(), lines, new Object[0]);
    }

    public static void addExampleRecipe(Item item, EnumMaterialTier tier, String[] lines, Object ... extraParams) {
        ToolHelper.addExampleRecipe(item, new EnumMaterialTier[]{tier}, lines, extraParams);
    }

    public static void addExampleRecipe(Item item, EnumMaterialTier[] tiers, String[] lines, Object ... extraParams) {
        ConfigOptionToolClass config = item instanceof ITool ? ((ITool)item).getConfig() : null;
        for (EnumMaterialTier tier : tiers) {
            if (config != null && !config.validTiers.contains((Object)tier)) continue;
            ArrayList<ItemStack> heads = new ArrayList<ItemStack>();
            for (ToolPart toolPart : ToolPartRegistry.getMains()) {
                if (toolPart.isBlacklisted(toolPart.getCraftingStack()) || toolPart.getTier() != tier || !StackHelper.isValid((ItemStack)toolPart.getCraftingStack())) continue;
                heads.add(toolPart.getCraftingStack());
            }
            IngredientSL headIngredient = IngredientSL.from((ItemStack[])heads.toArray(new ItemStack[0]));
            ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
            for (ToolPart toolPart : ToolPartRegistry.getRods()) {
                if (toolPart.isBlacklisted(toolPart.getCraftingStack()) || !toolPart.getCompatibleTiers().contains((Object)tier)) continue;
                arrayList.add(toolPart.getCraftingStack());
            }
            IngredientSL rodIngredient = IngredientSL.from((ItemStack[])arrayList.toArray(new ItemStack[0]));
            ArrayList<ItemStack> arrayList2 = new ArrayList<ItemStack>();
            if (item instanceof ItemGemArmor) {
                EntityEquipmentSlot slot = ((ItemGemArmor)item).field_77881_a;
                for (ToolPart part : ToolPartRegistry.getValues()) {
                    if (!(part instanceof ArmorPartFrame) || ((ArmorPartFrame)part).getSlot() != slot || part.getTier() != tier || part.isBlacklisted(part.getCraftingStack())) continue;
                    arrayList2.add(part.getCraftingStack());
                }
            }
            IngredientSL frameIngredient = IngredientSL.from((ItemStack[])arrayList2.toArray(new ItemStack[0]));
            ResourceLocation recipeName = new ResourceLocation(item.getRegistryName().toString() + "_" + tier.name().toLowerCase() + "_example");
            ItemStack result = new ItemStack(item);
            NBTTagCompound tags = new NBTTagCompound();
            tags.func_74768_a(NBT_EXAMPLE_TOOL_TIER, tier.ordinal());
            result.func_77982_d(tags);
            ArrayList<Object> params = new ArrayList<Object>();
            for (String line : lines) {
                params.add(line);
            }
            if (ToolHelper.recipeContainsKey(lines, "h")) {
                params.add(Character.valueOf('h'));
                params.add(headIngredient);
            }
            if (ToolHelper.recipeContainsKey(lines, "r")) {
                params.add(Character.valueOf('r'));
                params.add(rodIngredient);
            }
            if (ToolHelper.recipeContainsKey(lines, "a")) {
                params.add(Character.valueOf('a'));
                params.add(frameIngredient);
            }
            for (Object obj : extraParams) {
                params.add(obj);
            }
            EXAMPLE_RECIPES.add(SilentGems.registry.recipes.makeShaped(recipeName.func_110623_a(), result, params.toArray()));
        }
    }

    private static boolean recipeContainsKey(String[] lines, String c) {
        for (String line : lines) {
            if (!line.contains(c)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static UUID getSoulUUID(ItemStack toolOrArmor) {
        if (!(toolOrArmor.func_77973_b() instanceof ITool) && !(toolOrArmor.func_77973_b() instanceof IArmor)) {
            return null;
        }
        ToolHelper.initRootTag(toolOrArmor);
        if (!toolOrArmor.func_77978_p().func_186855_b(NBT_SOUL_UUID)) {
            return null;
        }
        return toolOrArmor.func_77978_p().func_186857_a(NBT_SOUL_UUID);
    }

    public static void setRandomSoulUUID(ItemStack toolOrArmor) {
        ToolHelper.initRootTag(toolOrArmor);
        toolOrArmor.func_77978_p().func_186854_a(NBT_SOUL_UUID, UUID.randomUUID());
    }

    static NBTTagCompound getRootTag(ItemStack tool, String key) {
        if (!(tool.func_77973_b() instanceof ITool) && !(tool.func_77973_b() instanceof IArmor)) {
            return new NBTTagCompound();
        }
        if (key != null && !key.isEmpty()) {
            if (!tool.func_77978_p().func_74764_b(key)) {
                tool.func_77978_p().func_74782_a(key, (NBTBase)new NBTTagCompound());
            }
            return tool.func_77978_p().func_74775_l(key);
        }
        return tool.func_77978_p();
    }

    static void initRootTag(ItemStack tool) {
        if (!tool.func_77942_o()) {
            tool.func_77982_d(new NBTTagCompound());
        }
    }

    private static int getTagInt(ItemStack tool, String root, String name) {
        if (!tool.func_77942_o()) {
            return 0;
        }
        return ToolHelper.getRootTag(tool, root).func_74762_e(name);
    }

    private static int getTagInt(ItemStack tool, String root, String name, int defaultValue) {
        if (!tool.func_77942_o() || !ToolHelper.getRootTag(tool, root).func_74764_b(name)) {
            return defaultValue;
        }
        return ToolHelper.getRootTag(tool, root).func_74762_e(name);
    }

    private static void setTagInt(ItemStack tool, String root, String name, int value) {
        ToolHelper.initRootTag(tool);
        ToolHelper.getRootTag(tool, root).func_74768_a(name, value);
    }

    private static float getTagFloat(ItemStack tool, String root, String name) {
        if (!tool.func_77942_o()) {
            return 0.0f;
        }
        return ToolHelper.getRootTag(tool, root).func_74760_g(name);
    }

    private static void setTagFloat(ItemStack tool, String root, String name, float value) {
        ToolHelper.initRootTag(tool);
        ToolHelper.getRootTag(tool, root).func_74776_a(name, value);
    }

    private static boolean getTagBoolean(ItemStack tool, String root, String name) {
        if (!tool.func_77942_o()) {
            return false;
        }
        return ToolHelper.getRootTag(tool, root).func_74767_n(name);
    }

    private static void setTagBoolean(ItemStack tool, String root, String name, boolean value) {
        ToolHelper.initRootTag(tool);
        ToolHelper.getRootTag(tool, root).func_74757_a(name, value);
    }

    private static String getTagString(ItemStack tool, String root, String name) {
        if (!tool.func_77942_o()) {
            return "";
        }
        return ToolHelper.getRootTag(tool, root).func_74779_i(name);
    }

    private static void setTagString(ItemStack tool, String root, String name, String value) {
        ToolHelper.initRootTag(tool);
        ToolHelper.getRootTag(tool, root).func_74778_a(name, value);
    }

    private static void setTagPart(ItemStack tool, String name, ToolPart part, EnumMaterialGrade grade) {
        ToolHelper.initRootTag(tool);
        ToolHelper.getRootTag(tool, NBT_ROOT_CONSTRUCTION).func_74778_a(name, part.getKey() + "#" + grade.name());
    }

    public static String getPartId(ItemStack tool, String key) {
        if (!tool.func_77942_o()) {
            return null;
        }
        return ToolHelper.getRootTag(tool, NBT_ROOT_CONSTRUCTION).func_74779_i(key).split("#")[0];
    }

    public static EnumMaterialGrade getPartGrade(ItemStack tool, String key) {
        if (!tool.func_77942_o()) {
            return null;
        }
        String[] array = ToolHelper.getRootTag(tool, NBT_ROOT_CONSTRUCTION).func_74779_i(key).split("#");
        if (array.length < 2) {
            return EnumMaterialGrade.NONE;
        }
        return EnumMaterialGrade.fromString(array[1]);
    }

    public static ToolPart getPart(ItemStack tool, ToolPartPosition pos) {
        String key = ToolHelper.getPartId(tool, pos.getKey(0));
        if (key == null || key.isEmpty()) {
            return null;
        }
        return ToolPartRegistry.getPart(key);
    }

    public static void setPart(ItemStack tool, ToolPart part, EnumMaterialGrade grade, ToolPartPosition pos) {
        ToolHelper.setTagPart(tool, pos.getKey(0), part, grade);
    }

    public static ToolPart getRenderPart(ItemStack tool, ToolPartPosition pos) {
        String key = ToolHelper.getPartId(tool, pos.getDecoKey());
        if (key == null || key.isEmpty()) {
            return ToolHelper.getPart(tool, pos);
        }
        return ToolPartRegistry.getPart(key);
    }

    public static void setRenderPart(ItemStack tool, ToolPart part, EnumMaterialGrade grade, ToolPartPosition pos) {
        if (!part.validForToolOfTier(ToolHelper.getToolTier(tool))) {
            return;
        }
        ToolHelper.setTagPart(tool, pos.getDecoKey(), part, grade);
    }

    public static String getOriginalOwner(ItemStack tool) {
        return ToolHelper.getTagString(tool, NBT_ROOT_STATISTICS, NBT_STATS_ORIGINAL_OWNER);
    }

    public static void setOriginalOwner(ItemStack tool, EntityPlayer player) {
        ToolHelper.setOriginalOwner(tool, player.func_70005_c_());
    }

    public static void setOriginalOwner(ItemStack tool, String name) {
        if (ToolHelper.getOriginalOwner(tool).isEmpty()) {
            name = name.equals("SilentChaos512") ? TextFormatting.RED + name : (name.equals("M4thG33k") ? TextFormatting.GREEN + name : (name.equals("ChaoticPlayz") ? TextFormatting.BLUE + name : (name.equals("Guide Book") ? TextFormatting.AQUA + name : PatronColors.instance.getColor(name) + name)));
            ToolHelper.setTagString(tool, NBT_ROOT_STATISTICS, NBT_STATS_ORIGINAL_OWNER, name);
        }
    }

    public static int getStatBlocksMined(ItemStack tool) {
        return ToolHelper.getTagInt(tool, NBT_ROOT_STATISTICS, NBT_STATS_BLOCKS_MINED);
    }

    public static void incrementStatBlocksMined(ItemStack tool, int amount) {
        ToolHelper.setTagInt(tool, NBT_ROOT_STATISTICS, NBT_STATS_BLOCKS_MINED, ToolHelper.getStatBlocksMined(tool) + amount);
    }

    public static int getStatBlocksPlaced(ItemStack tool) {
        return ToolHelper.getTagInt(tool, NBT_ROOT_STATISTICS, NBT_STATS_BLOCKS_PLACED);
    }

    public static void incrementStatBlocksPlaced(ItemStack tool, int amount) {
        ToolHelper.setTagInt(tool, NBT_ROOT_STATISTICS, NBT_STATS_BLOCKS_PLACED, ToolHelper.getStatBlocksPlaced(tool) + amount);
    }

    public static int getStatBlocksTilled(ItemStack tool) {
        return ToolHelper.getTagInt(tool, NBT_ROOT_STATISTICS, NBT_STATS_BLOCKS_TILLED);
    }

    public static void incrementStatBlocksTilled(ItemStack tool, int amount) {
        ToolHelper.setTagInt(tool, NBT_ROOT_STATISTICS, NBT_STATS_BLOCKS_TILLED, ToolHelper.getStatBlocksTilled(tool) + amount);
    }

    public static int getStatPathsMade(ItemStack tool) {
        return ToolHelper.getTagInt(tool, NBT_ROOT_STATISTICS, NBT_STATS_PATHS_MADE);
    }

    public static void incrementStatPathsMade(ItemStack tool, int amount) {
        ToolHelper.setTagInt(tool, NBT_ROOT_STATISTICS, NBT_STATS_PATHS_MADE, ToolHelper.getStatPathsMade(tool) + amount);
    }

    public static int getStatHitsLanded(ItemStack tool) {
        return ToolHelper.getTagInt(tool, NBT_ROOT_STATISTICS, NBT_STATS_HITS);
    }

    public static void incrementStatHitsLanded(ItemStack tool, int amount) {
        ToolHelper.setTagInt(tool, NBT_ROOT_STATISTICS, NBT_STATS_HITS, ToolHelper.getStatHitsLanded(tool) + amount);
    }

    public static int getStatKillCount(ItemStack tool) {
        return ToolHelper.getTagInt(tool, NBT_ROOT_STATISTICS, NBT_STATS_KILL_COUNT);
    }

    public static void incrementStatKillCount(ItemStack tool, int amount) {
        ToolHelper.setTagInt(tool, NBT_ROOT_STATISTICS, NBT_STATS_KILL_COUNT, ToolHelper.getStatKillCount(tool) + amount);
    }

    public static int getStatRedecorated(ItemStack tool) {
        return ToolHelper.getTagInt(tool, NBT_ROOT_STATISTICS, NBT_STATS_REDECORATED);
    }

    public static void incrementStatRedecorated(ItemStack tool, int amount) {
        ToolHelper.setTagInt(tool, NBT_ROOT_STATISTICS, NBT_STATS_REDECORATED, ToolHelper.getStatRedecorated(tool) + amount);
    }

    public static int getStatShotsFired(ItemStack tool) {
        return ToolHelper.getTagInt(tool, NBT_ROOT_STATISTICS, NBT_STATS_SHOTS_FIRED);
    }

    public static void incrementStatShotsFired(ItemStack tool, int amount) {
        ToolHelper.setTagInt(tool, NBT_ROOT_STATISTICS, NBT_STATS_SHOTS_FIRED, ToolHelper.getStatShotsFired(tool) + amount);
    }

    public static int getStatShotsLanded(ItemStack tool) {
        return ToolHelper.getTagInt(tool, NBT_ROOT_STATISTICS, NBT_STATS_SHOTS_LANDED);
    }

    public static void incrementStatShotsLanded(ItemStack tool, int amount) {
        ToolHelper.setTagInt(tool, NBT_ROOT_STATISTICS, NBT_STATS_SHOTS_FIRED, ToolHelper.getStatShotsLanded(tool) + amount);
    }

    public static int getStatThrownCount(ItemStack tool) {
        return ToolHelper.getTagInt(tool, NBT_ROOT_STATISTICS, NBT_STATS_THROWN);
    }

    public static void incrementStatThrownCount(ItemStack tool, int amount) {
        ToolHelper.setTagInt(tool, NBT_ROOT_STATISTICS, NBT_STATS_THROWN, ToolHelper.getStatThrownCount(tool) + amount);
    }
}

