/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.util;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.silentchaos512.gems.api.lib.ArmorPartPosition;
import net.silentchaos512.gems.api.lib.EnumDecoPos;
import net.silentchaos512.gems.api.lib.EnumMaterialGrade;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.api.tool.part.ToolPart;
import net.silentchaos512.gems.api.tool.part.ToolPartMain;
import net.silentchaos512.gems.api.tool.part.ToolPartRegistry;
import net.silentchaos512.gems.item.ToolRenderHelper;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.lib.util.StackHelper;

public class ArmorHelper {
    public static final int PROTECTION_CAP = 39;
    public static final String NBT_ROOT_CONSTRUCTION = "SGConstruction";
    public static final String NBT_ROOT_DECORATION = "SGDecoration";
    public static final String NBT_ROOT_PROPERTIES = "SGProperties";
    public static final String NBT_ROOT_STATISTICS = "SGStatistics";
    public static final String NBT_ARMOR_TIER = "ArmorTier";
    public static final String NBT_PROP_DURABILITY = "Durability";
    public static final String NBT_PROP_PROTECTION = "Protection";
    public static final String NBT_PROP_ENCHANTABILITY = "Enchantability";
    public static final String NBT_STATS_ORIGINAL_OWNER = "OriginalOwner";
    public static final String NBT_STATS_REDECORATED = "Redecorated";
    public static final String NBT_STATS_DAMAGE_TAKEN = "DamageTaken";

    public static void recalculateStats(ItemStack armor) {
        ToolHelper.recalculateStats(armor);
    }

    public static float getProtection(ItemStack armor) {
        return ToolHelper.getProtection(armor);
    }

    public static int getItemEnchantability(ItemStack armor) {
        return ToolHelper.getItemEnchantability(armor);
    }

    public static int getMaxDamage(ItemStack armor) {
        return ToolHelper.getMaxDamage(armor);
    }

    public static boolean isBroken(ItemStack armor) {
        return ToolHelper.isBroken(armor);
    }

    public static EnumMaterialTier getArmorTier(ItemStack armor) {
        return ToolHelper.getToolTier(armor);
    }

    public static ToolPart[] getConstructionParts(ItemStack armor) {
        return ToolHelper.getConstructionParts(armor);
    }

    public static EnumMaterialGrade[] getConstructionGrades(ItemStack armor) {
        return ToolHelper.getConstructionGrades(armor);
    }

    public static ToolPart getPart(ItemStack armor, ArmorPartPosition pos) {
        String key = ArmorHelper.getPartId(armor, pos.getKey(0));
        if (key == null || key.isEmpty()) {
            return null;
        }
        return ToolPartRegistry.getPart(key);
    }

    public static ToolPart getRenderPart(ItemStack armor, ArmorPartPosition pos) {
        String key = ArmorHelper.getPartId(armor, pos.getDecoKey());
        if (key == null || key.isEmpty()) {
            return ArmorHelper.getPart(armor, pos);
        }
        return ToolPartRegistry.getPart(key);
    }

    public static int getRenderColor(ItemStack armor, ArmorPartPosition pos) {
        return ToolRenderHelper.getInstance().getColor(armor, pos);
    }

    public static int[] getRenderColorList(ItemStack armor) {
        int[] values = new int[EnumDecoPos.values().length];
        for (ArmorPartPosition pos : ArmorPartPosition.values()) {
            values[pos.ordinal()] = ArmorHelper.getRenderColor(armor, pos);
        }
        return values;
    }

    public static String getRenderColorString(ItemStack stack) {
        int[] colors;
        StringBuilder toReturn = new StringBuilder();
        for (int color : colors = ArmorHelper.getRenderColorList(stack)) {
            toReturn.append(color);
        }
        return toReturn.toString();
    }

    public static String getPartId(ItemStack tool, String key) {
        if (!tool.func_77942_o()) {
            return null;
        }
        return ArmorHelper.getRootTag(tool, NBT_ROOT_CONSTRUCTION).func_74779_i(key).split("#")[0];
    }

    public static EnumMaterialGrade getPartGrade(ItemStack tool, String key) {
        if (!tool.func_77942_o()) {
            return null;
        }
        String[] array = ArmorHelper.getRootTag(tool, NBT_ROOT_CONSTRUCTION).func_74779_i(key).split("#");
        if (array.length < 2) {
            return EnumMaterialGrade.NONE;
        }
        return EnumMaterialGrade.fromString(array[1]);
    }

    public static ItemStack constructArmor(Item item, ItemStack frame, ItemStack ... materials) {
        if (materials.length == 1) {
            ItemStack[] newMats = new ItemStack[4];
            for (int i = 0; i < newMats.length; ++i) {
                newMats[i] = materials[0];
            }
            materials = newMats;
        }
        ItemStack result = new ItemStack(item);
        result.func_77982_d(new NBTTagCompound());
        result.func_77978_p().func_74782_a("PartListForName", (NBTBase)new NBTTagCompound());
        for (int i = 0; i < materials.length; ++i) {
            if (StackHelper.isEmpty((ItemStack)materials[i])) {
                String str = "ArmorHelper.constructArmor: empty part! ";
                for (ItemStack stack : materials) {
                    str = str + stack + ", ";
                }
                throw new IllegalArgumentException(str);
            }
            ToolPart part = ToolPartRegistry.fromStack(materials[i]);
            EnumMaterialGrade grade = EnumMaterialGrade.fromStack(materials[i]);
            ArmorHelper.setTagPart(result, "Part" + i, part, grade);
            result.func_77978_p().func_74775_l("PartListForName").func_74782_a("part" + i, (NBTBase)materials[i].func_77955_b(new NBTTagCompound()));
        }
        ToolPart part = ToolPartRegistry.fromStack(frame);
        if (part != null) {
            ArmorHelper.setTagPart(result, ArmorPartPosition.FRAME.getKey(0), part, EnumMaterialGrade.NONE);
        }
        String displayName = ToolHelper.createToolName(item, materials);
        result.func_151001_c(displayName);
        ArmorHelper.recalculateStats(result);
        return result;
    }

    public static ItemStack decorateArmor(ItemStack armor, ItemStack west, ItemStack north, ItemStack east, ItemStack south) {
        if (StackHelper.isEmpty((ItemStack)armor)) {
            return StackHelper.empty();
        }
        ItemStack result = StackHelper.safeCopy((ItemStack)armor);
        result = ArmorHelper.decorate(result, west, ArmorPartPosition.WEST);
        result = ArmorHelper.decorate(result, north, ArmorPartPosition.NORTH);
        result = ArmorHelper.decorate(result, east, ArmorPartPosition.EAST);
        result = ArmorHelper.decorate(result, south, ArmorPartPosition.SOUTH);
        return result;
    }

    private static ItemStack decorate(ItemStack armor, ItemStack material, ArmorPartPosition pos) {
        if (StackHelper.isEmpty((ItemStack)armor)) {
            return StackHelper.empty();
        }
        if (StackHelper.isEmpty((ItemStack)material)) {
            return armor;
        }
        ToolPart part = ToolPartRegistry.fromDecoStack(material);
        if (part == null) {
            return null;
        }
        if (!(part instanceof ToolPartMain)) {
            return armor;
        }
        ItemStack result = StackHelper.safeCopy((ItemStack)armor);
        ArmorHelper.setTagPart(result, pos.getDecoKey(), part, EnumMaterialGrade.fromStack(material));
        return result;
    }

    private static NBTTagCompound getRootTag(ItemStack tool, String key) {
        if (key != null && !key.isEmpty()) {
            if (!tool.func_77978_p().func_74764_b(key)) {
                tool.func_77978_p().func_74782_a(key, (NBTBase)new NBTTagCompound());
            }
            return tool.func_77978_p().func_74775_l(key);
        }
        return tool.func_77978_p();
    }

    private static void initRootTag(ItemStack tool) {
        if (!tool.func_77942_o()) {
            tool.func_77982_d(new NBTTagCompound());
        }
    }

    private static int getTagInt(ItemStack tool, String root, String name) {
        if (!tool.func_77942_o()) {
            return 0;
        }
        return ArmorHelper.getRootTag(tool, root).func_74762_e(name);
    }

    private static int getTagInt(ItemStack tool, String root, String name, int defaultValue) {
        if (!tool.func_77942_o() || !ArmorHelper.getRootTag(tool, root).func_74764_b(name)) {
            return defaultValue;
        }
        return ArmorHelper.getRootTag(tool, root).func_74762_e(name);
    }

    private static void setTagInt(ItemStack tool, String root, String name, int value) {
        ArmorHelper.initRootTag(tool);
        ArmorHelper.getRootTag(tool, root).func_74768_a(name, value);
    }

    private static float getTagFloat(ItemStack tool, String root, String name) {
        if (!tool.func_77942_o()) {
            return 0.0f;
        }
        return ArmorHelper.getRootTag(tool, root).func_74760_g(name);
    }

    private static void setTagFloat(ItemStack tool, String root, String name, float value) {
        ArmorHelper.initRootTag(tool);
        ArmorHelper.getRootTag(tool, root).func_74776_a(name, value);
    }

    private static boolean getTagBoolean(ItemStack tool, String root, String name) {
        if (!tool.func_77942_o()) {
            return false;
        }
        return ArmorHelper.getRootTag(tool, root).func_74767_n(name);
    }

    private static void setTagBoolean(ItemStack tool, String root, String name, boolean value) {
        ArmorHelper.initRootTag(tool);
        ArmorHelper.getRootTag(tool, root).func_74757_a(name, value);
    }

    private static String getTagString(ItemStack tool, String root, String name) {
        if (!tool.func_77942_o()) {
            return "";
        }
        return ArmorHelper.getRootTag(tool, root).func_74779_i(name);
    }

    private static void setTagString(ItemStack tool, String root, String name, String value) {
        ArmorHelper.initRootTag(tool);
        ArmorHelper.getRootTag(tool, root).func_74778_a(name, value);
    }

    private static void setTagPart(ItemStack tool, String name, ToolPart part, EnumMaterialGrade grade) {
        ArmorHelper.initRootTag(tool);
        ArmorHelper.getRootTag(tool, NBT_ROOT_CONSTRUCTION).func_74778_a(name, part.getKey() + "#" + grade.name());
    }

    public static String getOriginalOwner(ItemStack tool) {
        return ArmorHelper.getTagString(tool, NBT_ROOT_STATISTICS, NBT_STATS_ORIGINAL_OWNER);
    }

    public static void setOriginalOwner(ItemStack tool, EntityPlayer player) {
        ArmorHelper.setOriginalOwner(tool, player.func_70005_c_());
    }

    public static void setOriginalOwner(ItemStack tool, String name) {
        ToolHelper.setOriginalOwner(tool, name);
    }

    public static int getStatRedecorated(ItemStack tool) {
        return ArmorHelper.getTagInt(tool, NBT_ROOT_STATISTICS, NBT_STATS_REDECORATED);
    }

    public static void incrementStatRedecorated(ItemStack tool, int amount) {
        ArmorHelper.setTagInt(tool, NBT_ROOT_STATISTICS, NBT_STATS_REDECORATED, ArmorHelper.getStatRedecorated(tool) + amount);
    }

    public static float getStatDamageTaken(ItemStack tool) {
        return ArmorHelper.getTagFloat(tool, NBT_ROOT_STATISTICS, NBT_STATS_DAMAGE_TAKEN);
    }

    public static void incrementStatDamageTaken(ItemStack tool, float amount) {
        ArmorHelper.setTagFloat(tool, NBT_ROOT_STATISTICS, NBT_STATS_DAMAGE_TAKEN, ArmorHelper.getStatDamageTaken(tool) + amount);
    }
}

