/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.tile;

import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.init.ModBlocks;
import net.silentchaos512.gems.tile.TileChaosFlowerPot;

public class TilePhantomLight
extends TileEntity
implements ITickable {
    public static final int SPAWNER_CHECK_FREQUENCY = 1200;
    BlockPos spawnerPos = null;
    boolean playerPlaced = false;
    int ticksExisted = 0;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && ++this.ticksExisted % 1200 == 0 && !this.checkSpawnerStillExists()) {
            this.field_145850_b.func_175698_g(this.field_174879_c);
        }
        if (!this.field_145850_b.field_72995_K && GemsConfig.DEBUG_LOG_POTS_AND_LIGHTS && this.ticksExisted % GemsConfig.DEBUG_LOT_POTS_AND_LIGHTS_DELAY == 0) {
            SilentGems.logHelper.info((Object)("DEBUG: Phantom Light @ " + this.field_174879_c));
        }
    }

    private boolean checkSpawnerStillExists() {
        if (this.playerPlaced) {
            return true;
        }
        if (this.spawnerPos == null) {
            return false;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.spawnerPos);
        TileEntity tile = this.field_145850_b.func_175625_s(this.spawnerPos);
        return state.func_177230_c() == ModBlocks.chaosFlowerPot && tile != null && tile instanceof TileChaosFlowerPot && ((TileChaosFlowerPot)tile).getFlowerItemStack() != null;
    }

    public void setSpawnerPos(BlockPos pos) {
        this.spawnerPos = pos;
    }

    public void setPlacedByPlayer(boolean value) {
        this.playerPlaced = value;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.spawnerPos = new BlockPos(compound.func_74762_e("spawnerX"), compound.func_74762_e("spawnerY"), compound.func_74762_e("spawnerZ"));
        this.playerPlaced = compound.func_74767_n("placedByPlayer");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("spawnerX", this.spawnerPos != null ? this.spawnerPos.func_177958_n() : 0);
        compound.func_74768_a("spawnerY", this.spawnerPos != null ? this.spawnerPos.func_177956_o() : 0);
        compound.func_74768_a("spawnerZ", this.spawnerPos != null ? this.spawnerPos.func_177952_p() : 0);
        compound.func_74757_a("placedByPlayer", this.playerPlaced);
        return compound;
    }
}

