/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.tile;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.silentchaos512.gems.api.energy.IChaosAccepter;
import net.silentchaos512.gems.api.energy.IChaosProvider;
import net.silentchaos512.gems.lib.EnumPylonType;
import net.silentchaos512.gems.util.ChaosUtil;
import net.silentchaos512.lib.tile.TileInventorySL;
import net.silentchaos512.lib.util.StackHelper;

public class TileChaosPylon
extends TileInventorySL
implements ITickable,
IChaosProvider {
    public static final double SEARCH_RADIUS_PLAYER_SQUARED = 256.0;
    public static final int SEARCH_RADIUS_BLOCK = 6;
    public static final int SEND_CHAOS_DELAY = 100;
    public static final int MAX_CHAOS_STORED = 100000;
    public static final int MAX_CHAOS_TRANSFERED = 10000;
    public static final int CHAOS_GENERATION_RATE_PASSIVE = 10;
    public static final int CHAOS_GENERATION_RATE_BURNER = 100;
    protected int chaosStored;
    protected int burnTimeRemaining;
    protected int currentItemBurnTime;
    protected EnumPylonType pylonType = EnumPylonType.NONE;

    public EnumPylonType getPylonType() {
        return this.pylonType;
    }

    public void setPylonType(EnumPylonType type) {
        this.pylonType = type;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.chaosStored = Math.min(this.getCharge() + this.getEnergyProduced(), this.getMaxCharge());
            if (this.pylonType == EnumPylonType.BURNER) {
                this.burnFuel();
            }
            if (this.field_145850_b.func_82737_E() % 100L == 0L) {
                List<IChaosAccepter> accepters = ChaosUtil.getNearbyAccepters(this.field_145850_b, this.field_174879_c, 6, 6);
                List players = this.field_145850_b.func_175644_a(EntityPlayer.class, e -> e.func_174818_b(this.field_174879_c) < 256.0);
                if (!players.isEmpty() || !accepters.isEmpty()) {
                    int amountForEach = Math.min(10000, this.getCharge() / (accepters.size() + players.size()));
                    this.sendEnergyToAccepters(accepters, amountForEach);
                    this.sendEnergyToPlayers(players, amountForEach);
                }
            }
        }
    }

    protected void sendEnergyToAccepters(List<IChaosAccepter> list, int amountForEach) {
        if (this.getCharge() <= 0) {
            return;
        }
        for (IChaosAccepter accepter : list) {
            BlockPos target;
            if (this.getCharge() <= 0) {
                return;
            }
            int amount = Math.min(this.getCharge(), amountForEach);
            if ((amount = accepter.receiveCharge(amount, true)) <= 0 || !ChaosUtil.sendEnergyTo(this.field_145850_b, this.field_174879_c, target = ((TileEntity)accepter).func_174877_v(), amount)) continue;
            this.extractEnergy(amount, false);
        }
    }

    protected void sendEnergyToPlayers(List<EntityPlayer> list, int amountForEach) {
        if (this.getCharge() <= 0) {
            return;
        }
        for (EntityPlayer player : list) {
            if (this.getCharge() <= 0) {
                return;
            }
            int amount = Math.min(this.getCharge(), amountForEach);
            int amountPlayerCanAccept = ChaosUtil.getAmountPlayerCanAccept(player, amount);
            if (amountPlayerCanAccept <= 0 || !ChaosUtil.sendEnergyTo(this.field_145850_b, this.field_174879_c, (EntityLivingBase)player, amount = Math.min(amount, amountPlayerCanAccept))) continue;
            this.extractEnergy(amount, false);
        }
    }

    public ItemStack getFuel() {
        return this.func_70302_i_() > 0 ? this.func_70301_a(0) : StackHelper.empty();
    }

    private void burnFuel() {
        int fuelBurnTime;
        boolean markForUpdate = false;
        if (this.burnTimeRemaining > 0) {
            --this.burnTimeRemaining;
            markForUpdate = true;
        }
        if (this.burnTimeRemaining <= 0 && this.getCharge() < this.getMaxCharge() && StackHelper.isValid((ItemStack)this.getFuel()) && (fuelBurnTime = TileEntityFurnace.func_145952_a((ItemStack)this.getFuel())) > 0) {
            this.currentItemBurnTime = this.burnTimeRemaining = fuelBurnTime;
            this.func_70298_a(0, 1);
            if (StackHelper.isEmpty((ItemStack)this.getFuel())) {
                this.func_70299_a(0, this.getFuel().func_77973_b().getContainerItem(this.getFuel()));
            } else {
                this.func_70299_a(0, this.getFuel());
            }
            markForUpdate = true;
        }
        if (markForUpdate) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
        }
    }

    public boolean isBurningFuel() {
        return this.burnTimeRemaining > 0;
    }

    public int getBurnTimeRemaining() {
        return this.burnTimeRemaining;
    }

    public int getCurrentItemBurnTime() {
        return this.currentItemBurnTime;
    }

    public int getBurnTimeRemainingScaled(int k) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.burnTimeRemaining * k / this.currentItemBurnTime;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    public void onDataPacket(NetworkManager network, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound tags) {
        this.pylonType = EnumPylonType.getByMeta(tags.func_74762_e("MyPylonType"));
        super.func_145839_a(tags);
        this.chaosStored = tags.func_74762_e("Energy");
        this.burnTimeRemaining = tags.func_74762_e("BurnTime");
        if (this.func_70302_i_() > 0) {
            this.currentItemBurnTime = TileEntityFurnace.func_145952_a((ItemStack)this.func_70301_a(0));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        super.func_189515_b(tags);
        tags.func_74768_a("Energy", this.chaosStored);
        tags.func_74768_a("BurnTime", this.burnTimeRemaining);
        tags.func_74768_a("MyPylonType", this.pylonType.getMeta());
        return tags;
    }

    public String func_70005_c_() {
        return "ChaosPylon";
    }

    public int getEnergyProduced() {
        if (this.pylonType == EnumPylonType.BURNER && this.burnTimeRemaining <= 0) {
            return 0;
        }
        return this.pylonType.getChaosGenerationRate();
    }

    @Override
    public int getCharge() {
        return this.chaosStored;
    }

    @Override
    public int getMaxCharge() {
        return 100000;
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate) {
        int amount = Math.min(this.getCharge(), maxExtract);
        if (!simulate) {
            this.chaosStored -= amount;
        }
        return amount;
    }

    public int func_70302_i_() {
        return 1;
    }
}

