/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.skills;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.handler.PlayerDataHandler;
import net.silentchaos512.gems.item.tool.ItemGemAxe;
import net.silentchaos512.gems.lib.soul.ToolSoul;
import net.silentchaos512.gems.skills.ToolSkillDigger;
import net.silentchaos512.gems.util.SoulManager;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.lib.util.ChatHelper;

public class SkillLumberjack
extends ToolSkillDigger {
    public static final float DIG_SPEED_MULTIPLIER = 0.25f;
    public static final int CHAOS_COST = 250;
    public static final SkillLumberjack INSTANCE = new SkillLumberjack();

    @Override
    public void onGetBreakSpeed(PlayerEvent.BreakSpeed event) {
        int cost;
        if (!event.getState().func_177230_c().isWood((IBlockAccess)event.getEntityPlayer().field_70170_p, event.getPos())) {
            return;
        }
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get(event.getEntityPlayer());
        int n = cost = event.getEntityPlayer().field_71075_bZ.field_75098_d ? 0 : 250;
        if (data.chaos >= cost) {
            event.setNewSpeed(event.getNewSpeed() * 0.25f);
        }
    }

    @Override
    public int getCost(ItemStack tool, EntityPlayer player, BlockPos pos) {
        return 250;
    }

    @Override
    public boolean activate(ItemStack tool, EntityPlayer player, BlockPos pos) {
        World world = player.field_70170_p;
        IBlockState state = world.func_180495_p(pos);
        if (state == null || state.func_177230_c() == null) {
            return false;
        }
        if (ToolHelper.getToolTier(tool).ordinal() < EnumMaterialTier.SUPER.ordinal() || !ToolHelper.isSpecialAbilityEnabled(tool)) {
            return false;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if ((state.func_177230_c().isWood((IBlockAccess)world, pos) || state.func_185904_a() == Material.field_151583_m) && SkillLumberjack.detectTree(world, x, y, z, state.func_177230_c())) {
            if (player.field_71075_bZ.field_75098_d) {
                return false;
            }
            PlayerDataHandler.PlayerData data = PlayerDataHandler.get(player);
            int cost = this.getCost(tool, player, pos);
            if (data.chaos < cost) {
                String msg = SilentGems.localizationHelper.getLocalizedString("skill", "all.insufficientChaos", new Object[0]);
                ChatHelper.sendStatusMessage((EntityPlayer)player, (String)msg, (boolean)true);
                return false;
            }
            data.drainChaos(cost);
            ToolSoul soul = SoulManager.getSoul(tool);
            TreeBreakResult result = new TreeBreakResult();
            result.soul = soul;
            SkillLumberjack.breakTree(result, world, x, y, z, x, y, z, tool, state, player);
            ToolHelper.incrementStatBlocksMined(tool, result.blocksBroken);
            if (soul != null) {
                soul.addXp(result.xpEarned, tool, player);
            }
            return true;
        }
        return false;
    }

    public static boolean detectTree(World world, int x, int y, int z, Block wood) {
        int height = y;
        boolean foundTop = false;
        do {
            Block block;
            if ((block = world.func_180495_p(new BlockPos(x, ++height, z)).func_177230_c()) == wood) continue;
            --height;
            foundTop = true;
        } while (!foundTop);
        int numLeaves = 0;
        if (height - y < 50) {
            for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
                for (int yPos = height - 1; yPos <= height + 1; ++yPos) {
                    for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                        BlockPos pos = new BlockPos(xPos, yPos, zPos);
                        IBlockState leaves = world.func_180495_p(pos);
                        if (leaves == null || !leaves.func_177230_c().isLeaves(world.func_180495_p(pos), (IBlockAccess)world, pos)) continue;
                        ++numLeaves;
                    }
                }
            }
        }
        return numLeaves > 3;
    }

    private static void breakTree(TreeBreakResult result, World world, int x, int y, int z, int xStart, int yStart, int zStart, ItemStack tool, IBlockState state, EntityPlayer player) {
        ItemGemAxe axe = (ItemGemAxe)tool.func_77973_b();
        Block block = state.func_177230_c();
        BlockPos pos = new BlockPos(x, y, z);
        int meta = block.func_176201_c(state);
        for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
            for (int yPos = y; yPos <= y + 1; ++yPos) {
                for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                    float localHardness;
                    BlockPos localPos = new BlockPos(xPos, yPos, zPos);
                    IBlockState localState = world.func_180495_p(localPos);
                    Block localBlock = localState.func_177230_c();
                    if (block != localBlock) continue;
                    int harvestLevel = localBlock.getHarvestLevel(localState);
                    float f = localHardness = localBlock == null ? Float.MAX_VALUE : localState.func_185887_b(world, localPos);
                    if (harvestLevel > axe.getHarvestLevel(tool, "axe", player, localState) || !(localHardness >= 0.0f)) continue;
                    boolean cancel = false;
                    BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, localPos, localState, player);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    cancel = event.isCanceled();
                    int xDist = xPos - xStart;
                    int yDist = yPos - yStart;
                    int zDist = zPos - zStart;
                    if (9 * xDist * xDist + yDist * yDist + 9 * zDist * zDist >= 2500) continue;
                    if (cancel) {
                        SkillLumberjack.breakTree(result, world, xPos, yPos, zPos, xStart, yStart, zStart, tool, state, player);
                        continue;
                    }
                    int localMeta = localBlock.func_176201_c(localState);
                    if (localBlock != block || localMeta % 4 != meta % 4) continue;
                    if (!player.field_71075_bZ.field_75098_d) {
                        localBlock.func_180657_a(world, player, pos, state, world.func_175625_s(pos), tool);
                        axe.func_179218_a(tool, world, localState, localPos, (EntityLivingBase)player);
                        ++result.blocksBroken;
                        if (result.soul != null) {
                            result.xpEarned += result.soul.getXpForBlockHarvest(world, localPos, localState);
                        }
                    }
                    world.func_175698_g(localPos);
                    if (world.field_72995_K) continue;
                    SkillLumberjack.breakTree(result, world, xPos, yPos, zPos, xStart, yStart, zStart, tool, state, player);
                }
            }
        }
    }

    @Override
    public String getTranslatedName() {
        return SilentGems.localizationHelper.getLocalizedString("skill", "Lumberjack", new Object[0]);
    }

    static class TreeBreakResult {
        int blocksBroken = 0;
        int xpEarned = 0;
        @Nullable
        ToolSoul soul = null;

        TreeBreakResult() {
        }
    }
}

